<?php 

/*-----------------------------------
    PRE LOADER SECTION
------------------------------------*/
CSF::createSection( CLIPER_OPTION_KEY,
	array(
		'title'  => esc_html__( 'Preloader', 'cliper' ),
		'icon'   => 'fa fa-spinner fa-pulse',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Preloader ON / OFF', 'cliper' ),
			),
			array(
				'id'      => 'enable_preloader',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Enable Preloader', 'cliper' ),
				'desc'    => esc_html__( 'If you want to enable or disable preloader you can set ( YES / NO )', 'cliper' ),
				'default' => true,
			),
			array(
				'id'         => 'enable_custom_preloader',
				'type'       => 'switcher',
				'title'      => esc_html__( 'Add Custom Preloader ?', 'cliper' ),
				'desc'       => esc_html__( 'If you want to add custom image for preloader you can set ( YES / NO )', 'cliper' ),
				'default'    => false,
				'dependency' => array( 'enable_preloader', '==', 'true' ),
			),
			array(
				'id'         => 'add_preloader_image',
				'type'       => 'media',
				'title'      => esc_html__( 'Add Custom Image', 'cliper' ),
				'desc'       => esc_html__( 'Add the custom image for preloader.', 'cliper' ),
				'library'    => 'image',
				'dependency' => array( 'enable_preloader|enable_custom_preloader', '==|', 'true|true' ),
			),		
			array(
				'id'      => 'preloader_style',
				'type'    => 'image_select',
				'class'   => 'preloader_section',
				'title'   => esc_html__( 'Select Preloader Style', 'cliper' ),
				'desc'    => esc_html__( 'You can set specific preloader style in every page form here.', 'cliper' ),
				'options' => array(
					'style_3'  => CLIPER_ROOT_IMAGE .'/loader/loader_3.png',
					'style_4'  => CLIPER_ROOT_IMAGE .'/loader/loader_horizontal.gif',
					'style_5'  => CLIPER_ROOT_IMAGE .'/loader/loader_spinner.gif',
					'style_6'  => CLIPER_ROOT_IMAGE .'/loader/loader_spinner.svg',
					'style_7'  => CLIPER_ROOT_IMAGE .'/loader/loader_square_circle.gif',
					'style_8'  => CLIPER_ROOT_IMAGE .'/loader/loader_wave.gif',
					'style_9'  => CLIPER_ROOT_IMAGE .'/loader/loeader_square.gif',
					'style_10' => CLIPER_ROOT_IMAGE .'/loader/wave_preloader.svg',
					'style_11' => CLIPER_ROOT_IMAGE .'/loader/ajax_loader.svg',
					'style_12' => CLIPER_ROOT_IMAGE .'/loader/audio.svg',
					'style_13' => CLIPER_ROOT_IMAGE .'/loader/ball_triangle.svg',
					'style_14' => CLIPER_ROOT_IMAGE .'/loader/bars.svg',
					'style_15' => CLIPER_ROOT_IMAGE .'/loader/circle_pulse_rings.svg',
					'style_16' => CLIPER_ROOT_IMAGE .'/loader/circle_tail_spin.svg',
					'style_17' => CLIPER_ROOT_IMAGE .'/loader/circles.svg',
					'style_18' => CLIPER_ROOT_IMAGE .'/loader/flip_circle.svg',
					'style_19' => CLIPER_ROOT_IMAGE .'/loader/grid.svg',
					'style_20' => CLIPER_ROOT_IMAGE .'/loader/heart.svg',
					'style_21' => CLIPER_ROOT_IMAGE .'/loader/hearts_group.svg',
					'style_22' => CLIPER_ROOT_IMAGE .'/loader/horizontal_loader_2.svg',
					'style_23' => CLIPER_ROOT_IMAGE .'/loader/road_cross.svg',
					'style_24' => CLIPER_ROOT_IMAGE .'/loader/round_circle.svg',
					'style_25' => CLIPER_ROOT_IMAGE .'/loader/round_pulse.svg',
					'style_26' => CLIPER_ROOT_IMAGE .'/loader/simple_spainer.svg',
					'style_27' => CLIPER_ROOT_IMAGE .'/loader/spinner.svg',
					'style_28' => CLIPER_ROOT_IMAGE .'/loader/spinning_circles.svg',
					'style_29' => CLIPER_ROOT_IMAGE .'/loader/three_dots.svg',
				),
				'default'    => 'style_22',
				'dependency' => array( 'enable_preloader|enable_custom_preloader', '==|==', 'true|false' ),
			),
			array(
				'type'       => 'subheading',
				'content'    => esc_html__( 'Preloader Background & Color', 'cliper' ),
				'dependency' => array( 'enable_preloader', '==', 'true' ),
			),
			array(
				'id'                    => 'preloader_bg',
				'type'                  => 'background',
				'title'                 => esc_html__( 'Preloader Background', 'cliper' ),
				'subtitle'              => esc_html__( 'Set the preloader background.', 'cliper' ),
				'desc'                  => esc_html__( 'Set the preloader background color, image, transparent image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
				'background_image'      => true,
				'background_position'   => true,
				'background_repeat'     => true,
				'background_attachment' => true,
				'background_size'       => true,
				'background_gradient'   => true,
				'background_origin'     => true,
				'background_clip'       => true,
				'background_blend_mode' => true,
				'output'                => '.cliper-preeloader',
				'default'               => array(
					'background-color'              => '#ffffff',
					'background-size'               => 'cover',
					'background-position'           => 'center center',
					'background-repeat'             => 'repeat',
				),
				'dependency' => array( 'enable_preloader', '==', 'true' ),
			),
            array(
				'id'         => 'preloader_text_color',
				'type'       => 'color',
				'title'      => esc_html__( 'Preloader Text Color', 'cliper' ),
				'desc'       => esc_html__( 'Set the preloader text color', 'cliper' ),
				'default'    => '#438FF9',
				'output'     => array( '.cliper-preeloader','.preloader-spinner' ),
				'dependency' => array( 'enable_preloader', '==', 'true' ),
            ),
	    ),
	)
);