<?php

/*-----------------------------------
    mobile MENU SECTION
------------------------------------*/
$info       = wp_get_theme();
$author_uri = $info->get( 'AuthorURI' );
CSF::createSection( CLIPER_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'mobile Menu', 'cliper' ),
        'icon'   => 'fa fa-tablet',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'mobile Menu Layout & Menu Open Buttons', 'cliper' ),
            ),
            array(
                'id'      => 'mobile_menu_style',
                'type'    => 'select',
                'title'   => esc_html__( 'mobile Menu Layout', 'cliper' ),
                'desc'    => esc_html__( 'Set the mobile menu style form here.', 'cliper' ),
                'options' => array(
                    'static' => esc_html__( 'Menu Position Top', 'cliper' ),
                    'left'   => esc_html__( 'Menu Position Left', 'cliper' ),
                    'right'  => esc_html__( 'Menu Position Right', 'cliper' ),
                    'offcanvas'  => esc_html__( 'Menu Offcanvas', 'cliper' ),
                ),
                'default' => 'static',
            ),
            array(
                'id'         => 'contact_number',
                'type'       => 'text',
                'title'      => esc_html__( 'Contact Phone', 'cliper' ),
                'desc'       => esc_html__( 'Set the mobile menu contact phone no.', 'cliper' ),
                'default'    => '+0001234567890',
                'dependency' => array( 'mobile_menu_style', 'any', 'left,right' ),
            ),
            array(
                'id'         => 'contact_location',
                'type'       => 'text',
                'title'      => esc_html__( 'Contact Link', 'cliper' ),
                'desc'       => esc_html__( 'Set the mobile menu contact link here.', 'cliper' ),
                'default'    => $author_uri,
                'dependency' => array( 'mobile_menu_style', 'any', 'left,right' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'mobile Menu Background', 'cliper' ),
            ),
            array(
                'id'                    => 'mobile_menu_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the menu background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the menu background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.menu__mobile__style .mainnav-area-bg',
            ),
            array(
                'id'          => 'mobile_menu_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Background Opacity', 'cliper' ),
                'desc'        => esc_html__( 'Set the menu background opacity here use max value 99 and minimum value 1 in decimal.', 'cliper' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 1,
                'output_mode' => 'opacity',
                'output'      => '.menu__mobile__style .mainnav-area-bg',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'mobile Menu Sticky Background', 'cliper' ),
            ),
            array(
                'id'                    => 'mobile_menu_sticky_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Sticky Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the menu sticky background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the menu sticky background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.menu__mobile__style .is-sticky .mainnav-area-bg',
            ),
            array(
                'id'          => 'mobile_menu_sticky_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Sticky Background Opacity', 'cliper' ),
                'desc'        => esc_html__( 'Set the menu sticky background opacity here use max value 99 and minimum value 1 in decimal.', 'cliper' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 1,
                'output_mode' => 'opacity',
                'output'      => '.menu__mobile__style .is-sticky .mainnav-area-bg',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'mobile Menu Color', 'cliper' ),
            ),
            array(
                'id'      => 'mobile_menu_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu color by color picker', 'cliper' ),
                'default' => '#00274e',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_menu_hover',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Active & Hover Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu item active &hover color by color picker', 'cliper' ),
                'default' => '#438FF9',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_menu_hover_background',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Active Background Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu active background color by color picker', 'cliper' ),
                'default' => '#ffffff',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'mobile Menu Hamburger Color & Background', 'cliper' ),
            ),
            array(
                'id'      => 'mobile_menu_hamburger_color',
                'type'    => 'color',
                'title'   => esc_html__( ' Menu Hamburger Background', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu hamburger background color by color picker', 'cliper' ),
                'default' => '#1A152E',
                'output'  => array(),
            ),
            array(
                'id'      => 'mobile_sticky_menu_hamburger_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Sticky Menu Hamburger Background', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu hamburger color by color picker', 'cliper' ),
                'default' => '#1A152E',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'mobile Menu Border', 'cliper' ),
            ),
            array(
                'id'      => 'mobile_menu_border_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Bottom Border Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu border bottom color by color picker', 'cliper' ),
                'default' => 'rgba(255,255,255,.15)',
                'output'  => array(),
            ),
        )
    )
);