<?php

/*-----------------------------------
MAINMENU SECTION
------------------------------------*/
CSF::createSection( CLIPER_OPTION_KEY,
    array(
        'parent' => 'Header_Tab',
        'title'  => esc_html__( 'Main Menu', 'cliper' ),
        'icon'   => 'fa fa-sitemap',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'One Page Navigation Setting', 'cliper' ),
            ),
            array(
                'id'      => 'one_page_navigation',
                'type'    => 'switcher',
                'title'   => esc_html__( 'One Page Navigation On ?', 'cliper' ),
                'desc'    => esc_html__( 'If you want to enable or disable one page menu link effect it will be effect inside the page (#) links.', 'cliper' ),
                'default' => false,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Sticky', 'cliper' ),
            ),
            array(
                'id'      => 'sticky_menu',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Sticky Menu ?', 'cliper' ),
                'desc'    => esc_html__( 'If you want to enable or disable menu sticky in header section you can set ( YES / NO )', 'cliper' ),
                'default' => true,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Header Action Buttons', 'cliper' ),
            ),
            array(
                'id'      => 'enable_header_actions',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Header Action Buttons', 'cliper' ),
                'desc'    => esc_html__( 'If you want to enable or disable header area action buttons you can set ( YES / NO )', 'cliper' ),
                'default' => false,
            ),
            array(
                'type'       => 'subheading',
                'content'    => esc_html__( 'Menu Action Buttons', 'cliper' ),
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_search',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Search Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable search button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_offcanvas',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable OffCanvas Sidebar Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable offcanvas button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),


            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Elementor Offcanvas', 'cliper' ),
            ),
            array(
                'id'      => 'enable_offcanvas_content',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Elementor Template', 'cliper' ),
                'desc'    => esc_html__( 'If you want to set Elementor template as offcanvas template you can set ( YES / NO )', 'cliper' ),
                'default' => false,
            ),
            array(
                'id'      => 'elementor_offcanvas_content',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Offcanvas Template Style', 'cliper' ),
                'desc'    => esc_html__( 'You can chose and select offcanvas template type here, it will be effect in offcanvas panel content template..', 'cliper' ),
                'options' => cliper_get_elementor_post_array(),
                'dependency' => array( 'enable_offcanvas_content', '==', 'true' ),
            ),


            array(
                'id'         => 'enable_cart_button',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Curt Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable cart button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_promo_menu',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Promo Menu Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable pro menu button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_user_menu',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable User Menu Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable user menu button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_language_button',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Language Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable Language button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'enable_action_alt',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Action Button Alt', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable action button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'button_text_alt',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Text Alt', 'cliper' ),
                'desc'       => esc_html__( 'Set the button text alt here', 'cliper' ),
                'dependency' => array( 'enable_action_alt', '==', 'true' ),
                'default'    => 'User',
            ),
            array(
                'id'         => 'button_url_alt',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Link Alt', 'cliper' ),
                'desc'       => esc_html__( 'Set the button link alt here', 'cliper' ),
                'dependency' => array( 'enable_action_alt', '==', 'true' ),
                'default'    => '#',
            ),
            array(
                'id'         => 'enable_action',
                'type'       => 'switcher',
                'title'      => esc_html__( 'Enable Action Button', 'cliper' ),
                'desc'       => esc_html__( 'If you want to enable or disable action button in menu section you can set ( YES / NO )', 'cliper' ),
                'default'    => false,
                'dependency' => array( 'enable_header_actions', '==', 'true' ),
            ),
            array(
                'id'         => 'button_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Text', 'cliper' ),
                'desc'       => esc_html__( 'Set the button text here', 'cliper' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => 'Sign Up',
            ),
            array(
                'id'         => 'button_url',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Link', 'cliper' ),
                'desc'       => esc_html__( 'Set the button link here', 'cliper' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => '#',
            ),
            array(
                'id'         => 'button_text_2',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Text 2', 'cliper' ),
                'desc'       => esc_html__( 'Set the button text here', 'cliper' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => 'Login',
            ),
            array(
                'id'         => 'button_url_2',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Link 2', 'cliper' ),
                'desc'       => esc_html__( 'Set the button link here', 'cliper' ),
                'dependency' => array( 'enable_action', '==', 'true' ),
                'default'    => '#',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Width & Align', 'cliper' ),
            ),
            array(
                'id'      => 'menu_width',
                'type'    => 'select',
                'title'   => esc_html__( 'Menu Container Width', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu with form here you can set ( FULLWIDTH / CONTAINER )', 'cliper' ),
                'options' => array(
                    'container'                 => esc_html__( 'Container', 'cliper' ),
                    'container container-full-width' => esc_html__( 'Container Full Width', 'cliper' ),
                    'container-fluid'           => esc_html__( 'Full Width', 'cliper' ),
                ),
                'default' => 'container container-full-width',
            ),
            array(
                'id'      => 'menu_align',
                'type'    => 'select',
                'title'   => esc_html__( 'Menu Text Align', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu text align from here', 'cliper' ),
                'options' => array(
                    'left'   => 'Left',
                    'center' => 'Center',
                    'right'  => 'Right',
                ),
                'default' => CLIPER_HEADER_ALIGN,
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Area Background', 'cliper' ),
            ),
            array(
                'id'                    => 'menu_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the menu background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the menu background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.mainnav-area-bg',
            ),
            array(
                'id'          => 'menu_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Background Opacity', 'cliper' ),
                'desc'        => esc_html__( 'Set the menu background opacity here use max value 99 and minimum value 1 in decimal.', 'cliper' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 0,
                'output_mode' => 'opacity',
                'output'      => '.mainnav-area-bg',
            ),
            array(
                'id'                    => 'sticky_menu_bg',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Menu Sticky Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the menu sticky background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the menu sticky background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.is-sticky .mainnav-area-bg,.sticky-active .mainnav-area-bg',
            ),
            array(
                'id'          => 'sticky_menu_bg_opacity',
                'type'        => 'slider',
                'title'       => esc_html__( 'Sticky Background Opacity', 'cliper' ),
                'desc'        => esc_html__( 'Set the menu sticky background opacity here use max value 99 and minimum value 1 in decimal.', 'cliper' ),
                'min'         => 0,
                'max'         => 1,
                'step'        => 0.01,
                'unit'        => ' ',
                'default'     => 1,
                'output_mode' => 'opacity',
                'output'      => '.is-sticky .mainnav-area-bg,.sticky-active .mainnav-area-bg',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Typography', 'cliper' ),
            ),
            array(
                'id'                 => 'menu_font',
                'type'               => 'typography',
                'title'              => esc_html__( 'Menu Typography', 'cliper' ),
                'subtitle'           => esc_html__( 'Set the menu font typo for whole theme.', 'cliper' ),
                'chosen'             => true,
                'color'              => false,
                'text_align'         => false,
                'text_transform'     => true,
                'letter_spacing'     => true,
                'word_spacing'       => true,
                'font_weight'        => true,
                'line_height'        => true,
                'custom_style'       => true,
                'backup_font_family' => true,
                'unit'               => 'px',
                'preview'            => 'always',
                'output'             => 'ul#cliper-nav li a',
                'default'            => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Color', 'cliper' ),
            ),
            array(
                'id'      => 'menu_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu color by color picker', 'cliper' ),
                'default' => '#131313',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_hover',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Hover Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu hover color by color picker', 'cliper' ),
                'default' => '#438FF9',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Sticky Color', 'cliper' ),
            ),
            array(
                'id'      => 'menu_sticky_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Sticky Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu sticky color by color picker', 'cliper' ),
                'default' => '#131313',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_sticky_hover_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Sticky Hover Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu sticky hover color by color picker', 'cliper' ),
                'default' => '#438FF9',
                'output'  => array(),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Dropdown Color & Hover', 'cliper' ),
            ),
            array(
                'id'      => 'menu_dropdown_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu dropdown color by color picker', 'cliper' ),
                'default' => '#8B8B8B',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_dropdown_hover_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Hover Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu dropdown hover color by color picker', 'cliper' ),
                'default' => '#438FF9',
                'output'  => array(),
            ),
            array(
                'id'      => 'menu_dropdown_hover_background',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Hover Background Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the dropdown background color by color picker', 'cliper' ),
                'default' => 'transparent',
                'output'  => array(),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Item Animated Border', 'cliper' ),
            ),
            array(
                'id'      => 'enable_menu_item_animated_border',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Menu Animated Border', 'cliper' ),
                'desc'    => esc_html__( 'If you want to enable or disable animated border in menu item you can set ( YES / NO )', 'cliper' ),
                'default' => false,
            ),
            array(
                'id'         => 'menu_item_animated_border_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Animated Border Color', 'cliper' ),
                'desc'       => esc_html__( 'Set the menu animated border bottom color by color picker', 'cliper' ),
                'default'    => '#f8f8f8',
                'output'     => array( 'background' => 'ul#cliper-nav > li.menu-item .wee' ),
                'dependency' => array( 'enable_menu_item_animated_border', '==', 'true' ),
            ),
            array(
                'id'      => 'enable_dropdown_menu_item_animated_border',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Dropdown Menu Animated Border', 'cliper' ),
                'desc'    => esc_html__( 'If you want to enable or disable animated border in menu item you can set ( YES / NO )', 'cliper' ),
                'default' => false,
            ),
            array(
                'id'         => 'menu_dropdown_item_animated_border_color',
                'type'       => 'color',
                'title'      => esc_html__( 'Menu Dropdown Animated Border Color', 'cliper' ),
                'desc'       => esc_html__( 'Set the menu animated border bottom color by color picker', 'cliper' ),
                'output'     => array( 'background' => 'ul#cliper-nav li ul li a:after' ),
                'dependency' => array( 'enable_dropdown_menu_item_animated_border', '==', 'true' ),
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Area Border Color', 'cliper' ),
            ),
            array(
                'id'      => 'menu_border_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Border Color', 'cliper' ),
                'desc'    => esc_html__( 'Set the menu border bottom color by color picker', 'cliper' ),
                'default' => 'transparent',
                'output'  => array(),
            ),
        ),
    )
);