<?php

/*-----------------------------------
    GLOBAL DESIGN SECTION
------------------------------------*/
CSF::createSection( CLIPER_OPTION_KEY,
    array(
        'title'  => esc_html__( 'Global Design', 'cliper' ),
        'parent' => 'General_Tab',
        'icon'   => 'fa fa-magic',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'General', 'cliper' ),
            ),
            array(
                'id'                    => 'body_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Body Background ( Color, Image & Gradient Color )', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the body background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the body background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => 'body',
            ),
            array(
                'id'      => 'body_link_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Link Color & Hover Color', 'cliper' ),
                'output'  => 'a',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Post Items', 'cliper' ),
            ),
            array(
                'id'                    => 'post_item_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Post Item Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the post background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the post background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.single-post-item .post-details',
            ),
            array(
                'id'     => 'post_item_border',
                'type'   => 'border',
                'title'  => esc_html__( 'Post Item Border', 'cliper' ),
                'output' => '.single-post-item .post-details'
            ),
            array(
                'id'      => 'post_item_readmore_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Readmore Color & Hover Color', 'cliper' ),
                'output'  => '.posts__readmore a',
            ),
            array(
                'id'      => 'post_author_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Author Color & Hover Color', 'cliper' ),
                'output'  => '.cliper-post-author a',
            ),
            array(
                'id'      => 'post_meta',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Meta Color & Hover Color', 'cliper' ),
                'output'  => '.cliper-single-random-category a',
            ),
            array(
                'id'                    => 'post_item_meta_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Post Item Meta Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the post meta background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the post meta background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.cliper-single-random-category a',
            ),
            array(
                'id'                    => 'post_item_meta_hover_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Post Item Meta Hover Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the post meta hover background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the post meta hover background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.cliper-single-random-category a:hover',
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Sidebar Widgets', 'cliper' ),
            ),
            array(
                'id'                    => 'sidebar_widget_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Sidebar Widget Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the sidebar widget background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the sidebar widget background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.blog__widgets__wrap .cliper-single-widgets',
            ),
            array(
                'id'     => 'sidebar_widget_border',
                'type'   => 'border',
                'title'  => esc_html__( 'Widget Border', 'cliper' ),
                'output' => '.blog__widgets__wrap .cliper-single-widgets'
            ),
            array(
                'id'     => 'sidebar_widget_heading',
                'type'   => 'color',
                'title'  => esc_html__( 'Widget Title', 'cliper' ),
                'output' => '.blog__widgets__wrap .widget-title h3'
            ),
            array(
                'id'          => 'sidebar_widget_heading_before',
                'type'        => 'color',
                'title'       => esc_html__( 'Widget Title Before', 'cliper' ),
                'output_mode' => 'background',
                'output'      => '.blog__widgets__wrap .widget-title h3:before'
            ),
            array(
                'id'     => 'sidebar_widget_heading_border',
                'type'   => 'border',
                'title'  => esc_html__( 'Widget Title Border', 'cliper' ),
                'output' => '.blog__widgets__wrap .widget-title h3'
            ),
            array(
                'id'      => 'sidebar_widget_link_color',
                'type'    => 'link_color',
                'title'   => esc_html__( 'Widget link Color', 'cliper' ),
                'output'  => '.blog__widgets__wrap .cliper-single-widgets a',
            ),
        ),
    )
);