<?php

/*-----------------------------------
    FOOTER GENERAL SECTION
------------------------------------*/
CSF::createSection( CLIPER_OPTION_KEY,
    array(
        'parent' => 'Footer_Tab',
        'title'  => esc_html__( 'Footer General Settings', 'cliper' ),
        'icon'   => 'fa fa-cogs',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Elementor Footer', 'cliper' ),
            ),
            array(
                'id'      => 'add_footer_template',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Footer Template', 'cliper' ),
                'desc'    => esc_html__( 'If you want to set Elementor template as footer template you can set ( YES / NO )', 'cliper' ),
                'default' => false,
            ),
            array(
                'id'      => 'elementor_footer_style',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Footer Style', 'cliper' ),
                'desc'    => esc_html__( 'You can chose and select footer type here..', 'cliper' ),
                'options' => cliper_get_elementor_post_array(),
                'dependency' => array( 'add_footer_template', '==', 'true' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Enable Elementor Global Footer For Blog', 'cliper' ),
            ),
            array(
                'id'      => 'add_global_footer_template',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Add Footer Template', 'cliper' ),
                'desc'    => esc_html__( 'If you want to set Elementor template as footer template you can set ( YES / NO )', 'cliper' ),
                'default' => false,
            ),
            array(
                'id'      => 'elementor_footer_style_global',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Footer Style', 'cliper' ),
                'desc'    => esc_html__( 'You can chose and select footer type here, it will be effect in global blog default pages template..', 'cliper' ),
                'options' => cliper_get_elementor_post_array(),
                'dependency' => array( 'add_global_footer_template', '==', 'true' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer General Settings', 'cliper' ),
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),
            array(
                'id'      => 'hide_footer',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Hide Footer ?', 'cliper' ),
                'desc'    => esc_html__( 'If you want do not show the footer you can set here by ( YES / NO ).', 'cliper' ),
                'default' => false,
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),
            array(
                'id'      => 'sticky_footer',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Sticky Footer ?', 'cliper' ),
                'desc'    => esc_html__( 'You can set footer sticky here. just set ( YES / NO ).', 'cliper' ),
                'default' => false,
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),

            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Background & Overlay', 'cliper' ),
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),
            array(
                'id'                    => 'footer_background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Footer Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the footer background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the footer background color, image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'default'               => '#00152e',
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.footer-area-bg',
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),
            array(
                'id'                    => 'footer_overlay',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Footer Overlay Background', 'cliper' ),
                'subtitle'              => esc_html__( 'Set the footer overlay background.', 'cliper' ),
                'desc'                  => esc_html__( 'Set the footer overlay background color, transparent image and gradient color. If you set only first color field it will be a simple solid color for background and if set 2nd color field too it will be set a gradient color and if you set a image it will be set a background image.', 'cliper' ),
                'default'               => '#00152e',
                'background_image'      => true,
                'background_position'   => true,
                'background_repeat'     => true,
                'background_attachment' => true,
                'background_size'       => true,
                'background_gradient'   => true,
                'background_origin'     => true,
                'background_clip'       => true,
                'background_blend_mode' => true,
                'output'                => '.footer-area-bg:after',
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),
            array(
                'id'               => 'footer_overlay_opacity',
                'type'             => 'slider',
                'title'            => esc_html__( 'Overlay Opacity', 'cliper' ),
                'desc'             => esc_html__( 'Set the background footer background overlay opacity input the max value 1 in decimal.', 'cliper' ),
                'min'              => 0,
                'max'              => 1,
                'step'             => 0.01,
                'unit'             => ' ',
                'default'          => 0.5,
                'output_mode'      => 'opacity',
                'output'           => '.footer-area-bg:after',
                //'output_important' => true,
                'dependency' => array( 'add_footer_template', '==', 'false' ),
            ),
        ),
    )
);