<?php
/**
 * mayosis Product Details Widget
 *
 */

if ( class_exists( 'Easy_Digital_Downloads' ) ) :

	class cliper_Market_Product_Information_Widget extends WP_Widget {

		/** Constructor */
		public function __construct() {
			parent::__construct(
				'becore_edd_information_widget',
				sprintf( esc_html__( 'cliper %s Information', 'becore' ), edd_get_label_singular() ),
				array(
					'description' => sprintf( esc_html__( 'Display the details of a specific %s', 'becore' ), edd_get_label_singular() ),
				)
			);
		}

		/** @see WP_Widget::widget */
		public function widget( $args, $instance ) {

			$args['id'] = ( isset( $args['id'] ) ) ? $args['id'] : 'edd_download_details_widget';
			if ( ! isset( $instance['download_id'] ) || ( 'current' == $instance['download_id'] && ! is_singular( 'download' ) ) ) {
				return;
			}
			// set correct download ID
			if ( 'current' == $instance['download_id'] && is_singular( 'download' ) ) {
				$download_id = get_the_ID();
			} else {
				$download_id = absint( $instance['download_id'] );
			}

			global $post;
			global $edd_logs;
			/*$download_id      = get_the_ID();*/
			$single_count       = $edd_logs->get_log_count(66, 'file_download');
			$total_count        = $edd_logs->get_log_count('*', 'file_download');
			$price              = edd_get_download_price( $download_id );
			
			$sales              = edd_get_download_sales_stats( get_the_ID() );
			$sales              = $sales > 1 ? $sales . ' Sales' : $sales . ' Sale';
			
			$download_tags      = get_the_term_list( $download_id, 'download_tag',  ' ', ' ');
			$release_date       = get_the_date();
			$modified_date      = get_the_modified_date();
			$download_category  = get_the_category( $download_id );
			//$tota_file_size     = cliper_edd_show_total_file_size( get_the_id() );
			
			/*Variables from widget settings*/
			$title              = apply_filters( 'widget_title', $instance[ 'title' ] );
			
			/*------------------------
				START CONTENT
			-------------------------*/
			echo $args['before_widget'];

	 		if ( ! empty( $title ) ) {
				echo $args['before_title'] . $title . $args['after_title'];
			}
		?>

			<div class="product__information__widget single__product__widget">

				<!-- Rleased Date -->
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Released','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html(get_the_date()); ?></div>
				</div>

				<!-- Updated -->
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Updated','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html(get_the_modified_date()); ?></div>
				</div>
				
				<!-- Price -->
				<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Price','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php edd_price($download_id); ?></div>
				</div>

				<!-- FIle Type -->
	      		<?php $file_type = get_post_meta( $download_id, '_file_type', true ); ?>
	      		<?php if ( $file_type ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('File Type','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($file_type); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Version -->
	      		<?php $file_version = get_post_meta( $download_id, '_file_version', true ); ?>
	      		<?php if ( $file_version ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Version','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($file_version); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Licence -->
	      		<?php $file_licence = get_post_meta( $download_id, '_file_licence', true ); ?>
	      		<?php if ( $file_licence ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Licence','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($file_licence); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Size -->
	      		<?php $file_size = get_post_meta( $download_id, '_file_size', true ); ?>
	      		<?php if ( $file_size ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('File Size','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($file_size); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Documentation-->
	      		<?php $documentation = get_post_meta( $download_id, '_documentation', true ); ?>
	      		<?php if ( $documentation ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Documentation','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($documentation); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Compatible With-->
	      		<?php $compatible_with = get_post_meta( $download_id, '_compatible_with', true ); ?>
	      		<?php if ( $compatible_with ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Compatible With','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($compatible_with); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Framework-->
	      		<?php $file_framework = get_post_meta( $download_id, '_file_framework', true ); ?>
	      		<?php if ( $file_framework ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Framework','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html( $file_framework ); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Layout-->
	      		<?php $file_layout = get_post_meta( $download_id, '_file_layout', true ); ?>
	      		<?php if ( $file_layout ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Layout','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html( $file_layout ); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Supported Browser-->
	      		<?php $file_supported_browser = get_post_meta( $download_id, '_file_supported_browser', true ); ?>
	      		<?php if ( $file_supported_browser ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Browsers','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html( $file_supported_browser ); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Included -->
	      		<?php $file_included = get_post_meta( $download_id, '_file_included', true ); ?>
	      		<?php if ( $file_included ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('File Included','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo esc_html($file_included); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Category-->
	      		<?php $download_cats = get_the_term_list( get_the_ID(), 'download_category', '', _x('  ', '', 'becore' ), '' ); ?>
	      		<?php if ( $download_cats ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Categories','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo wp_kses( $download_cats, allowed_tags('blog') ); ?></div>
				</div>
				<?php endif; ?>

				<!-- FIle Tags-->
	      		<?php $download_tags = get_the_term_list( get_the_ID(), 'download_tag', '', _x(', ', '', 'becore' ), '' ); ?>
	      		<?php if ( $download_tags ) : ?>
	         	<div class="single__product__info">
					<div class="product__info__left"><?php esc_html_e('Tags','becore'); ?></div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right"><?php echo wp_kses( $download_tags, allowed_tags('blog') ); ?></div>
				</div>
				<?php endif; ?>
				
				<!-- FIle Sales Download Count --> 
	         	<div class="single__product__info">
					<div class="product__info__left">
						<?php
							if( $price == "0.00"  ){
								esc_html_e('Downloads','mayosis');
							}else{
								esc_html_e('Sales','mayosis');
							}
						?>
					</div>
					<div class="product__info__separator">:</div>
					<div class="product__info__right">
						<?php
						    if( $price == "0.00"  ){
								$download = $edd_logs->get_log_count(get_the_ID(), 'file_download'); 
								echo ( is_null( $download ) ? '0' : $download );
								esc_html_e('Downloads','becore'); 
						    }else{
						    	echo esc_html($sales);
						    }
						?>
					</div>
				</div>
			</div>
			<?php
			echo $args['after_widget'];
		}
		
		public function form( $instance ) {
			/*Set up some default widget settings.*/
			$defaults = array(
				'title'                => sprintf( esc_html__( '%s Information', 'becore' ), edd_get_label_singular() ),
				'download_id'          => 'current',
			);
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'becore' ) ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
			</p>

			<?php
				$args = array(
					'post_type'      => 'download',
					'posts_per_page' => -1,
					'post_status'    => 'publish',
					);
				$downloads = get_posts( $args );
			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'download_id' ) ); ?>"><?php printf( esc_html__( '%s', 'becore' ), edd_get_label_singular() ); ?></label>
				<select class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'download_id' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'download_id' ) ); ?>">
					<option value="current"><?php esc_html_e( 'Use current', 'becore' ); ?></option>
					<?php foreach ( $downloads as $download ) { ?>
					<option <?php selected( absint( $instance['download_id'] ), $download->ID ); ?> value="<?php echo esc_attr( $download->ID ); ?>"><?php echo esc_html($download->post_title); ?></option>
					<?php } ?>
				</select>
			</p>

			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$instance                         = $old_instance;
			$instance['title']                = sanitize_text_field( $new_instance['title'] );
			$instance['download_id']          = strip_tags( $new_instance['download_id'] );

			return $instance;
		}
	}

	function becore_edd_information_widget(){
		register_widget('cliper_Market_Product_Information_Widget');
	}
	add_action('widgets_init', 'becore_edd_information_widget');

endif;
