<?php
if ( class_exists( 'Easy_Digital_Downloads' ) ) :

	class cliper_Market_Product_Author_Widget extends WP_Widget {

		/*----------------------------
			CONSTRUCTOR
		------------------------------*/
		public function __construct() {
			parent::__construct(
				'becore_download_author_widget',
				esc_html__( 'Download Author Information', 'becore' ),
				array(
					'description' => esc_html__( 'Display the product author details.', 'becore' ),
					'classname'   => 'download__author__widget',
				)
			);
		}

		/*----------------------------
			WIDGET DISPLAY DATA
		------------------------------*/
		function widget($args, $instance){

			if ( ! is_singular( 'download' ) ) {
				return;
			}

			$title           = $instance['title'];
			global $post;
			global $edd_logs;
			$author                      = $post->post_author; /* Get Author ID As String Value */
			/*$author_id                 = get_the_author_meta( 'ID',$author->ID );*/
			$author_id                   = get_the_author_meta( 'ID' );
			$author_total_product        = count_user_posts( $author_id,'download' );
			$author_total_download       = edd_count_file_downloads_of_user($author_id );
			$author_total_purchase_count = edd_count_purchases_of_customer( $author_id );
			if ( class_exists('EDD_Front_End_Submissions') ) {
				$vendor              = new FES_Vendor( $author_id ,true );
			}
			$author_location = get_user_meta( $author_id,'country',true );

			/*
				global $wpdb;
	        	$authors_data = $wpdb->get_results( 
					$wpdb->prepare( "SELECT product_count, sales_value,sales_count,date_created FROM {$wpdb->prefix}fes_vendors WHERE user_id = %d", $author_id )
	            );
				$author_sales_count   = $authors_data[0]->sales_count;
				$author_sales_value   = abs($authors_data[0]->sales_value);
				$author_product_count = $authors_data[0]->product_count;
				$author_join_date     = $authors_data[0]->date_created;
			*/

			function cliper_author_level(){

				global $wpdb;
				global $post;
				if ( is_singular( 'download' ) ) {
					$author = new WP_User( $post->post_author );
				} else {
					$author = fes_get_vendor();
				}

				if ( ! $author ) {
					$author = get_current_user_id();
				}
				$author_id    = get_the_author_meta( 'ID' );
				$author_level = '';

				$results = $wpdb->get_results( 
					$wpdb->prepare( "SELECT sales_value FROM {$wpdb->prefix}fes_vendors WHERE user_id = %d", $author_id )
			    );
			    if ($results) {
			    	$sales_value = abs($results[0]->sales_value);
			    }else{
			    	$sales_value = 0;
			    }

			    if ( $sales_value == 0 ) {
			    	$author_level = '<span class="author__level author_level_0" title="'.sprintf( esc_attr__( 'Author earned %s', 'becore' ), edd_currency_filter( 0 ) ).'">'.esc_html__( 'Level 0', 'becore' ).'</span>';
			    }elseif ($sales_value > 200000) {
			    	$author_level = '<span class="author__level author_level_10" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 200000 )).'">'.esc_html__( 'Level 10', 'becore' ).'</span>';
			    }elseif ($sales_value > 150000) {
			    	$author_level = '<span class="author__level author_level_9" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 150000 )).'">'.esc_html__( 'Level 9', 'becore' ).'</span>';
			    }elseif ($sales_value > 100000) {
			    	$author_level = '<span class="author__level author_level_8" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 100000 )).'">'.esc_html__( 'Level 8', 'becore' ).'</span>';
			    }elseif ($sales_value > 70000) {
			    	$author_level = '<span class="author__level author_level_7" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 70000 )).'">'.esc_html__( 'Level 7', 'becore' ).'</span>';
			    }elseif ($sales_value > 40000) {
			    	$author_level = '<span class="author__level author_level_6" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 40000 )).'">'.esc_html__( 'Level 6', 'becore' ).'</span>';
			    }elseif ($sales_value > 10000) {
			    	$author_level = '<span class="author__level author_level_5" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 10000 )).'">'.esc_html__( 'Level 5', 'becore' ).'</span>';
			    }elseif ($sales_value > 5000) {
			    	$author_level = '<span class="author__level author_level_4" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 5000 )).'">'.esc_html__( 'Level 4', 'becore' ).'</span>';
			    }elseif ($sales_value > 1000) {
			    	$author_level = '<span class="author__level author_level_3" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 1000 )).'">'.esc_html__( 'Level 3', 'becore' ).'</span>';
			    }elseif ($sales_value > 100) {
			    	$author_level = '<span class="author__level author_level_2" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 100 )).'">'.esc_html__( 'Level 2', 'becore' ).'</span>';
			    }elseif ( $sales_value > 0 ) {
			    	$author_level = '<span class="author__level author_level_1" title="'.sprintf(esc_attr__( 'Author earned more then (%s)', 'becore' ), edd_currency_filter( 0 )).'">'.esc_html__( 'Level 1', 'becore' ).'</span>';
			    }
				return $author_level;
			}

			echo $args['before_widget'];

			if ( ! empty( $title ) ) {
				echo $args['before_title'] . $title . $args['after_title'];
			}

			?>
			<div class="donwload__author__widget__details">
		        <div class="product__author__details">
		            <div class="fes__author__details">
		            	<div class="author__thumb__and__lavel">
			                <div class="fes__author__thumb">
			                    <?php echo get_avatar( $author,100 ) ?>
								<!-- <?php
									if ( class_exists('EDD_Front_End_Submissions') ) :
									$vendor = new FES_Vendor( $author_id ,true );
								?>
									<?php if ('approved' === $vendor->status) : ?>
					                    <div class="author__vendor__accepeted">
					                    	<?php echo '<img src="'.BECORE_IMG . '/check.svg'.'" alt="'.esc_attr__( 'vendor accepted', 'becore' ).'">'; ?>
					                    </div>
					                <?php endif; ?>
					            <?php endif; ?> -->
			                </div>
							<div class="right__author__info">
								<h4>
									<?php echo get_the_author_meta( 'display_name',$author);?>
									<?php if(class_exists('EDD_Front_End_Submissions') && 'on' == $instance['show_author_level']) : ?>
									<span class="author__lavel__btn"><?php echo cliper_author_level(); ?></span>
									<?php endif; ?>
								</h4>
								<?php if ( class_exists('EDD_Front_End_Submissions') && 'on' == $instance['show_author_since'] ) : ?>
									<div class="vendor__created__date">
										<?php echo esc_html__('Since ', 'becore'); ?><?php echo date( "M, y", strtotime( $vendor->date_created ) )?>
									</div>
								<?php endif; ?>
							</div>
		            	</div>
		            </div>

					<?php if( 'on' == $instance['show_author_counter'] ) : ?>
		            <div class="fes__author__metabox">

						<div class="single___author__meta">
						    <h4><?php echo esc_html( $author_total_product ); ?></h4>
						    <p><?php esc_html_e('Products','becore')?></p>
						</div>
						
						<?php if ( class_exists('EDD_Front_End_Submissions') ) : ?>
							<div class="single___author__meta">
							    <h4><?php echo esc_html( $vendor->sales_count ); ?></h4>
							    <p><?php esc_html_e('Sales','becore')?></p>
							</div>

							<div class="single___author__meta">
							    <h4><?php echo esc_html( $author_total_purchase_count ); ?></h4>
							    <p><?php esc_html_e('Purchased','becore')?></p>
							</div>
						<?php endif; ?>

		           	</div>
		           <?php endif; ?>
					
					<?php if( 'on' == $instance['show_message_btn'] || 'on' == $instance['show_portfolio_btn'] ) : ?>
			            <div class="author__contact__portfolio__button">
			            	<?php if ( class_exists('EDD_Front_End_Submissions') && 'on' == $instance['show_message_btn'] ) : ?>
		                    <a href="#" data-toggle="modal" data-target="#wwidget__author__message"><?php esc_html_e('Message','becore');?></a>
		                	<?php endif; ?>
		                	<?php if( 'on' == $instance['show_portfolio_btn'] ) : ?>
		                    <a class="protfoli__view__button" href="<?php echo becore_fes_author_url( get_the_author_meta( 'ID') ); ?>"><?php esc_html_e('View Portfolio','becore'); ?></a>
		                	<?php endif; ?>
			            </div>
		        	<?php endif; ?>
					
					<?php if( 'on' == $instance['show_info_btn'] ): ?>
					<div class="download__author__content author__info__button">
						
						<!-- <?php if ( class_exists('EDD_Front_End_Submissions') ) : ?>
							<?php if( 'on' == $instance['show_author_since'] ) : ?>
							    <span class="vendor__created__date">
							        <i class="fa fa-clock-o"></i><?php echo date( "M, y", strtotime( $vendor->date_created ) )?>
							    </span>
							<?php endif; ?>
						<?php endif; ?> -->

			        	<!-- <span class="author__lavel__btn"><i class="fa fa-trophy"></i><?php if(class_exists('EDD_Front_End_Submissions') && 'on' == $instance['show_author_level']){echo cliper_author_level();} ?></span> -->

			        	<?php
							if ( class_exists('EDD_Front_End_Submissions') ) :
							$vendor = new FES_Vendor( $author_id ,true );
						?>
							<?php if( $vendor->sales_value >= $instance['elite_sale_value']) : ?>
								<span class="vendor__elite__bedge" title="<?php echo esc_attr__( 'Elite Author', 'becore' ); ?>">
							        <i class="fa fa-paw"></i>
							    </span>
							<?php endif; ?>
						<?php endif; ?>

						<?php if ( class_exists('EDD_Front_End_Submissions') ) : ?>
							<?php if( $author_location && 'on' == $instance['show_author_country'] ) : ?>
						    	<span class="author__location__form" title="<?php printf( esc_attr__( 'Author located in %s', 'becore' ),$author_location ); ?>"><i class="fa fa-map-marker"></i><?php printf (esc_html__( '%s', 'quomdoo' ),$author_location ); ?></span>
							<?php endif; ?>
						<?php endif; ?>

		        	</div>
					<?php endif; ?>

		        </div>
			</div>

			<!-- Author Contact Modal -->
			<div class="modal fade author__message__modal" id="wwidget__author__message" tabindex="-1" role="dialog" aria-labelledby="wwidget__author__message">
			    <div class="modal-dialog" role="document">

			    <?php if ( ! is_user_logged_in() ) : ?>
				    <div class="modal-content">
				        <div class="modal-header">
					        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					        <h4 class="modal-title">Login</h4>
				        </div>
				        <div class="modal-body">
				            <?php echo do_shortcode(' [edd_login]'); ?>
				        </div>
				    </div>

				<?php else:  ?>

			        <div class="modal-content">
			            <div class="modal-header">
			                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			                <h4 class="modal-title"><?php esc_html_e('Contact with this Author','becore') ?></h4>
			            </div>
			            <div class="modal-body">
			                <?php 
								if(is_author()){
									$author_id = get_user_by( 'id', get_query_var( 'author' ) );
									$author_id = $author_id->ID;
								}else if(is_singular('download')){
									global $post;
									$author_id = $post->post_author;
								}else{
									return;
								}
								echo do_shortcode( '[fes_vendor_contact_form id="'.$author_id.'"]' ); 
			                ?>
			            </div>
			        </div>

				<?php endif; ?>
			    </div>
			</div>

			<?php
			echo $args['after_widget'];
		}

		/*-----------------------------
			WIDGET FORMS
		------------------------------*/
		function form( $instance ){
			$defaults = array(
				'title'               => esc_html__('Author Information','becore'),
				'show_author_level'   => 'on',
				'show_author_since'   => '',
				'show_author_country' => '',
				'show_author_counter' => 'on',
				'show_message_btn'    => '',
				'show_portfolio_btn'  => '',
				'show_info_btn'       => 'off',
				'elite_sale_value'       => '2000',
			);
			$instance = wp_parse_args((array) $instance, $defaults); ?>
			<p>
			    <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title','becore');?>:</label>
			    <input id="<?php echo esc_attr($this->get_field_id('title')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
			</p>
			<p>
				<input <?php checked( $instance['show_author_level'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_author_level' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_author_level' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_author_level' ) ); ?>"><?php esc_html_e( 'Show Author Level', 'becore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['show_author_since'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_author_since' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_author_since' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_author_since' ) ); ?>"><?php esc_html_e( 'Show Author Since', 'becore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['show_author_country'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_author_country' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_author_country' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_author_country' ) ); ?>"><?php esc_html_e( 'Show Author Country', 'becore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['show_author_counter'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_author_counter' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_author_counter' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_author_counter' ) ); ?>"><?php esc_html_e( 'Show Author Downloas, Sale, Purchase count', 'becore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['show_message_btn'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_message_btn' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_message_btn' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_message_btn' ) ); ?>"><?php esc_html_e( 'Show Author Message Button', 'becore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['show_portfolio_btn'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_portfolio_btn' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_portfolio_btn' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_portfolio_btn' ) ); ?>"><?php esc_html_e( 'Show Author Portfolio Button', 'becore' ); ?></label>
			</p>
			<p>
				<input <?php checked( $instance['show_info_btn'], 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_info_btn' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_info_btn' ) ); ?>" type="checkbox" />
				<label for="<?php echo esc_attr( $this->get_field_id( 'show_info_btn' ) ); ?>"><?php esc_html_e( 'Show Info Buttons', 'becore' ); ?></label>
			</p>

			<p>
			    <label for="<?php echo esc_attr($this->get_field_id('elite_sale_value')); ?>"><?php esc_html_e('Elite Sale Value','becore');?>:</label>
			    <input id="<?php echo esc_attr($this->get_field_id('elite_sale_value')); ?>" class="widefat" name="<?php echo esc_attr($this->get_field_name('elite_sale_value')); ?>" value="<?php echo esc_attr($instance['elite_sale_value']); ?>" />
			</p>

			<?php
			//do_action( 'edd_product_details_widget_form' , $instance );
		}

		/*----------------------------
			WIDGET UPDATE
		-----------------------------*/
		function update($new_instance, $old_instance) {
			$instance                        = $old_instance;
			$instance['title']               = strip_tags($new_instance['title']);
			$instance['show_author_level']   = isset( $new_instance['show_author_level'] ) ? $new_instance['show_author_level'] : '';
			$instance['show_author_since']   = isset( $new_instance['show_author_since'] ) ? $new_instance['show_author_since'] : '';
			$instance['show_author_country'] = isset( $new_instance['show_author_country'] ) ? $new_instance['show_author_country'] : '';
			$instance['show_author_counter'] = isset( $new_instance['show_author_counter'] ) ? $new_instance['show_author_counter'] : '';
			$instance['show_message_btn']    = isset( $new_instance['show_message_btn'] ) ? $new_instance['show_message_btn'] : '';
			$instance['show_portfolio_btn']  = isset( $new_instance['show_portfolio_btn'] ) ? $new_instance['show_portfolio_btn'] : '';
			$instance['show_info_btn']  = isset( $new_instance['show_info_btn'] ) ? $new_instance['show_info_btn'] : '';
			$instance['elite_sale_value']  = isset( $new_instance['elite_sale_value'] ) ? $new_instance['elite_sale_value'] : '';
			//do_action( 'edd_product_details_widget_update', $instance );
			return $instance;
		}
	}

	function becore_download_author_widget() {
		register_widget('cliper_Market_Product_Author_Widget');
	}

	add_action('widgets_init', 'becore_download_author_widget');

endif;