<?php

class Payment_Icons_Widget extends WP_Widget {

	function __construct() {
	    parent::__construct(
			'payment__icons__widget',
			esc_html__('Payment Icons', 'becore'),
			array( 'description' => esc_html__( 'Your Site Payment Mathod Icons.', 'becore' ), )
		);
	}

	public function widget( $args, $instance ) {

		$title           = apply_filters( 'widget_title', $instance[ 'title' ] );
		$show_paypal     = $instance[ 'show_paypal' ] ? 'true' : 'false';
		$show_stripe     = $instance[ 'show_stripe' ] ? 'true' : 'false';
		$show_visa       = $instance[ 'show_visa' ] ? 'true' : 'false';
		$show_mastercard = $instance[ 'show_mastercard' ] ? 'true' : 'false';
		$show_discover   = $instance[ 'show_discover' ] ? 'true' : 'false';

		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		?>

		<div class="payment__icons__widget__content">
			<div class="payment__icons">
				<?php
					if( 'on' == $instance[ 'show_paypal' ] ){
						echo '<img src="'.BECORE_IMG . '/payment/paypal.svg'.'" alt="'.esc_attr__( 'paypal', 'becore' ).'">';
					}
					if( 'on' == $instance[ 'show_stripe' ] ){
						echo '<img src="'.BECORE_IMG . '/payment/stripe.svg'.'" alt="'.esc_attr__( 'stripe', 'becore' ).'">';
					}
					if( 'on' == $instance[ 'show_visa' ] ) {
						echo '<img src="'.BECORE_IMG . '/payment/visa.svg'.'" alt="'.esc_attr__( 'visa', 'becore' ).'">';
					}
					if( 'on' == $instance[ 'show_mastercard' ] ) {
						echo '<img src="'.BECORE_IMG . '/payment/master-card.svg'.'" alt="'.esc_attr__( 'master card', 'becore' ).'">';
					}
					if( 'on' == $instance[ 'show_discover' ] ) {
						echo '<img src="'.BECORE_IMG . '/payment/discover.svg'.'" alt="'.esc_attr__( 'discover', 'becore' ).'">';
					}
				?>
			</div>
		</div>
		<?php echo $args['after_widget'];
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance                    = $old_instance;
		$instance['title']           = sanitize_text_field( $new_instance['title'] );
		$instance['show_paypal']     = sanitize_text_field( $new_instance['show_paypal'] );
		$instance['show_stripe']     = sanitize_text_field( $new_instance['show_stripe'] );
		$instance['show_visa']       = sanitize_text_field( $new_instance['show_visa'] );
		$instance['show_mastercard'] = sanitize_text_field( $new_instance['show_mastercard'] );
		$instance['show_discover']   = sanitize_text_field( $new_instance['show_discover'] );

		return $instance;
	}


	public function form( $instance ) {
		//Defaults
		$defaults = array(
			'title'           => esc_html__( 'Payment Method Icons', 'quomodo'  ),
			'show_paypal'     => 'on',
			'show_stripe'     => 'on',
			'show_visa'       => 'on',
			'show_mastercard' => 'on',
			'show_discover'   => 'on',
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title    = sanitize_text_field( $instance['title'] ); ?>
		
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'becore' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
			
		 <p>
	        <input class="checkbox" type="checkbox" <?php checked( $instance[ 'show_paypal' ], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_paypal' ); ?>" name="<?php echo $this->get_field_name( 'show_paypal' ); ?>" /> 
	        <label for="<?php echo $this->get_field_id( 'show_paypal' ); ?>">Show Paypal</label>
	    </p>
	    
	    
	    <p>
	        <input class="checkbox" type="checkbox" <?php checked( $instance[ 'show_stripe' ], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_stripe' ); ?>" name="<?php echo $this->get_field_name( 'show_stripe' ); ?>" /> 
	        <label for="<?php echo $this->get_field_id( 'show_stripe' ); ?>">Show Stripe</label>
	    </p>
	    
	    
	    <p>
	        <input class="checkbox" type="checkbox" <?php checked( $instance[ 'show_visa' ], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_visa' ); ?>" name="<?php echo $this->get_field_name( 'show_visa' ); ?>" /> 
	        <label for="<?php echo $this->get_field_id( 'show_visa' ); ?>">Show Visa</label>
	    </p>
	    
	    <p>
	        <input class="checkbox" type="checkbox" <?php checked( $instance[ 'show_mastercard' ], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_mastercard' ); ?>" name="<?php echo $this->get_field_name( 'show_mastercard' ); ?>" /> 
	        <label for="<?php echo $this->get_field_id( 'show_mastercard' ); ?>">Show Mastercard</label>
	    </p>
	    
	    <p>
	        <input class="checkbox" type="checkbox" <?php checked( $instance[ 'show_discover' ], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_discover' ); ?>" name="<?php echo $this->get_field_name( 'show_discover' ); ?>" /> 
	        <label for="<?php echo $this->get_field_id( 'show_discover' ); ?>">Show Discover</label>
	    </p>
	<?php
	}
}

function becore_payment_icons() {
	register_widget( 'Payment_Icons_Widget' );
}
add_action( 'widgets_init', 'becore_payment_icons' );