<?php

/**
 * Registers a new post type
 * @uses $wp_post_types Inserts new post type object into the list
 *
 * @param  string          Post type key, must not exceed 20 characters
 * @param  array|string    See  optional args description above.
 * @return object|WP_Error the registered post type object, or an error object
 */
if ( !function_exists( 'becore_portfolio' ) ) {
    function becore_portfolio() {

        /*----------------------------------------
        REGISTER CPT PORTFOLIO
        -----------------------------------------*/
        $labels = array(
            'name'               => esc_html__( 'Portfolios', 'becore' ),
            'singular_name'      => esc_html__( 'Portfolio', 'becore' ),
            'add_new'            => _x( 'Add New Portfolio', 'becore', 'becore' ),
            'add_new_item'       => esc_html__( 'Add New Portfolio', 'becore' ),
            'edit_item'          => esc_html__( 'Edit Portfolio', 'becore' ),
            'new_item'           => esc_html__( 'New Portfolio', 'becore' ),
            'view_item'          => esc_html__( 'View Portfolio', 'becore' ),
            'search_items'       => esc_html__( 'Search Portfolios', 'becore' ),
            'not_found'          => esc_html__( 'No Portfolios found', 'becore' ),
            'not_found_in_trash' => esc_html__( 'No Portfolios found in Trash', 'becore' ),
            'parent_item_colon'  => esc_html__( 'Parent Portfolio:', 'becore' ),
            'menu_name'          => esc_html__( 'Portfolios', 'becore' ),
        );
        $args = array(
            'labels'              => $labels,
            'hierarchical'        => false,
            'description'         => 'description',
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 11,
            'menu_icon'           => 'dashicons-portfolio',
            'show_in_nav_menus'   => true,
            'publicly_queryable'  => true,
            'exclude_from_search' => false,
            'has_archive'         => true,
            'query_var'           => true,
            'can_export'          => true,
            'rewrite'             => true,
            'capability_type'     => 'page',
            'supports'            => array(
                'title',
                'editor',
                'thumbnail',
                'revisions',
            ),
        );
        register_post_type( 'portfolio', $args );

        /*----------------------------------------
        TEXONOMY REGISTER FOR PORTFOLIO
        -----------------------------------------*/
        $labels = array(
            'name'                  => _x( 'Portfolio Categories', 'Taxonomy Categories', 'becore' ),
            'singular_name'         => _x( 'Portfolio Category', 'Taxonomy Portfolio Category', 'becore' ),
            'search_items'          => __( 'Search Categories', 'becore' ),
            'popular_items'         => __( 'Popular Categories', 'becore' ),
            'all_items'             => __( 'All Categories', 'becore' ),
            'parent_item'           => __( 'Parent Portfolio Category', 'becore' ),
            'parent_item_colon'     => __( 'Parent Portfolio Category', 'becore' ),
            'edit_item'             => __( 'Edit Portfolio Category', 'becore' ),
            'update_item'           => __( 'Update Portfolio Category', 'becore' ),
            'add_new_item'          => __( 'Add New Portfolio Category', 'becore' ),
            'new_item_name'         => __( 'New Portfolio Category', 'becore' ),
            'add_or_remove_items'   => __( 'Add or remove categories', 'becore' ),
            'choose_from_most_used' => __( 'Choose from most used categories', 'becore' ),
            'menu_name'             => __( 'Portfolio Categories', 'becore' ),
        );
        $args = array(
            'labels'            => $labels,
            'public'            => true,
            'show_in_nav_menus' => false,
            'show_admin_column' => false,
            'hierarchical'      => true,
            'show_tagcloud'     => true,
            'show_ui'           => true,
            'query_var'         => true,
            'rewrite'           => true,
            'query_var'         => true,
            'capabilities'      => array(),
        );
        register_taxonomy( 'portfolio_category', array( 'portfolio' ), $args );

        /*----------------------------------------
        TEXONOMY REGISTER FOR PORTFOLIO TAGS
        -----------------------------------------*/
        $labels = array(
            'name'                  => _x( 'Portfolio Tags', 'Taxonomy tags', 'becore' ),
            'singular_name'         => _x( 'Tags', 'Taxonomy tags', 'becore' ),
            'search_items'          => __( 'Search tags', 'becore' ),
            'popular_items'         => __( 'Popular tags', 'becore' ),
            'all_items'             => __( 'All tags', 'becore' ),
            'parent_item'           => __( 'Parent tags', 'becore' ),
            'parent_item_colon'     => __( 'Parent tags', 'becore' ),
            'edit_item'             => __( 'Edit tags', 'becore' ),
            'update_item'           => __( 'Update tags', 'becore' ),
            'add_new_item'          => __( 'Add New tags', 'becore' ),
            'new_item_name'         => __( 'New tags Name', 'becore' ),
            'add_or_remove_items'   => __( 'Add or remove tags', 'becore' ),
            'choose_from_most_used' => __( 'Choose from most used tags', 'becore' ),
            'menu_name'             => __( 'Portfolio Tags', 'becore' ),
        );
        $args = array(
            'labels'            => $labels,
            'public'            => true,
            'show_in_nav_menus' => false,
            'show_admin_column' => false,
            'hierarchical'      => false,
            'show_tagcloud'     => true,
            'show_ui'           => true,
            'query_var'         => true,
            'rewrite'           => true,
            'query_var'         => true,
            'capabilities'      => array(),
        );
        register_taxonomy( 'portfolio_tags', array( 'portfolio' ), $args );

    }
}
add_action( 'init', 'becore_portfolio' );

register_deactivation_hook( __FILE__, 'flush_rewrite_rules' );
register_activation_hook( __FILE__, 'becore_flush_rewrites' );
function becore_flush_rewrites() {
    becore_portfolio();
    flush_rewrite_rules();
}