<?php

/**
 * Plugin Name: Be Core
 * Description: This is a core helper plugin for themes.
 * Plugin URI: https://themeim.com/wordpress-themes/
 * Author: ThemeIM
 * Author URI: https://themeim.com/
 * Version: 1.0.0
 * License: GPL2
 * Text Domain: beecore
 */

/**
 * INITIALIZE
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
include_once ABSPATH . 'wp-admin/includes/plugin.php';

/**
 * CONSTANT FOR DIR
 * @param string $[name]   name of the constant
 * @param string directory url
 */
define( 'BECORE_DIR', plugin_dir_url( __FILE__ ) );
define( 'BECORE_JS', plugins_url( '/assets/js', __FILE__ ) );
define( 'BECORE_CSS', plugins_url( '/assets/css', __FILE__ ) );
define( 'BECORE_IMG', plugins_url( '/assets/img', __FILE__ ) );

/* ---------------------------
PLUGIN INIT
----------------------------*/
add_action( 'plugins_loaded', 'becore_main_functionality', 10 );
function becore_main_functionality() {

    /**
     * ENQUEUE SCRIPTS
     *
     * @param string      $handle    Script name
     * @param string      $src       Script url
     * @param array       $deps      (optional) Array of script names on which this script depends
     * @param string|bool $ver       (optional) Script version (used for cache busting), set to null to disable
     * @param bool        $in_footer (optional) Whether to enqueue the script before </head> or before </body>
     */
    function becore_toolkit_scripts() {
        wp_enqueue_style( 'becore-widgets', BECORE_CSS . '/widgets.css', '', '1.0.0', 'all' );
        wp_enqueue_style( 'becore-overwrite', BECORE_CSS . '/overwrite.css', '', '1.0.0', 'all' );
        wp_enqueue_style( 'becore', BECORE_CSS . '/core-inline.css', '', '1.0.0', 'all' );

        /*------------------------
        REGISTER CSS
        -------------------------*/
        wp_register_style( 'owl-carousel', BECORE_CSS . '/owl.carousel.css', '', '1.0.0', 'all' );
        wp_register_style( 'easyTicker', BECORE_CSS . '/easy-ticker.css', '', '1.0.0', 'all' );

        /*------------------------
        REGISTER SCRIPTS
        -------------------------*/
        wp_register_script( 'owl-carousel', BECORE_JS . '/owl.carousel.min.js', array( 'jquery' ), '2.0.0', true );
        wp_register_script( 'easyTicker', BECORE_JS . '/easy-ticker.min.js', array( 'jquery', 'jquery-effects-core' ), '1.0.0', true );

        /*------------------------
        REGISTER SINGLE SCRIPTS
        --------------------------*/
        wp_register_script( 'instafeed', BECORE_JS . '/instafeed.min.js', array( 'jquery' ), '1.0.0', true );
        wp_register_script( 'ajaxchimp', BECORE_JS . '/ajaxchimp.js', array( 'jquery' ), '1.0.0', true );

        /*------------------------
        CALL SCRIPTS
        --------------------------*/
        wp_enqueue_script( 'appear', BECORE_JS . '/appear.js', array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'masonry', array( 'jquery', 'imagesloaded' ) );
        wp_enqueue_script( 'isotope', BECORE_JS . '/isotope.pkgd.min.js', array( 'jquery' ), '1.0', true );
        wp_enqueue_script( 'becore', BECORE_JS . '/active.js', array( 'jquery', 'appear', 'owl-carousel' ), '1.0.0', true );
        wp_enqueue_script('jquery-cookie', '//cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js
', array('jquery'), '1.0.0', true);
        wp_enqueue_script('currency-list', BECORE_JS . '/currency-list.js', array('jquery'), '1.0.0', true);
		
        $display_currency_menu = cliper_get_option('enable_currency_menu');
        
        if( $display_currency_menu == true){
        	wp_enqueue_script('currency', BECORE_JS . '/currency.js', array('jquery', 'currency-list', 'jquery-cookie'), '1.0.0', true);
		}

    }
    add_action( 'wp_enqueue_scripts', 'becore_toolkit_scripts', 10 );

    /**
     * Admin Enqueue scripts Backend
     *
     * @param string      $handle    Script name
     * @param string      $src       Script url
     * @param array       $deps      (optional) Array of script names on which this script depends
     * @param string|bool $ver       (optional) Script version (used for cache busting), set to null to disable
     * @param bool        $in_footer (optional) Whether to enqueue the script before </head> or before </body>
     * @param string      $hook      get for the posts id
     */
    function becore_admin_enqueue_scripts( $hook ) {

        wp_enqueue_style( 'admin-style', BECORE_CSS . '/admin.css', array(), '1.0.0', 'all' );
        wp_enqueue_script( 'widget-admin', BECORE_JS . '/widget-admin.js', array( 'jquery' ), '1.0.0', true );

        if ( isset( $_REQUEST['post'] ) || isset( $_REQUEST['post_ID'] ) ) {
            $post_id = empty( $_REQUEST['post_ID'] ) ? $_REQUEST['post'] : $_REQUEST['post_ID'];
        }

        if ( "post.php" == $hook ) {
            $post_format = get_post_format( $post_id );
            wp_enqueue_script( 'becore-admin', BECORE_JS . '/admin.js', array( 'jquery' ), '1.0.0', true );
            wp_localize_script( "becore-admin", "post_format", array( "format" => $post_format ) );
        } elseif ( "post-new.php" == $hook ) {
            wp_enqueue_script( 'becore-admin', BECORE_JS . '/admin.js', array( 'jquery' ), '1.0.0', true );
            wp_localize_script( "becore-admin", "post_format", array( "format" => 'none' ) );
        }
    }
    add_action( 'admin_enqueue_scripts', 'becore_admin_enqueue_scripts' );

    /* ---------------------------
    INCLUDES FILES
    -----------------------------*/
    if ( file_exists( dirname( __FILE__ ) . '/inc/helper_function.php' ) ) {
        require_once dirname( __FILE__ ) . '/inc/helper_function.php';
    }

    if ( file_exists( dirname( __FILE__ ) . '/post/post.php' ) ) {
        require_once dirname( __FILE__ ) . '/post/post.php';
    }

    /*---------------------------
    FRAMEWORK INCLUDES
    ----------------------------*/
    /**
     * Use it if use CMB2 Metabox.
     * We can use this metabox options for showing posts metabox and value.
     *
     */
    /*if ( is_plugin_active( 'cmb2/init.php' ) ) {
    require_once dirname( __FILE__ ) . '/framework/metabox/cmb2/metabox.php';
    }*/

    if ( file_exists( dirname( __FILE__ ) . '/framework/codestar-framework/codestar-framework.php' ) ) {
        require_once dirname( __FILE__ ) . '/framework/codestar-framework/codestar-framework.php';
    }

    /*---------------------------
    WIDGETS
    -----------------------------*/
    if ( file_exists( dirname( __FILE__ ) . '/widgets/widgets.php' ) ) {
        require_once dirname( __FILE__ ) . '/widgets/widgets.php';
    }
}