<?php
/*
Plugin Name: EDD Variable Pricing Descriptions
Plugin URI: https://easydigitaldownloads.com/downloads/edd-variable-pricing-descriptions/
Description: Adds a description field for each variable pricing option
Version: 1.0.3
Author: Easy Digital Downloads
Author URI: https://easydigitaldownloads.com
License: GPL-2.0+
License URI: http://www.opensource.org/licenses/gpl-license.php
Text Domain: edd-vpd
Domain Path: languages
*/

if ( class_exists( 'Easy_Digital_Downloads' ) ) :

	/**
	 * Internationalization
	 * @since 1.0
	 */
	function edd_remove_reviw_from_default_content() {}
	add_action( 'init', 'edd_remove_reviw_from_default_content' );


	/**
	 * Outputs the description
	 * @since 1.0.2
	 */
	function edd_vpd_output_description( $key, $price, $download_id ) {

		$description = isset( $price['description'] ) ? $price['description'] : null;
		echo '<p class="edd-variable-pricing-desc">' . esc_html( $description ) . '</p>';

	}
	add_action( 'edd_after_price_option', 'edd_vpd_output_description', 10, 3 );


	/**
	 * Adds the table header
	 *
	 * @since 1.0
	 */
	function edd_vpd_download_price_table_head() { ?>

		<th><?php _e( 'Option Description', 'edd-vpd' ); ?></th>

	<?php }
	add_action( 'edd_download_price_table_head', 'edd_vpd_download_price_table_head' );


	/**
	 * Adds the table cell with description input field
	 *
	 * @since 1.0
	 */
	function edd_vpd_download_price_table_row( $post_id, $key, $args ) {
		$description = isset($args['description']) ? $args['description'] : null;
	?>

		<td>
			<input type="text" class="edd_variable_prices_description" value="<?php echo esc_attr( $description ); ?>" placeholder="<?php _e( 'Option Description', 'edd-vpd' ); ?>" name="edd_variable_prices[<?php echo $key; ?>][description]" id="edd_variable_prices[<?php echo $key; ?>][description]" size="20" style="width:100%" />
		</td>

	<?php }
	add_action( 'edd_download_price_table_row', 'edd_vpd_download_price_table_row', 10, 3 );


	/**
	 * Add description field to edd_price_row_args
	 *
	 * @since 1.0
	 */
	function edd_vpd_price_row_args( $args, $value ) {

		$args['description'] = isset( $value['description'] ) ? $value['description'] : '';

		return $args;

	}
	add_filter( 'edd_price_row_args', 'edd_vpd_price_row_args', 10, 2 );

	function becore_fes_author_url( $author = null ) {
		global $post;
		$author_id = $post->post_author;
		if ( ! $author ) {
			$author = wp_get_current_user();
		}else{
			$author = new WP_User( $author );
		}

		if ( ! class_exists( 'EDD_Front_End_Submissions' ) ) {
			return add_query_arg( 'author_downloads', 'true', get_author_posts_url( get_the_author_meta('ID',$author_id)) );
		}
		return EDD_FES()->vendors->get_vendor_store_url( $author->ID );
	}

endif;

/*------------------------------------
POST SHARE GENARAL
--------------------------------------*/
if ( !function_exists( 'becore_post_share_social' ) ) {
    function becore_post_share_social() {
        global $post;
        $crunchifyURL   = get_permalink();
        $crunchifyTitle = str_replace( ' ', '%20', get_the_title() );

        $twitterURL  = 'https://twitter.com/intent/tweet?text=' . $crunchifyTitle . '&amp;url=' . $crunchifyURL . '&amp;via=Crunchify';
        $facebookURL = 'https://www.facebook.com/sharer/sharer.php?u=' . $crunchifyURL;
        $googleURL   = 'https://plus.google.com/share?url=' . $crunchifyURL;
        $linkedinURL = 'https://www.linkedin.com/shareArticle?mini=true&url=' . $crunchifyURL;
        ?>
        <ul>
            <li><a href="<?php echo esc_url( $facebookURL ); ?>" target="_blank"><i class="ti ti-facebook"></i></a></li>
            <li><a href="<?php echo esc_url( $twitterURL ); ?>" target="_blank"><i class="ti ti-twitter"></i></a></li>
            <li><a href="<?php echo esc_url( $googleURL ); ?>" target="_blank"><i class="ti ti-google"></i></a></li>
            <li><a href="<?php echo esc_url( $linkedinURL ); ?>" target="_blank"><i class="ti ti-linkedin"></i></a></li>
        </ul>
        <?php
    }
}

/*----------------------------------
POST SHARE WITH OFFICIAL COLOR
-----------------------------------*/
if ( !function_exists( 'becore_post_share_social_left' ) ) {
    function becore_post_share_social_left() {
        global $post;
        $crunchifyURL   = get_permalink();
        $crunchifyTitle = str_replace( ' ', '%20', get_the_title() );

        $twitterURL  = 'https://twitter.com/intent/tweet?text=' . $crunchifyTitle . '&amp;url=' . $crunchifyURL . '&amp;via=Crunchify';
        $facebookURL = 'https://www.facebook.com/sharer/sharer.php?u=' . $crunchifyURL;
        $googleURL   = 'https://plus.google.com/share?url=' . $crunchifyURL;
        $linkedinURL = 'https://www.linkedin.com/shareArticle?mini=true&url=' . $crunchifyURL;
    ?>
    <ul>
        <li><a class="facebook" href="<?php echo esc_url( $facebookURL ); ?>" target="_blank"><i class="ti ti-facebook"></i></a></li>
        <li><a class="twitter" href="<?php echo esc_url( $twitterURL ); ?>" target="_blank"><i class="ti ti-twitter"></i></a></li>
        <li><a class="google-plus" href="<?php echo esc_url( $googleURL ); ?>" target="_blank"><i class="ti ti-google"></i></a></li>
        <li><a class="linkedin" href="<?php echo esc_url( $linkedinURL ); ?>" target="_blank"><i class="ti ti-linkedin"></i></a></li>
    </ul>
    <?php
    }
}

/*------------------------------
POST READING TIME COUNT
--------------------------------*/
/**
 * Estimates the reading time for a given piece of $content.
 *
 *
 * @param   string $content Content to calculate read time for.
 * @param   int    $wpm     Estimated words per minute of reader.
 * @returns int    $time Esimated reading time.
 */
if ( !function_exists( 'becore_reading_time' ) ) {
    function becore_reading_time( $wpm = 300 ) {
        $content      = get_post_field( 'post_content', $post->ID );
        $word_count   = str_word_count( strip_tags( $content ) );
        $reading_time = ceil( $word_count / $wpm );
        if ( $reading_time == 1 ) {
            $timer = " minute";
        } else {
            $timer = " minutes";
        }
        $total_reading_time = $reading_time . $timer;
        return $total_reading_time;
    }
}
