$ = jQuery;
// include api for currency change
const api = "https://api.exchangerate-api.com/v4/latest/USD";

// for selecting different controls
var resultFrom;
var resultTo;

jQuery(document).ready(function ($) {
    resultTo = $('.selected').text();
    changeCurrencyIcon(currency_list);
    addClassToMultiSelectForm();
    addClassToServiceBox();
    $(".option").each(function (index) {
        var convert = $(this);
        convert.on('click', function (e) {
            resultTo = $(this).text();
            resultFrom = $('.selected').text();
            // $('.currency__switcher').attr('data-content', currency_list[resultTo]);
            $.cookie('cliper_currency', resultTo, { path: '/' });
            fetch(`${api}`)
                .then(currency => {
                    return currency.json();
                }).then(displayResults);
        });
    });
});

// function getresults
function getResults() {

    fetch(`${api}`)
        .then(currency => {
            return currency.json();
        }).then(displayResults);
}

// display results after convertion
function displayResults(currency) {
    let fromRate = currency.rates[resultFrom];
    let toRate = currency.rates[resultTo];
    $('.currency-price').each(function (index) {
        var currencyText = $(this).text().replace(currency_list[resultFrom], currency_list[resultTo]);
        currencyText = currencyText.replace(resultFrom, resultTo);
        var currency = convert(currencyText);
        convertedCurrency = ((toRate / fromRate) * currency).toFixed(2);
        currencyText = currencyText.replace(currency, convertedCurrency);
        currencyText = currencyText.replace(convertedCurrency+"0", convertedCurrency);
        currencyText = currencyText.replace(convertedCurrency+".00", convertedCurrency);
		currencyText = currencyText.replace(".00", "");
        $(this).text(currencyText);
    });
}

//  change currency icon
function changeCurrencyIcon() {
    // $('.currency__switcher').attr('data-content', currency_list[resultTo]);
    fetch(`${api}`)
        .then(currency => {
            return currency.json();
        }).then(setDefaultCurrency);

}

function setDefaultCurrency(currency) {
    let fromRate = currency.rates['USD'];
    let toRate = currency.rates[resultTo];
    $('.currency-price').each(function (index) {
        var currencyText = $(this).text().replace(currency_list['USD'], currency_list[resultTo]);
        currencyText = currencyText.replaceAll('USD', resultTo);
        var currency = convert(currencyText);
        convertedCurrency = ((toRate / fromRate) * currency).toFixed(2);
        currencyText = currencyText.replace(currency, convertedCurrency);
        currencyText = currencyText.replace(convertedCurrency+"0", convertedCurrency);
        currencyText = currencyText.replace(convertedCurrency+".00", convertedCurrency);
        currencyText = currencyText.replace(".00", "");
        $(this).text(currencyText);
    });
}

function convert(currency) {
    // Using replace() method
    // to make currency string suitable 
    // for parseFloat() to convert 
    var temp = currency.replace(/[^0-9.-]+/g, "");

    // Converting string to float
    // or double and return
    return parseFloat(temp);
}

function addClassToMultiSelectForm() {
    $('.fw-choice label').each(function (index) {
        $(this).addClass('currency-price')
    });
}
function addClassToServiceBox() {
    $('.box__description>p>span').each(function (index) {
        $(this).addClass('currency-price')
    });
}