<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Be_Addons_Signin_Widget extends Widget_Base {

    public function get_name() {
        return 'Be_Addons_Signin_Widget';
    }

    public function get_keywords() {
        return ['signin', 'login', 'user login'];
    }

    public function get_title() {
        return esc_html__( 'Be Login Form', 'beaddon' );
    }

    public function get_icon() {
        return 'eicon-lock-user';
    }

    public function get_categories() {
        return ['be-addons'];
    }

    public function get_script_depends() {
        return [
            'be-core',
        ];
    }

    public function content_layout_style() {
        return [
            'layout_1' => esc_html__( 'layout_1', 'beaddon' ),
        ];
    }

    protected function register_controls() {

        /*=================================
            CONTENT SECTION
        ==================================*/
        /*----------------------------
            LOGIN FORMS CONTENT & LAYOUT
        -----------------------------*/
        $this->start_controls_section(
            'content_layout',
            [
                'label' => esc_html__( 'Content & Layout', 'beaddon' ),
            ]
        );
            $this->add_control(
                'content_layout_style',
                [
                    'label'   => esc_html__( 'Form Layout', 'beaddon' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'default' => 'layout_1',
                    'options' => $this->content_layout_style(),
                ]
            );
            $this->add_control(
                'signup_',
                [
                    'label'        => esc_html__( 'Show SignUp Link?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'signup_url', [
                    'label'       => esc_html__( 'SignUp Link', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'     => '#',
                    'condition'   => [
                        'signup_' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'signup_text', [
                    'label'       => esc_html__( 'SignUp Link Text', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'     => 'SignUp',
                    'condition'   => [
                        'signup_' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'custom_redirect',
                [
                    'label'        => esc_html__( 'Custom Redirect Link?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'login_redirect_url', [
                    'label'       => esc_html__( 'Success Custom Redirect Url', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'     => '#',
                    'condition'   => [
                        'custom_redirect' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();

        /*----------------------------
            LOGIN FORMS FIELDS
        -----------------------------*/
        $this->start_controls_section(
            'section_fields',
            [
                'label' => esc_html__( 'Login Fields', 'beaddon' ),
            ]
        );
            $this->add_control(
                'custom_fld_icon',
                [
                    'label'        => esc_html__( 'Login Field Icons?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                ]
            );

            $this->add_control(
                'custom_lebel',
                [
                    'label'        => esc_html__( 'Login Field Lebel?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'username_button_heading',
                [
                    'label' => __( 'Username', 'beaddon' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_username_label', [
                    'label'       => esc_html__( 'Username Label', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'Username ', 'beaddon' ),
                    'default'     => esc_html__( 'Username ', 'beaddon' ),
                    'condition'   => [
                        'custom_lebel' => ['yes'],
                    ],
                    'separator' => 'before',

                ]
            );
            $this->add_control(
                'login_username_placeholder', [
                    'label'       => esc_html__( 'Username Placeholder', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'username ', 'beaddon' ),
                    'default'     => esc_html__( 'Username ', 'beaddon' ),
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_username_icon',
                [
                    'label'     => __( 'Username Field Icon', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::ICONS,
                    'default'   => [
                        'value'   => 'fas fa-user',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'custom_fld_icon' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'password_button_heading',
                [
                    'label' => __( 'Password', 'beaddon' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_password_label', [
                    'label'       => esc_html__( 'Password Label', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'Password ', 'beaddon' ),
                    'default'     => esc_html__( 'Password ', 'beaddon' ),
                    'condition'   => [
                        'custom_lebel' => ['yes'],
                    ],
                    'separator' => 'before',

                ]
            );
            $this->add_control(
                'login_password_placeholder', [
                    'label'       => esc_html__( 'Password Placeholder', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'Password ', 'beaddon' ),
                    'default'     => esc_html__( 'Password ', 'beaddon' ),
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_password_icon',
                [
                    'label'     => __( 'Password Field Icon', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::ICONS,
                    'default'   => [
                        'value'   => 'fas fa-unlock-alt',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'custom_fld_icon' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'submit_button_heading',
                [
                    'label' => __( 'Submit Button', 'beaddon' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_submit_text', [
                    'label'       => esc_html__( 'Submit Button Text', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'Login ', 'beaddon' ),
                    'default'     => esc_html__( 'Login', 'beaddon' ),
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'signup_submit_icon',
                [
                    'label'     => __( 'Submit Icon', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::ICONS,
                    'default'   => [
                        'value'   => 'fas fa-arrow-right',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'custom_fld_icon' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();

        /*----------------------------
            REMEMBER PASSWORD
        -----------------------------*/
        $this->start_controls_section(
            'section_remenber_content',
            [
                'label' => esc_html__( 'Login Remember ', 'beaddon' ),
            ]
        );
            $this->add_control(
                'remember_show',
                [
                    'label'        => esc_html__( 'Show Remember?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'yes',
                ]
            );
            $this->add_control(
                'remember_text',
                [
                    'label'       => esc_html__( 'Remember Title', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => esc_html__( 'Remember Me', 'beaddon' ),
                    'placeholder' => esc_html__( 'Type your login remember title here', 'beaddon' ),
                    'condition' => [
                        'remember_show' => 'yes',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();

        /*----------------------------
            LOST PASSWORD
        -----------------------------*/
        $this->start_controls_section(
            'section_lost_password__content',
            [
                'label' => esc_html__( 'Login Lost Password ', 'beaddon' ),
            ]
        );
            $this->add_control(
                'lost_password_show',
                [
                    'label'        => esc_html__( 'Show Lost Password?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'yes',
                ]
            );
            $this->add_control(
                'lost_password_text',
                [
                    'label'       => esc_html__( 'Lost Password Title', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => esc_html__( 'Lost Password', 'beaddon' ),
                    'placeholder' => esc_html__( 'Type your lost password title here', 'beaddon' ),
                    'condition' => [
                        'lost_password_show' => 'yes',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'lost_password_url',
                [
                    'label' => esc_html__( 'Lost Password Link', 'beaddon' ),
                    'type'  => \Elementor\Controls_Manager::URL,
                    'condition' => [
                        'lost_password_show' => 'yes',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();


        /*=================================
            STYLE SECTION
        ==================================*/
        
        /*---------------------------
            WRAPPER STYLE
        ----------------------------*/
        $this->start_controls_section(
            'be_addons_form_style_section',
            [
                'label' => esc_html__( 'Wrapper Style', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'be_addons_form_section_background',
                    'label'    => esc_html__( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap',
                ]
            );
            $this->add_responsive_control(
                'be_addons_form_section_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_form_section_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_form_section_align',
                [
                    'label'   => esc_html__( 'Alignment', 'beaddon' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'beaddon' ),
                            'icon'  => 'fa fa-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        /*--------------------------
            WRAPPER STYLE END
        ----------------------------*/

        /*----------------------------
            LABEL STYLE
        ------------------------------*/
        $this->start_controls_section(
            'be_addons_form_label_style_section',
            [
                'label' => esc_html__( 'Label', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Typography:: get_type(),
                [
                    'name'     => 'label_typography',
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap label',
                ]
            );
            $this->add_control(
                'label_text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'beaddon' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'label_background',
                    'label'    => esc_html__( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap label',
                ]
            );
            $this->add_responsive_control(
                'label_width',
                [
                    'label'      => esc_html__( 'Width', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 100
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );            
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'label_border',
                    'label'    => esc_html__( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap label',
                ]
            );
            $this->add_responsive_control(
                'label_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                    'type'      => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'label_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'label_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        /*---------------------------
            LABEL STYLE END
        -----------------------------*/

        /*---------------------------
            INPUT STYLE START
        ----------------------------*/
        $this->start_controls_section(
            'be_addons_form_input_style_section',
            [
                'label' => esc_html__( 'Input', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs( 'input_box_tabs' );
                $this->start_controls_tab(
                    'input_box_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'input_box_typography',
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                        ]
                    );
                    $this->add_control(
                        'input_box_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'color:{{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_box_background',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                        ]
                    );
                    $this->add_control(
                        'input_box_placeholder_color',
                        [
                            'label'     => esc_html__( 'Placeholder Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]::-webkit-input-placeholder'   => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]::-moz-placeholder'            => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]:-ms-input-placeholder'        => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]::-webkit-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]::-moz-placeholder'           => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]:-ms-input-placeholder'       => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]::-webkit-input-placeholder'    => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]::-moz-placeholder'             => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]:-ms-input-placeholder'         => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]::-webkit-input-placeholder' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]::-moz-placeholder'          => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]:-ms-input-placeholder'      => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]::-webkit-input-placeholder'    => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]::-moz-placeholder'             => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]:-ms-input-placeholder'         => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]::-webkit-input-placeholder'   => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]::-moz-placeholder'            => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]:-ms-input-placeholder'        => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'                              => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'                              => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ],
                            'default' => [
                                'size' => 55,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'height:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                                'size' => 100,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'width:{{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'input_box_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_box_shadow',
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"],
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'input_box_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'input_box_hover_tabs',
                    [
                        'label' => esc_html__( 'Focus', 'beaddon' ),
                    ]
                );
                $this->add_control(
                    'input_box_hover_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'beaddon' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]:focus'   => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]:focus'  => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]:focus'    => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]:focus' => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]:focus'    => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]:focus'   => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]:focus'   => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]:focus'   => 'color:{{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background:: get_type(),
                    [
                        'name'     => 'input_box_hover_backkground',
                        'label'    => esc_html__( 'Focus Background', 'beaddon' ),
                        'types'    => [ 'classic', 'gradient' ],
                        'selector' => '
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"] : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]: focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]  : focus
                        ',
                    ]
                );
                $this->add_control(
                    'input_box_hover_border_color',
                    [
                        'label'     => esc_html__( 'Border Color', 'beaddon' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]:focus'   => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]:focus'  => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]:focus'    => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]:focus' => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]:focus'    => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]:focus'   => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]:focus'   => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]:focus'   => 'border-color:{{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Box_Shadow:: get_type(),
                    [
                        'name'     => 'input_box_hover_shadow',
                        'selector' => '
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"] : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]: focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]  : focus
                        ',
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*-----------------------------
            INPUT STYLE END
        -------------------------------*/

        /*---------------------------
            INPUT CHECKBOX / RADIO STYLE 
        ----------------------------*/
        $this->start_controls_section(
            'be_addons_form_input_readio_style_section',
            [
                'label' => esc_html__( 'Input Radio / Checkbox', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs( 'input_radio_checkbox_tabs' );
                $this->start_controls_tab(
                    'input_radio_checkbox_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );

                    $this->add_responsive_control(
                        'input_radio_checkbox__display',
                        [
                            'label'   => esc_html__( 'Display', 'beaddon' ),
                            'type'    => Controls_Manager::SELECT,
                            'default' => 'inline-block',
                            
                            'options' => [
                                'initial'      => esc_html__( 'Initial', 'beaddon' ),
                                'block'        => esc_html__( 'Block', 'beaddon' ),
                                'inline-block' => esc_html__( 'Inline Block', 'beaddon' ),
                                'flex'         => esc_html__( 'Flex', 'beaddon' ),
                                'inline-flex'  => esc_html__( 'Inline Flex', 'beaddon' ),
                                'none'         => esc_html__( 'none', 'beaddon' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'display: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'input_radio_checkbox_typography',
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox,
                                {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox label
                            ',
                        ]
                    );
                    $this->add_control(
                        'input_radio_checkbox_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'color:{{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_radio_checkbox_background',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_radio_checkbox_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ],
                            'default' => [
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'height:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_radio_checkbox_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'width:{{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'input_radio_checkbox_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox
                            ',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_radio_checkbox_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_radio_checkbox_shadow',
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_radio_checkbox_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_radio_checkbox_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'input_radio_checkbox_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox' => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'input_radio_checkbox_hover_tabs',
                    [
                        'label' => esc_html__( 'Focus', 'beaddon' ),
                    ]
                );
                $this->add_control(
                    'input_radio_checkbox_hover_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'beaddon' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox:focus' => 'color:{{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background:: get_type(),
                    [
                        'name'     => 'input_radio_checkbox_hover_backkground',
                        'label'    => esc_html__( 'Focus Background', 'beaddon' ),
                        'types'    => [ 'classic', 'gradient' ],
                        'selector' => '
                            {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox: focus
                        ',
                    ]
                );
                $this->add_control(
                    'input_radio_checkbox_hover_border_color',
                    [
                        'label'     => esc_html__( 'Border Color', 'beaddon' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox:focus' => 'border-color:{{VALUE}};'
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Box_Shadow:: get_type(),
                    [
                        'name'     => 'input_radio_checkbox_hover_shadow',
                        'selector' => '
                            {{WRAPPER}} .be__addons__login__regiser__wrap .form-checkbox: focus
                        ',
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*-----------------------------
            INPUT CHECKBOX / RADIO STYLE  END
        -------------------------------*/

        /*-------------------------------
            REMEMBER BOX
        --------------------------------*/
        $this->start_controls_section(
            '_remember_style_section',
            [
                'label' => esc_html__( 'Remember Password', 'beaddon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'remember_box_typography',
                    'selector' => '{{WRAPPER}} .form-checkbox span,{{WRAPPER}} .be-addons-modal-checkbox span',
                ]
            );
            $this->add_control(
                'remember_box_text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .form-checkbox span'            => 'color:{{VALUE}};',
                        '{{WRAPPER}} .be-addons-modal-checkbox span' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'remember_box_special_text_color',
                [
                    'label'     => esc_html__( 'Spacial Text Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .form-checkbox span span'            => 'color:{{VALUE}};',
                        '{{WRAPPER}} .be-addons-modal-checkbox span span' => 'color:{{VALUE}};',
                        '{{WRAPPER}} .be-addons-modal-checkbox span a'    => 'color:{{VALUE}};',
                        'separator' => 'before',
                    ],
                ]
            );
            $this->add_control(
                'remember_box_check_color',
                [
                    'label'     => esc_html__( 'Checkbox Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .form-checkbox span::before'               => 'border-color:{{VALUE}};',
                        '{{WRAPPER}} .be-addons-modal-checkbox .input-checkbox' => 'border-color:{{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'remember_box_check_bgcolor',
                [
                    'label'     => esc_html__( 'Check box bgColor', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .form-checkbox span::before'               => 'background:{{VALUE}};',
                        '{{WRAPPER}} .be-addons-modal-checkbox .input-checkbox' => 'background:{{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'     => 'remember_box_check_border',
                    'label'    => esc_html__( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .form-checkbox span::before,{{WRAPPER}} .be-addons-modal-checkbox .input-checkbox',
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'remember_btn_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [
                        'px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .form-checkbox'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .input-checkbox' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'remember_btn_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [
                        'px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .form-checkbox span'            => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .be-addons-modal-checkbox span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        /*-------------------------------
            REMEMBER BOX END
        --------------------------------*/

        /*-------------------------------
            LOGIN SUCCESS MESSAGE
        --------------------------------*/
        $this->start_controls_section(
            'alignment_success_msg_section',
            [
                'label' => esc_html__( 'Success Message', 'beaddon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tsucces_text_typography',
                    'label'    => esc_html__( 'Seccess Message Typography', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .login__success__message',
                ]
            );
            $this->add_control(
                'tsuccess__text_color',
                [
                    'label'     => esc_html__( 'Succes Message Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .login__success__message' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tsuccess_typography',
                    'label'    => esc_html__( 'Link Typography', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .login__success__message a',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'tsuccess_link_text_color',
                [
                    'label'     => esc_html__( 'Link Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .login__success__message a' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'success_msg_align', [
                    'label'     => esc_html__( 'Alignment', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::CHOOSE,
                    'options'   => [
                        'left'   => [
                            'title' => esc_html__( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right'  => [
                            'title' => esc_html__( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ],
                    ],
                    'default'   => 'left',
                    'selectors' => [
                        '{{WRAPPER}} .login__success__message' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'success_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .login__success__message' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        /*-------------------------------
            LOGIN SUCCESS MESSAGE END
        --------------------------------*/

        /*-------------------------------
            LOGIN ERROR MESSAGE
        --------------------------------*/
        $this->start_controls_section(
            'error__msg_section',
            [
                'label' => esc_html__( 'Error Message', 'beaddon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'error__text_color',
                [
                    'label'     => esc_html__( 'Message Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .errors li' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'eror_text_typography',
                    'label'    => esc_html__( 'Typography', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .errors li',

                ]
            );
            $this->add_responsive_control(
                'error_msg_align', [
                    'label'     => esc_html__( 'Alignment', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::CHOOSE,
                    'options'   => [
                        'left'   => [
                            'title' => esc_html__( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',

                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right'  => [
                            'title' => esc_html__( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ],
                    ],
                    'default'   => 'left',
                    'selectors' => [
                        '{{WRAPPER}} .errors' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'error_msg_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .errors' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'error_msg_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .errors li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
        /*-------------------------------
            LOGIN ERROR MESSAGE END
        --------------------------------*/

        /*----------------------------
            BUTTONS TYLE
        ------------------------------*/
        $this->start_controls_section(
            'be_addons_input_submit_style_section',
            [
                'label' => esc_html__( 'Submit Button', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs('submit_style_tabs');
                $this->start_controls_tab(
                    'submit_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'input_submit_typography',
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                        ]
                    );

                    $this->add_control(
                        'input_submit_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_submit_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                        ]
                    );

                    $this->add_responsive_control(
                        'input_submit_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 200,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'width:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ],
                            'default' => [
                                'size' => 55,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'      => 'input_submit_border',
                            'label'     => esc_html__( 'Border', 'beaddon' ),
                            'selector'  => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_submit_box_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'input_submit_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"], {{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'input_submit_floting',
                        [
                            'label'   => esc_html__( 'Button Floating', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-left',
                                ],
                                'none' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'eicon-v-align-top',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-right',
                                ],
                            ],
                            'toggle'    => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"], {{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'display:block;margin-left:auto;margin-right:auto;float:{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_text_align',
                        [
                            'label'   => esc_html__( 'Text Align', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ],
                            ],
                            'toggle'    => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"], {{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'submit_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'beaddon' ),
                    ]
                );
                    $this->add_control(
                        'input_submithover_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_submithover_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'input_submithover_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_submithover_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*----------------------------
            BUTTONS TYLE END
        ------------------------------*/

        /*----------------------------
            SIGNUP SINGNIN LINK TYLE
        ------------------------------*/
        $this->start_controls_section(
            'be_addons_signup_login_style_section',
            [
                'label' => esc_html__( 'SignUp / SingIn Link', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs('signup_login_style_tabs');
                $this->start_controls_tab(
                    'signup_login_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'signup_login_typography',
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link',
                        ]
                    );

                    $this->add_control(
                        'signup_login_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'signup_login_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link',
                        ]
                    );
					$this->add_responsive_control(
						'signup_login_display',
						[
							'label'   => __( 'Display', 'beaddon' ),
							'type'    => Controls_Manager::SELECT,
							'default' => 'inline-block',
							'options' => [
								''             => __( 'Default', 'beaddon' ),
								'initial'      => __( 'Initial', 'beaddon' ),
								'block'        => __( 'Block', 'beaddon' ),
								'inline-block' => __( 'Inline Block', 'beaddon' ),
								'flex'         => __( 'Flex', 'beaddon' ),
								'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
								'none'         => __( 'none', 'beaddon' ),
							],
							'selectors' => [
								'{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'display: {{VALUE}};',
							],
							'separator' => 'before',
						]
					);

                    $this->add_responsive_control(
                        'signup_login_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'width:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'signup_login_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ], 
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'      => 'signup_login_border',
                            'label'     => esc_html__( 'Border', 'beaddon' ),
                            'selector'  => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'signup_login_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'signup_login_box_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link',
                        ]
                    );
                    $this->add_responsive_control(
                        'signup_login_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'signup_login_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'signup_login_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'signup_login_floting',
                        [
                            'label'   => esc_html__( 'Button Floating', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-left',
                                ],
                                'none' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'eicon-v-align-top',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-right',
                                ],
                            ],
                            'toggle'    => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'display:block;margin-left:auto;margin-right:auto;float:{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'signup_login_text_align',
                        [
                            'label'   => esc_html__( 'Text Align', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ],
                            ],
                            'toggle' => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'signup_login_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'beaddon' ),
                    ]
                );
                    $this->add_control(
                        'signup_login_hover_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'signup_login_hover_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'signup_login_hover_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'signup_login_hover_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .signup__signin__link:hover',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*----------------------------
            SIGNUP SINGNIN LINK TYLE END
        ------------------------------*/

        /*----------------------------
            LOST PASSWORD LINK STYLE
        ------------------------------*/
        $this->start_controls_section(
            'be_addons_lost_password_style_section',
            [
                'label' => esc_html__( 'Lost Password Link', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs('lost_password_style_tabs');
                $this->start_controls_tab(
                    'lost_password_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'lost_password_typography',
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link',
                        ]
                    );

                    $this->add_control(
                        'lost_password_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'lost_password_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link',
                        ]
                    );
					$this->add_responsive_control(
						'lost_password_display',
						[
							'label'   => __( 'Display', 'beaddon' ),
							'type'    => Controls_Manager::SELECT,
							'default' => 'inline-block',
							'options' => [
								''             => __( 'Default', 'beaddon' ),
								'initial'      => __( 'Initial', 'beaddon' ),
								'block'        => __( 'Block', 'beaddon' ),
								'inline-block' => __( 'Inline Block', 'beaddon' ),
								'flex'         => __( 'Flex', 'beaddon' ),
								'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
								'none'         => __( 'none', 'beaddon' ),
							],
							'selectors' => [
								'{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'display: {{VALUE}};',
							],
							'separator' => 'before',
						]
					);

                    $this->add_responsive_control(
                        'lost_password_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'width:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'lost_password_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ], 
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'      => 'lost_password_border',
                            'label'     => esc_html__( 'Border', 'beaddon' ),
                            'selector'  => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'lost_password_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'lost_password_box_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link',
                        ]
                    );
                    $this->add_responsive_control(
                        'lost_password_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'lost_password_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'lost_password_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'lost_password_floting',
                        [
                            'label'   => esc_html__( 'Button Floating', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-left',
                                ],
                                'none' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'eicon-v-align-top',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-right',
                                ],
                            ],
                            'toggle'    => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'display:block;margin-left:auto;margin-right:auto;float:{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'lost_password_text_align',
                        [
                            'label'   => esc_html__( 'Text Align', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ],
                            ],
                            'toggle' => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'lost_password_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'beaddon' ),
                    ]
                );
                    $this->add_control(
                        'lost_password_hover_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'lost_password_hover_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'lost_password_hover_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'lost_password_hover_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap .lost__password__link:hover',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*----------------------------
            LOST PASSWORD LINK STYLE END
        ------------------------------*/

    }

    protected function render() {

        $settings  = $this->get_settings();
        $widget_id = 'be-addons-' . $this->get_id() . '-';

        if ( $settings['content_layout_style'] == 'layout_1' ) {
            include 'layout/signin/layout_1.php';
        }
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register_widget_type( new Be_Addons_Signin_Widget() );