<?php
    if ( isset( $_SESSION['be_addons_reg_msg'] ) ) {
        $errors = $_SESSION["be_addons_reg_msg"];
    } else {
        if ( isset( $_SESSION['be_addons_reg_msg_success'] ) ) {
            echo '<div class="login__success__message alert alert-success">' . $_SESSION['be_addons_reg_msg_success'] . '</div>';
        }
    }
?>

<?php if ( isset( $errors ) && count( $errors ) ): ?>
    <div class="login__register__error__wrap alert alert-danger">
        <ul class="errors">

            <?php foreach ( $errors as $error ): ?>
                <li><?php echo wp_kses_post( $error ); ?> </li>
            <?php endforeach;?>

        </ul>
    </div>
    <?php
        unset( $_SESSION['be_addons_reg_msg'] );
        unset( $_SESSION['be_addons_reg_msg_success'] );
    ?>

<?php endif;?>
<div class="be__addons__login__regiser__wrap">
    <form method="post" class="register form-register be__addons__register__form">

        <?php if ( $settings['custom_redirect'] == 'yes' ): ?>
            <input type="hidden" name="be_redirect" value="<?php echo esc_url( $settings['login_redirect_url'] ); ?>" />
        <?php endif;?>


        <?php if ( $settings['signup_show_name'] == 'yes' ): ?>
            <div class="input-box">
                <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                    <label for="username"><?php echo esc_html( $settings['signup_name_label'] ); ?> </label>
                <?php endif;?>

                <div class="fields__icon__group">
                    <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                        <div class="field__icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['signup_name_icon'], ['aria-hidden' => 'true'] );?>
                        </div>
                    <?php endif; ?>
                    <div class="field__data">
                        <input type="text" required name="name" placeholder="<?php echo esc_attr( $settings['signup_name_placeholder'] ); ?>" class="input-text">
                    </div>
                </div>
            </div>
        <?php else: ?>
            <input type="hidden" name="name" value="<?php echo esc_attr__( 'no name', 'beaddon' ); ?>">
        <?php endif;?>


        <div class="input-box">
            <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                <label for="username"><?php echo esc_html( $settings['signup_username_label'] ); ?> </label>
            <?php endif;?>
            
            <div class="fields__icon__group">
                <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                    <div class="field__icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['signup_username_icon'], ['aria-hidden' => 'true'] );?>
                    </div>
                <?php endif; ?>
                <div class="field__data">
                    <input type="text" name="username" required placeholder="<?php echo esc_attr( $settings['signup_username_placeholder'] ); ?>" class="input-text">
                </div>
            </div>
        </div>

        <div class="input-box">
            <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                <label for="username"><?php echo esc_html( $settings['signup_email_label'] ); ?> </label>
            <?php endif;?>

            <div class="fields__icon__group">
                <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                    <div class="field__icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['signup_email_icon'], ['aria-hidden' => 'true'] );?>
                    </div>
                <?php endif; ?>
                <div class="field__data">
                    <input type="email" name="email" required placeholder="<?php echo esc_attr( $settings['signup_email_placeholder'] ); ?>" class="input-text">
                </div>
            </div>
        </div>

        <div class="input-box">
            <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                <label for="username"><?php echo esc_html( $settings['signup_password_label'] ); ?> </label>
            <?php endif;?>
                
            <div class="fields__icon__group">
                <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                    <div class="field__icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['signup_password_icon'], ['aria-hidden' => 'true'] );?>
                    </div>
                <?php endif; ?>
                <div class="field__data">
                    <input type="password" name="password" required class="input-text" placeholder="<?php echo esc_attr( $settings['signup_password_placeholder'] ); ?>">
                </div>
            </div>
        </div>

        <?php if ( $settings['checkbox_show'] == 'yes' ): ?>
            <div class="input-box form-checkbox">
                <label>
                    <input name="terms" type="checkbox" class="input-checkbox">
                    <span>
                        <?php echo str_replace( ['{', '}'], ['<span>', '</span>'], $settings['term_text'] ); ?>
                    </span>
                </label>
            </div>
        <?php endif;?>

        <input type="hidden" name="be_addons_registration_form" />

        <?php wp_nonce_field( 'be_addons_registration_action' );?>
        
        <div class="input-box">

            <button class="user__signup__button" type="submit">
                <?php echo esc_attr( $settings['signup_submit_text'] ); ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['signup_submit_icon'], ['aria-hidden' => 'true'] );?>
            </button>

            <?php if ( $settings['_show_signin_link'] == 'yes' ): ?>
                <a class="signup__signin__link" href="<?php echo esc_url( $settings['singin_url'] ); ?>"><?php echo esc_attr( $settings['signin_text'] ); ?></a>
            <?php endif;?>
            
        </div>

    </form>
</div>