<?php
    if ( isset( $_SESSION["be_addons_login_msg"] ) ) {
        $errors = $_SESSION["be_addons_login_msg"];
    }
?>

<?php if ( isset( $errors ) && count( $errors ) ): ?>
    <div class="login__register__error__wrap alert alert-danger">
        <ul class="errors">
            <?php foreach ( $errors as $error ): ?>
                <li><?php echo wp_kses_post( $error ); ?> </li>
            <?php endforeach;?>
        </ul>
    </div>
    <?php unset( $_SESSION['be_addons_login_msg'] ); ?>
<?php endif; ?>

<?php if ( isset( $_SESSION['be_addons_login_success_msg'] ) ): ?>
    <div class="login__success__message alert alert-success"><?php echo esc_html( $_SESSION['be_addons_login_success_msg'] );unset( $_SESSION['be_addons_login_success_msg'] ); ?> </div>
<?php endif;?>

<div class="be__addons__login__regiser__wrap">
    <form action="#" method="POST" class="login form-login be__addons__login__form">

        <?php if ( $settings['custom_redirect'] == 'yes' ): ?>
            <input type="hidden" name="be_redirect" value="<?php echo esc_url( $settings['login_redirect_url'] ); ?>" />
        <?php endif;?>

        <?php wp_nonce_field( 'be_addons_login_action' );?>

        <div class="input-box">
            <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                <label for="username"><?php echo esc_html( $settings['login_username_label'] ); ?> </label>
            <?php endif;?>
            <div class="fields__icon__group">
                <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                    <div class="field__icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['login_username_icon'], ['aria-hidden' => 'true'] );?>
                    </div>
                <?php endif;?>
                <div class="field__data">
                    <input name="username" type="text" placeholder="<?php echo esc_attr( $settings['login_username_placeholder'] ); ?> " class="input-text">
                </div>
            </div>
        </div>

        <div class="input-box">
            <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                <label for="pass"><?php echo esc_html( $settings['login_password_label'] ); ?> </label>
            <?php endif;?>
            <div class="fields__icon__group">
                <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                    <div class="field__icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['login_password_icon'], ['aria-hidden' => 'true'] );?>
                    </div>
                <?php endif;?>
                <div class="field__data">
                    <input name="password" type="password" class="input-text" placeholder="<?php echo esc_attr( $settings['login_password_placeholder'] ); ?>">
                </div>
            </div>
        </div>


        <?php if ( $settings['remember_show'] == 'yes' ): ?>
            <div class="input-box form-checkbox">
                <label>
                    <input name="rememberme" type="checkbox" class="input-checkbox">
                    <span>
                        <?php echo str_replace( ['{', '}'], ['<span>', '</span>'], $settings['remember_text'] ); ?>
                    </span>
                </label>
            </div>
        <?php endif;?>

        <div class="input-btn">

            <button class="user__login__button" type="submit">
                <?php echo esc_html( $settings['login_submit_text'] ); ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['signup_submit_icon'], ['aria-hidden' => 'true'] );?>
            </button>

            <?php if ( $settings['signup_'] == 'yes' ): ?>
                <a class="signup__signin__link" href="<?php echo esc_url( $settings['signup_url'] ); ?>"><?php echo esc_html( $settings['signup_text'] ); ?></a>
            <?php endif;?>

            <?php if ( $settings['lost_password_show'] == 'yes' ): ?>
                <a class="lost__password__link" target="<?php echo esc_attr( $settings['lost_password_url']['is_external'] == '' ? '_self' : '_blank' ); ?>" href="<?php echo esc_url( $settings['lost_password_url']['url'] ); ?>"><?php echo esc_html( $settings['lost_password_text'] ); ?> </a>
            <?php endif;?>

        </div>

    </form>
</div>