<?php global $getPasswordError, $getPasswordSuccess; ?>

<?php if ( !empty($getPasswordError) ): ?>
    <div class="login__register__error__wrap alert alert-danger">
        <?php echo wp_kses_post( $getPasswordError ); ?>
    </div>
<?php endif; ?>

<?php if ( !empty($getPasswordSuccess) ): ?>
    <div class="login__success__message  alert alert-success">
        <?php echo wp_kses_post( $getPasswordSuccess ); ?>
    </div>
<?php endif;?>


<div class="be__addons__login__regiser__wrap">

    <form action="#" method="post" class="be__addons__login__form">
        <div class="forgot___pwd___form__content">
            <div class="log_user">
                <?php if ( $settings['custom_lebel'] == 'yes' ): ?>
                    <label for="username"><?php echo esc_html( $settings['login_username_label'] ); ?></label>
                <?php endif;?>
                <div class="fields__icon__group">
                    <?php if ( $settings['custom_fld_icon'] == 'yes' ): ?>
                        <div class="field__icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['login_username_icon'], ['aria-hidden' => 'true'] );?>
                        </div>
                    <?php endif;?>
                    <div class="field__data">
                        <?php $user_login = isset($_POST['user_login']) ? $_POST['user_login'] : ''; ?>
                        <input type="text" name="user_login" id="user_login" value="<?php echo esc_attr($user_login); ?>" placeholder="<?php echo esc_attr($settings['login_username_placeholder']); ?>" />
                    </div>
                </div>
            </div>

            <div class="input-box">
                <?php wp_nonce_field('userGetPassword', 'formType'); ?>
                <button type="submit" class="get_new_password">
                <?php echo esc_html( $settings['login_submit_text'] ); ?>
                    <?php \Elementor\Icons_Manager::render_icon( $settings['signup_submit_icon'], ['aria-hidden' => 'true'] );?>
                </button>
            </div>

        </div>
    </form>

</div>