<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

class Be_Addons_Forgot_Password_Widget extends Widget_Base {

    public function get_name() {
        return 'Be_Addons_Forgot_Password_Widget';
    }

    public function get_keywords() {
        return ['forgot', 'password', 'reset'];
    }

    public function get_title() {
        return esc_html__( 'Be Forgot Pass Form', 'beaddon' );
    }

    public function get_icon() {
        return 'eicon-lock-user';
    }

    public function get_categories() {
        return ['be-addons'];
    }

    public function get_script_depends() {
        return [
            'be-core',
        ];
    }

    public function content_layout_style() {
        return [
            'layout_1' => esc_html__( 'layout_1', 'beaddon' ),
        ];
    }

    protected function register_controls() {

        /*=================================
            CONTENT SECTION
        ==================================*/
        /*----------------------------
            LOGIN FORMS CONTENT & LAYOUT
        -----------------------------*/
        $this->start_controls_section(
            'content_layout',
            [
                'label' => esc_html__( 'Content & Layout', 'beaddon' ),
            ]
        );
            $this->add_control(
                'content_layout_style',
                [
                    'label'   => esc_html__( 'Form Layout', 'beaddon' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'default' => 'layout_1',
                    'options' => $this->content_layout_style(),
                ]
            );

        $this->end_controls_section();

        /*----------------------------
            LOGIN FORMS FIELDS
        -----------------------------*/
        $this->start_controls_section(
            'section_fields',
            [
                'label' => esc_html__( 'Reset Password Fields', 'beaddon' ),
            ]
        );
            $this->add_control(
                'custom_fld_icon',
                [
                    'label'        => esc_html__( 'Field Icons?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                ]
            );

            $this->add_control(
                'custom_lebel',
                [
                    'label'        => esc_html__( 'Field Lebel?', 'beaddon' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Yes', 'beaddon' ),
                    'label_off'    => esc_html__( 'No', 'beaddon' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'username_button_heading',
                [
                    'label' => __( 'Username Or Email', 'beaddon' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_username_label', [
                    'label'       => esc_html__( 'Username Or Email', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'Username Or Email', 'beaddon' ),
                    'default'     => esc_html__( 'Username Or Email', 'beaddon' ),
                    'condition'   => [
                        'custom_lebel' => ['yes'],
                    ],
                    'separator' => 'before',

                ]
            );
            $this->add_control(
                'login_username_placeholder', [
                    'label'       => esc_html__( 'Username Or Email', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'username Or Email ', 'beaddon' ),
                    'default'     => esc_html__( 'Username Or Email ', 'beaddon' ),
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_username_icon',
                [
                    'label'     => __( 'Field Icon', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::ICONS,
                    'default'   => [
                        'value'   => 'fas fa-user',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'custom_fld_icon' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'submit_button_heading',
                [
                    'label' => __( 'Submit Button', 'beaddon' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'login_submit_text', [
                    'label'       => esc_html__( 'Submit Button Text', 'beaddon' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => esc_html__( 'Get New Password ', 'beaddon' ),
                    'default'     => esc_html__( 'Get New Password', 'beaddon' ),
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'signup_submit_icon',
                [
                    'label'     => __( 'Submit Icon', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::ICONS,
                    'default'   => [
                        'value'   => 'fas fa-arrow-right',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'custom_fld_icon' => ['yes'],
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();


        /*=================================
            STYLE SECTION
        ==================================*/
        
        /*---------------------------
            WRAPPER STYLE
        ----------------------------*/
        $this->start_controls_section(
            'be_addons_form_style_section',
            [
                'label' => esc_html__( 'Wrapper Style', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'be_addons_form_section_background',
                    'label'    => esc_html__( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap',
                ]
            );
            $this->add_responsive_control(
                'be_addons_form_section_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_form_section_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_form_section_align',
                [
                    'label'   => esc_html__( 'Alignment', 'beaddon' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'beaddon' ),
                            'icon'  => 'fa fa-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        /*--------------------------
            WRAPPER STYLE END
        ----------------------------*/

        /*----------------------------
            LABEL STYLE
        ------------------------------*/
        $this->start_controls_section(
            'be_addons_form_label_style_section',
            [
                'label' => esc_html__( 'Label', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Typography:: get_type(),
                [
                    'name'     => 'label_typography',
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap label',
                ]
            );
            $this->add_control(
                'label_text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'beaddon' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'label_background',
                    'label'    => esc_html__( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap label',
                ]
            );
            $this->add_responsive_control(
                'label_width',
                [
                    'label'      => esc_html__( 'Width', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 100
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );            
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'label_border',
                    'label'    => esc_html__( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap label',
                ]
            );
            $this->add_responsive_control(
                'label_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                    'type'      => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'label_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'label_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__login__regiser__wrap label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        /*---------------------------
            LABEL STYLE END
        -----------------------------*/

        /*---------------------------
            INPUT STYLE START
        ----------------------------*/
        $this->start_controls_section(
            'be_addons_form_input_style_section',
            [
                'label' => esc_html__( 'Input', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs( 'input_box_tabs' );
                $this->start_controls_tab(
                    'input_box_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'input_box_typography',
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                        ]
                    );
                    $this->add_control(
                        'input_box_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'color:{{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'color:{{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_box_background',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                        ]
                    );
                    $this->add_control(
                        'input_box_placeholder_color',
                        [
                            'label'     => esc_html__( 'Placeholder Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]::-webkit-input-placeholder'   => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]::-moz-placeholder'            => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]:-ms-input-placeholder'        => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]::-webkit-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]::-moz-placeholder'           => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]:-ms-input-placeholder'       => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]::-webkit-input-placeholder'    => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]::-moz-placeholder'             => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]:-ms-input-placeholder'         => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]::-webkit-input-placeholder' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]::-moz-placeholder'          => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]:-ms-input-placeholder'      => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]::-webkit-input-placeholder'    => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]::-moz-placeholder'             => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]:-ms-input-placeholder'         => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]::-webkit-input-placeholder'   => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]::-moz-placeholder'            => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]:-ms-input-placeholder'        => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'                              => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'                          => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ],
                            'default' => [
                                'size' => 55,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'height:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'height:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                                'size' => 100,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'width:{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'width:{{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'input_box_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_box_shadow',
                            'selector' => '
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"],
                                {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_box_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'input_box_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]'   => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]'  => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]'    => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]' => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]'    => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]'   => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]'   => 'transition: {{SIZE}}s;',
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]'   => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'input_box_hover_tabs',
                    [
                        'label' => esc_html__( 'Focus', 'beaddon' ),
                    ]
                );
                $this->add_control(
                    'input_box_hover_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'beaddon' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]:focus'   => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]:focus'  => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]:focus'    => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]:focus' => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]:focus'    => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]:focus'   => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]:focus'   => 'color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]:focus'   => 'color:{{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Background:: get_type(),
                    [
                        'name'     => 'input_box_hover_backkground',
                        'label'    => esc_html__( 'Focus Background', 'beaddon' ),
                        'types'    => [ 'classic', 'gradient' ],
                        'selector' => '
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"] : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]: focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]  : focus
                        ',
                    ]
                );
                $this->add_control(
                    'input_box_hover_border_color',
                    [
                        'label'     => esc_html__( 'Border Color', 'beaddon' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]:focus'   => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"]:focus'  => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]:focus'    => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]:focus' => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]:focus'    => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]:focus'   => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]:focus'   => 'border-color:{{VALUE}};',
                            '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]:focus'   => 'border-color:{{VALUE}};',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Box_Shadow:: get_type(),
                    [
                        'name'     => 'input_box_hover_shadow',
                        'selector' => '
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="text"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="email"] : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="url"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="number"]: focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="tel"]   : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="date"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="file"]  : focus,
                            {{WRAPPER}} .be__addons__login__regiser__wrap input[type*="password"]  : focus
                        ',
                    ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*-----------------------------
            INPUT STYLE END
        -------------------------------*/

        /*-------------------------------
            LOGIN SUCCESS MESSAGE
        --------------------------------*/
        $this->start_controls_section(
            'alignment_success_msg_section',
            [
                'label' => esc_html__( 'Success Message', 'beaddon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tsucces_text_typography',
                    'label'    => esc_html__( 'Seccess Message Typography', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .login__success__message',
                ]
            );
            $this->add_control(
                'tsuccess__text_color',
                [
                    'label'     => esc_html__( 'Succes Message Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .login__success__message' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'tsuccess_typography',
                    'label'    => esc_html__( 'Link Typography', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .login__success__message a',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'tsuccess_link_text_color',
                [
                    'label'     => esc_html__( 'Link Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .login__success__message a' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'success_msg_align', [
                    'label'     => esc_html__( 'Alignment', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::CHOOSE,
                    'options'   => [
                        'left'   => [
                            'title' => esc_html__( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right'  => [
                            'title' => esc_html__( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ],
                    ],
                    'default'   => 'left',
                    'selectors' => [
                        '{{WRAPPER}} .login__success__message' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'success_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .login__success__message' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();
        /*-------------------------------
            LOGIN SUCCESS MESSAGE END
        --------------------------------*/

        /*-------------------------------
            LOGIN ERROR MESSAGE
        --------------------------------*/
        $this->start_controls_section(
            'error__msg_section',
            [
                'label' => esc_html__( 'Error Message', 'beaddon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'error__text_color',
                [
                    'label'     => esc_html__( 'Message Color', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .errors li' => 'color:{{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'eror_text_typography',
                    'label'    => esc_html__( 'Typography', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .errors li',

                ]
            );
            $this->add_responsive_control(
                'error_msg_align', [
                    'label'     => esc_html__( 'Alignment', 'beaddon' ),
                    'type'      => \Elementor\Controls_Manager::CHOOSE,
                    'options'   => [
                        'left'   => [
                            'title' => esc_html__( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',

                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right'  => [
                            'title' => esc_html__( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ],
                    ],
                    'default'   => 'left',
                    'selectors' => [
                        '{{WRAPPER}} .errors' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'error_msg_margin',
                [
                    'label'      => esc_html__( 'Margin', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .errors' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'error_msg_padding',
                [
                    'label'      => esc_html__( 'Padding', 'beaddon' ),
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        '{{WRAPPER}} .errors li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
        /*-------------------------------
            LOGIN ERROR MESSAGE END
        --------------------------------*/

        /*----------------------------
            BUTTONS TYLE
        ------------------------------*/
        $this->start_controls_section(
            'be_addons_input_submit_style_section',
            [
                'label' => esc_html__( 'Submit Button', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs('submit_style_tabs');
                $this->start_controls_tab(
                    'submit_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'input_submit_typography',
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                        ]
                    );

                    $this->add_control(
                        'input_submit_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_submit_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                        ]
                    );

                    $this->add_responsive_control(
                        'input_submit_width',
                        [
                            'label'      => esc_html__( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 200,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'width:{{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_height',
                        [
                            'label'      => esc_html__( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'max' => 150,
                                ],
                            ],
                            'default' => [
                                'size' => 55,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'      => 'input_submit_border',
                            'label'     => esc_html__( 'Border', 'beaddon' ),
                            'selector'  => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_border_radius',
                        [
                            'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                            'type'      => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_submit_box_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_padding',
                        [
                            'label'      => esc_html__( 'Padding', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_margin',
                        [
                            'label'      => esc_html__( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"],{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'input_submit_transition',
                        [
                            'label'      => esc_html__( 'Transition', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0.1,
                                    'max'  => 3,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"], {{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'transition: {{SIZE}}s;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'input_submit_floting',
                        [
                            'label'   => esc_html__( 'Button Floating', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-left',
                                ],
                                'none' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'eicon-v-align-top',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'eicon-h-align-right',
                                ],
                            ],
                            'toggle'    => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"], {{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'display:block;margin-left:auto;margin-right:auto;float:{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'input_submit_text_align',
                        [
                            'label'   => esc_html__( 'Text Align', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'None', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ],
                            ],
                            'toggle'    => true,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"], {{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'submit_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'beaddon' ),
                    ]
                );
                    $this->add_control(
                        'input_submithover_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'input_submithover_background_color',
                            'label'    => esc_html__( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'input_submithover_border',
                            'label'    => esc_html__( 'Border', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'input_submithover_shadow',
                            'label'    => esc_html__( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .be__addons__login__regiser__wrap input[type*="submit"]:hover,{{WRAPPER}} .be__addons__login__regiser__wrap button[type="submit"]:hover',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        /*----------------------------
            BUTTONS TYLE END
        ------------------------------*/

    }

    protected function render() {

        $settings  = $this->get_settings();
        $widget_id = 'be-addons-' . $this->get_id() . '-';

        if ( $settings['content_layout_style'] == 'layout_1' ) {
            include 'layout/reset/layout_1.php';
        }
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register_widget_type( new Be_Addons_Forgot_Password_Widget() );