<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ){ 
    exit;
}

class Be_Addons_Tabs_Menu_Widget extends Widget_Base {

    public function get_name() {
        return 'Be_Addons_Tabs_Menu_Widget';
    }
    
    public function get_title() {
        return __( 'Be Tabs', 'beaddon' );
    }

	public function get_icon() {
		return "eicon-tabs";
	}
    
	public function get_categories() {
		return [ 'be-addons' ];
	}

	public function get_keywords() {
        return[
            'tab menu',
            'advanced tab',
            'tabs button',
            'tabs',
        ];
    }

    /**
     * Elementor Templates List
     * return array
     */
    public function be_addons_elementor_template() {
        $templates = Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
        $types     = array();
        if ( empty( $templates ) ) {
            $template_lists = [ '0' => __( 'Do not Saved Templates.', 'beaddon' ) ];
        } else {
            $template_lists = [ '0' => __( 'Select Template', 'beaddon' ) ];
            foreach ( $templates as $template ) {
                $template_lists[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
        return $template_lists;
    }

    public function be_addons_tab_style(){
        $tab_style = [
            '1' => __( 'Top Menu', 'beaddon' ),
            '2' => __( 'Left Menu', 'beaddon' ),
            '3' => __( 'Right Menu', 'beaddon' ),
        ];
        return $tab_style;
    }

    protected function register_controls() {

        $this->start_controls_section(
            'tab_content',
            [
                'label' => __( 'Tabs', 'beaddon' ),
            ]
        );
            $this->add_control(
                'tab_style',
                [
                    'label'   => __( 'Menu Position', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => $this->be_addons_tab_style(),
                ]
            );
            $repeater = new Repeater();
            $repeater->start_controls_tabs('tab_content_item_area_tabs');

                $repeater->start_controls_tab(
                    'tab_content_item_area',
                    [
                        'label' => __( 'Content', 'beaddon' ),
                    ]
                );
                    
                    $repeater->add_control(
                        'set_default',
                        [
                            'label'        => __('Set as Default', 'beaddon'),
                            'type'         => Controls_Manager::SWITCHER,
                            'default'      => 'inactive',
                            'return_value' => 'active',
                            'separator' => 'before',
                        ]
                    );
                    
                    $repeater->add_control(
                        'tab_title',
                        [
                            'label'   => esc_html__( 'Title', 'beaddon' ),
                            'type'    => Controls_Manager::TEXT,
                            'default' => esc_html__( 'Tab #1', 'beaddon' ),
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'tab_subtitle',
                        [
                            'label'   => esc_html__( 'Subtitle', 'beaddon' ),
                            'type'    => Controls_Manager::TEXT,
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'tab_icon',
                        [
                            'label' => esc_html__( 'Icon', 'beaddon' ),
                            'type'  => Controls_Manager::ICONS,
                            'label_block' => true,
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'content_source',
                        [
                            'label'   => esc_html__( 'Select Content Source', 'beaddon' ),
                            'type'    => Controls_Manager::SELECT,
                            'default' => 'custom',
                            'options' => [
                                'custom'    => esc_html__( 'Content', 'beaddon' ),
                                "elementor" => esc_html__( 'Template', 'beaddon' ),
                            ],
                            'separator' => 'before',
                        ]
                    );

                     $repeater->add_control(
                        'template_id',
                        [
                            'label'     => __( 'Content', 'beaddon' ),
                            'type'      => Controls_Manager::SELECT,
                            'default'   => '0',
                            'options'   => $this->be_addons_elementor_template(),
                            'condition' => [
                                'content_source' => "elementor"
                            ],
                            'separator' => 'before',
                        ]
                    );

                     $repeater->add_control(
                        'custom_content',
                        [
                            'label'      => __( 'Content', 'beaddon' ),
                            'type'       => Controls_Manager::WYSIWYG,
                            'title'      => __( 'Content', 'beaddon' ),
                            'show_label' => false,
                            'condition'  => [
                                'content_source' => 'custom',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $repeater->end_controls_tab();// Tab Content area end

                // Style area start
                $repeater->start_controls_tab(
                    'tab_item_style_area',
                    [
                        'label' => __( 'Style', 'beaddon' ),
                    ]
                );
                    $repeater->add_control(
                        'tab_default',
                        [
                            'label' => __( 'Default', 'beaddon' ),
                            'type' => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_control(
                        'tab_title_color',
                        [
                            'label'     => esc_html__( 'Title Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} a' => 'color: {{VALUE}}',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'tab_subtitle_color',
                        [
                            'label'     => esc_html__( 'Subtitle Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} .tab__item__subtitle' => 'color: {{VALUE}}',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    
                    $repeater->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'title_background',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}}',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'tab_item_border',
                            'label'    => __( 'Border', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} a',
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_item_shadow',
                            'label'    => __( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} a',
                        ]
                    );
                    $repeater->add_control(
                        'icon_default',
                        [
                            'label' => __( 'Icon', 'beaddon' ),
                            'type' => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_control(
                        'tab_icon_color',
                        [
                            'label'     => esc_html__( 'Icon Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} i' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'tab_icon!' => '',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'tab_icon_background_color',
                        [
                            'label'     => esc_html__( 'Icon Background Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} .tab__cliper_btn_icon' => 'background-color: {{VALUE}}',
                            ],
                            'condition' => [
                                'tab_icon!' => '',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'tab_icon_size',
                        [
                            'label' => __( 'Icon Size', 'beaddon' ),
                            'type'  => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'size' => 14,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav {{CURRENT_ITEM}} i' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_control(
                        'tab_active',
                        [
                            'label' => __( 'Active / Hover', 'beaddon' ),
                            'type' => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_control(
                        'tab_title_active_color',
                        [
                            'label'     => esc_html__( 'Title Active Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} a' => 'color: {{VALUE}}',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_control(
                        'tab_subtitle_active_color',
                        [
                            'label'     => esc_html__( 'Active Subtitle Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} .tab__item__subtitle' => 'color: {{VALUE}}',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'title_active_background',
                            'label'    => __( 'Active Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} a',
                            'separator' => 'before',
                        ]
                    );

                    $repeater->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'tab_item_active_border',
                            'label'    => __( 'Border', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} a',
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_item_active_shadow',
                            'label'    => __( 'Box Shadow', 'beaddon' ),
                            'selector' => '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} a',
                        ]
                    );

                    $repeater->add_control(
                        'icon_active',
                        [
                            'label' => __( 'Action Icon', 'beaddon' ),
                            'type' => \Elementor\Controls_Manager::HEADING,
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_control(
                        'tab_icon_active_color',
                        [
                            'label'     => esc_html__( 'Active Icon Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} i' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'tab_icon!' => '',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_control(
                        'tab_icon_active_background_color',
                        [
                            'label'     => esc_html__( 'Icon Background Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li.active{{CURRENT_ITEM}} .tab__cliper_btn_icon' => 'background-color: {{VALUE}}',
                            ],
                            'condition' => [
                                'tab_icon!' => '',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $repeater->end_controls_tab(); // Style area end

            $repeater->end_controls_tabs();

            $this->add_control(
                'tabs_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'tab_title'      => esc_html__( 'Title #1', 'beaddon' ),
                            'custom_content' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolo magna aliqua. Ut enim ad minim veniam, quis nostrud exerci ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in repre in voluptate.','beaddon' ),
                        ],
                        [
                            'tab_title'      => esc_html__( 'Title #2', 'beaddon' ),
                            'custom_content' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolo magna aliqua. Ut enim ad minim veniam, quis nostrud exerci ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in repre in voluptate.','beaddon' ),
                        ],
                        [
                            'tab_title'      => esc_html__( 'Title #3', 'beaddon' ),
                            'custom_content' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolo magna aliqua. Ut enim ad minim veniam, quis nostrud exerci ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in repre in voluptate.','beaddon' ),
                        ],
                    ],
                    'title_field' => '{{{ tab_title }}}',
                ]
            );
            
        $this->end_controls_section();


        // Style tab area tab section
        $this->start_controls_section(
            'be_addons_tab_style_wrap_area',
            [
                'label' => __( 'Main Wrap', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'be_addons_tab_wrap_bg',
                    'label'    => __( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .tabs__area',
                ]
            );
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'be_addons_tab_wrap_border',
                    'label'    => __( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .tabs__area',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_wrap_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                    'type'      => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .tabs__area' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow:: get_type(),
                [
                    'name'     => 'be_addons_tab_wrap_shadow',
                    'label'    => __( 'Box Shadow', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .tabs__area',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_wrap_margin',
                [
                    'label'      => __( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .tabs__area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_wrap_padding',
                [
                    'label'      => __( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .tabs__area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'tab_wrap_cs_css',
                [
                    'label'     => __( 'Custom CSS', 'beaddon' ),
                    'type'      => Controls_Manager::CODE,
                    'rows'      => 20,
                    'language'  => 'css',
                    'selectors' => [
                        '{{WRAPPER}} .tabs__area' => '{{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();


        // Style tab area tab section
        $this->start_controls_section(
            'be_addons_tab_style_area',
            [
                'label' => __( 'Tab Menu Wrap', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'be_addons_tab_section_bg',
                    'label'    => __( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .tab__nav',
                ]
            );
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'be_addons_tab_section_border',
                    'label'    => __( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .tab__nav',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_section_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                    'type'      => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow:: get_type(),
                [
                    'name'     => 'be_addons_tab_section_shadow',
                    'label'    => __( 'Box Shadow', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .tab__nav',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_section_display',
                [
                    'label'   => __( 'Display', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'initial'      => __( 'Initial', 'beaddon' ),
                        'block'        => __( 'Block', 'beaddon' ),
                        'inline-block' => __( 'Inline Block', 'beaddon' ),
                        'flex'         => __( 'Flex', 'beaddon' ),
                        'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
                        'none'         => __( 'none', 'beaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'display: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'menu_text_align',
                [
                    'label'   => __( 'Alignment', 'beaddon' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'beaddon' ),
                            'icon'  => 'fa fa-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'beaddon' ),
                            'icon'  => 'fa fa-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'beaddon' ),
                            'icon'  => 'fa fa-align-right',
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_section_float',
                [
                    'label'   => __( 'Float', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'left'     => __( 'Left', 'beaddon' ),
                        'right'    => __( 'Right', 'beaddon' ),
                        'inherit ' => __( 'Inherit', 'beaddon' ),
                        'none'     => __( 'None', 'beaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'float: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_section_width',
                [
                    'label'      => __( 'Width', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'vw' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 9999,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_section_height',
                [
                    'label'      => __( 'Height', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 9999,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_section_margin',
                [
                    'label'      => __( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .tab__nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_section_padding',
                [
                    'label'      => __( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'custom_area_css',
                [
                    'label'     => __( 'Custom CSS', 'beaddon' ),
                    'type'      => Controls_Manager::CODE,
                    'rows'      => 20,
                    'language'  => 'css',
                    'selectors' => [
                        '{{WRAPPER}} .tab__nav' => '{{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'tab_button_icon_style_section',
            [
                'label' => __( 'Tab Menu Icon', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs( 'tabs_button_icon_style' );
                $this->start_controls_tab(
                    'tab_button_icon_normal',
                    [
                        'label' => __( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'tab_button_icon_display',
                        [
                            'label'   => __( 'Display', 'beaddon' ),
                            'type'    => Controls_Manager::SELECT,                
                            'options' => [
                                'initial'      => __( 'Initial', 'beaddon' ),
                                'block'        => __( 'Block', 'beaddon' ),
                                'inline-block' => __( 'Inline Block', 'beaddon' ),
                                'flex'         => __( 'Flex', 'beaddon' ),
                                'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
                                'none'         => __( 'none', 'beaddon' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'display: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'tab_button_icon_align',
                        [
                            'label'   => __( 'Alignment', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => __( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => __( 'Center', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => __( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'tab_button_icon_color',
                        [
                            'label'     => __( 'Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'tab_button_icon_typography',
                            'selector' => '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'tab_button_icon_background',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'tab_button_icon_border',
                            'selector' => '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'tab_button_icon_radius',
                        [
                            'label'      => __( 'Border Radius', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_button_icon_box_shadow',
                            'selector' => '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon',
                        ]
                    );

                    $this->add_responsive_control(
                        'tab_button_icon_width',
                        [
                            'label'      => __( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%', 'vw' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 9999,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'tab_button_icon_height',
                        [
                            'label'      => __( 'Height', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%', 'vw' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 9999,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    
                    $this->add_responsive_control(
                        'tab_button_icon_margin',
                        [
                            'label'      => __( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    
                    $this->add_responsive_control(
                        'tab_button_icon_padding',
                        [
                            'label'   => __( 'Padding', 'beaddon' ),
                            'type'    => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );   
                    
                    $this->add_responsive_control(
                        'tab_button_icon_custom_css',
                        [
                            'label'     => __( 'Custom CSS', 'beaddon' ),
                            'type'      => Controls_Manager::CODE,
                            'rows'      => 20,
                            'language'  => 'css',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__cliper_btn_icon' => '{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab();

                $this->start_controls_tab(
                    'tab_button_icon_hover',
                    [
                        'label' => __( 'Hover', 'beaddon' ),
                    ]
                );

                    $this->add_control(
                        'tab_button_icon_hover_color',
                        [
                            'label'     => __( 'Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li:hover .tab__cliper_btn_icon, {{WRAPPER}} .tab__nav li.active .tab__cliper_btn_icon' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'tab_button_icon_hover_background',
                        [
                            'label'     => __( 'Background Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'default'   => '#f8f8f8',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li:hover .tab__cliper_btn_icon, {{WRAPPER}} .tab__nav li.active .tab__cliper_btn_icon' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    
                    $this->add_control(
                        'tab_button_icon_hover_border_color',
                        [
                            'label'     => __( 'Border Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li:hover .tab__cliper_btn_icon, {{WRAPPER}} .tab__nav li.active .tab__cliper_btn_icon' => 'border-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_button_icon_hover_box_shadow',
                            'selector' => '{{WRAPPER}} .tab__nav li:hover .tab__cliper_btn_icon, {{WRAPPER}} .tab__nav li.active .tab__cliper_btn_icon',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_icon_hover_custom_css',
                        [
                            'label'     => __( 'Custom CSS', 'beaddon' ),
                            'type'      => Controls_Manager::CODE,
                            'rows'      => 20,
                            'language'  => 'css',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li:hover .tab__cliper_btn_icon, {{WRAPPER}} .tab__nav li.active .tab__cliper_btn_icon' => '{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'tab_button_style_section',
            [
                'label' => __( 'Tab Menu Item', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs( 'tabs_button_style' );
                $this->start_controls_tab(
                    'tab_button_normal',
                    [
                        'label' => __( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'tab_button_display',
                        [
                            'label'   => __( 'Display', 'beaddon' ),
                            'type'    => Controls_Manager::SELECT,                
                            'options' => [
                                'initial'      => __( 'Initial', 'beaddon' ),
                                'block'        => __( 'Block', 'beaddon' ),
                                'inline-block' => __( 'Inline Block', 'beaddon' ),
                                'flex'         => __( 'Flex', 'beaddon' ),
                                'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
                                'none'         => __( 'none', 'beaddon' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => 'display: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'tab_button_text_align',
                        [
                            'label'   => __( 'Alignment', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => __( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => __( 'Center', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => __( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'tab_button_color',
                        [
                            'label'     => __( 'Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );       
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'tab_button_typography',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'tab_button_background_color',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'tab_button_border',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'tab_button_radius',
                        [
                            'label'      => __( 'Border Radius', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_button_box_shadow',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button',
                        ]
                    );

                    $this->add_responsive_control(
                        'tab_button_width',
                        [
                            'label'      => __( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%', 'vw' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 9999,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    
                    $this->add_responsive_control(
                        'tab_button_margin',
                        [
                            'label'      => __( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    
                    $this->add_responsive_control(
                        'tab_button_padding',
                        [
                            'label'   => __( 'Padding', 'beaddon' ),
                            'type'    => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tab__nav .tab__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );   
                    
                    $this->add_responsive_control(
                        'tab_button_custom_css',
                        [
                            'label'     => __( 'Custom CSS', 'beaddon' ),
                            'type'      => Controls_Manager::CODE,
                            'rows'      => 20,
                            'language'  => 'css',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => '{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab();

                $this->start_controls_tab(
                    'tab_button_hover',
                    [
                        'label' => __( 'Hover', 'beaddon' ),
                    ]
                );

                    $this->add_control(
                        'tab_button_hover_color',
                        [
                            'label'     => __( 'Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button:hover, {{WRAPPER}} .tab__nav li.active .tab__button' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'tab_button_hover_background',
                        [
                            'label'     => __( 'Background Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'default'   => '#f8f8f8',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button:hover, {{WRAPPER}} .tab__nav li.active .tab__button' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    
                    $this->add_control(
                        'tab_button_hover_border_color',
                        [
                            'label'     => __( 'Border Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button:hover, {{WRAPPER}} .tab__nav li.active .tab__button' => 'border-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_button_hover_box_shadow',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button:hover, {{WRAPPER}} .tab__nav li.active .tab__button',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_hover_custom_css',
                        [
                            'label'     => __( 'Custom CSS', 'beaddon' ),
                            'type'      => Controls_Manager::CODE,
                            'rows'      => 20,
                            'language'  => 'css',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => '{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();


        $this->start_controls_section(
            'tab_button_subtitle_style_section',
            [
                'label' => __( 'Tab Menu Subtitle', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->start_controls_tabs( 'tabs_button_subtitle_style' );
                $this->start_controls_tab(
                    'tab_button_subtitle_normal',
                    [
                        'label' => __( 'Normal', 'beaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'tab_button_subtitle_display',
                        [
                            'label'   => __( 'Display', 'beaddon' ),
                            'type'    => Controls_Manager::SELECT,                
                            'options' => [
                                'initial'      => __( 'Initial', 'beaddon' ),
                                'block'        => __( 'Block', 'beaddon' ),
                                'inline-block' => __( 'Inline Block', 'beaddon' ),
                                'flex'         => __( 'Flex', 'beaddon' ),
                                'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
                                'none'         => __( 'none', 'beaddon' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li .tab__item__subtitle' => 'display: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_subtitle_text_align',
                        [
                            'label'   => __( 'Alignment', 'beaddon' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => __( 'Left', 'beaddon' ),
                                    'icon'  => 'fa fa-align-left',
                                ],
                                'center' => [
                                    'title' => __( 'Center', 'beaddon' ),
                                    'icon'  => 'fa fa-align-center',
                                ],
                                'right' => [
                                    'title' => __( 'Right', 'beaddon' ),
                                    'icon'  => 'fa fa-align-right',
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle' => 'text-align: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'tab_button_subtitle_color',
                        [
                            'label'     => __( 'Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );       
                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'tab_button_subtitle_typography',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'tab_button_subtitle_background_color',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'tab_button_subtitle_border',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle',
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'tab_button_subtitle_radius',
                        [
                            'label'      => __( 'Border Radius', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_button_subtitle_box_shadow',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_subtitle_width',
                        [
                            'label'      => __( 'Width', 'beaddon' ),
                            'type'       => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%', 'vw' ],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 9999,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_subtitle_margin',
                        [
                            'label'      => __( 'Margin', 'beaddon' ),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_subtitle_padding',
                        [
                            'label'   => __( 'Padding', 'beaddon' ),
                            'type'    => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors'  => [
                                '{{WRAPPER}} .tab__nav .tab__button .tab__item__subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_subtitle_custom_css',
                        [
                            'label'     => __( 'Custom CSS', 'beaddon' ),
                            'type'      => Controls_Manager::CODE,
                            'rows'      => 20,
                            'language'  => 'css',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => '{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'tab_button_subtitle_hover',
                    [
                        'label' => __( 'Hover', 'beaddon' ),
                    ]
                );
                    $this->add_control(
                        'tab_button_subtitle_hover_color',
                        [
                            'label'     => __( 'Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button:hover .tab__item__subtitle, {{WRAPPER}} .tab__nav li.active .tab__button .tab__item__subtitle' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_control(
                        'tab_button_subtitle_hover_background',
                        [
                            'label'     => __( 'Background Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'default'   => '#f8f8f8',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button:hover .tab__item__subtitle, {{WRAPPER}} .tab__nav li.active .tab__button .tab__item__subtitle' => 'background-color: {{VALUE}};',
                            ],
                        ]
                    );
                    
                    $this->add_control(
                        'tab_button_subtitle_hover_border_color',
                        [
                            'label'     => __( 'Border Color', 'beaddon' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav .tab__button:hover .tab__item__subtitle, {{WRAPPER}} .tab__nav li.active .tab__button .tab__item__subtitle' => 'border-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'tab_button_subtitle_hover_box_shadow',
                            'selector' => '{{WRAPPER}} .tab__nav .tab__button:hover .tab__item__subtitle, {{WRAPPER}} .tab__nav li.active .tab__button .tab__item__subtitle',
                        ]
                    );
                    $this->add_responsive_control(
                        'tab_button_subtitle_hover_custom_css',
                        [
                            'label'     => __( 'Custom CSS', 'beaddon' ),
                            'type'      => Controls_Manager::CODE,
                            'rows'      => 20,
                            'language'  => 'css',
                            'selectors' => [
                                '{{WRAPPER}} .tab__nav li' => '{{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();


        // Style tab item content
        $this->start_controls_section(
            'tab_style_content_section',
            [
                'label' => __( 'Content', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'be_addons_tab_content_display',
                [
                    'label'   => __( 'Display', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'initial'      => __( 'Initial', 'beaddon' ),
                        'block'        => __( 'Block', 'beaddon' ),
                        'inline-block' => __( 'Inline Block', 'beaddon' ),
                        'flex'         => __( 'Flex', 'beaddon' ),
                        'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
                        'none'         => __( 'none', 'beaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single__tab__item' => 'display: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_content_float',
                [
                    'label'   => __( 'Float', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'left'     => __( 'Left', 'beaddon' ),
                        'right'    => __( 'Right', 'beaddon' ),
                        'inherit ' => __( 'Inherit', 'beaddon' ),
                        'none'     => __( 'None', 'beaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single__tab__item' => 'float: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'tab_content_background',
                    'label'    => __( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .single__tab__item',
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'tab_content_border',
                    'label'    => __( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .single__tab__item',
                ]
            );

            $this->add_responsive_control(
                'tab_content_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                    'type'      => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .single__tab__item' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_content_width',
                [
                    'label'      => __( 'Width', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'vw' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 9999,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .single__tab__item' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'tab_content_margin',
                [
                    'label'      => __( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .single__tab__item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'tab_content_padding',
                [
                    'label'      => __( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .single__tab__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Style tab area tab section
        $this->start_controls_section(
            'be_addons_tab_content_area_style',
            [
                'label' => __( 'Tab Content Wrap', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_responsive_control(
                'be_addons_tab_content_area_display',
                [
                    'label'   => __( 'Display', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'initial'      => __( 'Initial', 'beaddon' ),
                        'block'        => __( 'Block', 'beaddon' ),
                        'inline-block' => __( 'Inline Block', 'beaddon' ),
                        'flex'         => __( 'Flex', 'beaddon' ),
                        'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
                        'none'         => __( 'none', 'beaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__content__area' => 'display: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'be_addons_tab_content_area_float',
                [
                    'label'   => __( 'Float', 'beaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'left'     => __( 'Left', 'beaddon' ),
                        'right'    => __( 'Right', 'beaddon' ),
                        'inherit ' => __( 'Inherit', 'beaddon' ),
                        'none'     => __( 'None', 'beaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__content__area' => 'float: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
        
            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'be_addons_tab_content_area_bg',
                    'label'    => __( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .tab__content__area',
                    'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'be_addons_tab_content_area_border',
                    'label'    => __( 'Border', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .tab__content__area',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_content_area_border_radius',
                [
                    'label'     => esc_html__( 'Border Radius', 'beaddon' ),
                    'type'      => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .tab__content__area' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow:: get_type(),
                [
                    'name'     => 'be_addons_tab_content_area_shadow',
                    'label'    => __( 'Box Shadow', 'beaddon' ),
                    'selector' => '{{WRAPPER}} .tab__content__area',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_content_area_width',
                [
                    'label'      => __( 'Width', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'vw' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 9999,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__content__area' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_content_area_height',
                [
                    'label'      => __( 'Height', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 9999,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .tab__content__area' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'be_addons_tab_content_area_margin',
                [
                    'label'      => __( 'Margin', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .tab__content__area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'be_addons_tab_content_area_padding',
                [
                    'label'      => __( 'Padding', 'beaddon' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors'  => [
                        '{{WRAPPER}} .tab__content__area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'custom_tab_content_area_css',
                [
                    'label'     => __( 'Custom CSS', 'beaddon' ),
                    'type'      => Controls_Manager::CODE,
                    'rows'      => 20,
                    'language'  => 'css',
                    'selectors' => [
                        '{{WRAPPER}} .tab__content__area' => '{{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {
        $settings = $this->get_settings_for_display();

        $id = $this->get_id();
        $this->add_render_attribute( 'tabs_area_attr', 'id', 'tabs__area__'.$id );
        $this->add_render_attribute( 'tabs_area_attr', 'class', 'tabs__area' );
        $this->add_render_attribute( 'tabs_area_attr', 'class', 'tab__style__'.$settings['tab_style'] );

        $this->add_render_attribute( 'tab_menu_attr', 'class', 'nav-tabs tab__nav');
        $this->add_render_attribute( 'tab_menu_attr', 'role', 'tablist');
        $this->add_render_attribute( 'tab_menu_attr', 'class', 'tab__nav__style__'.$settings['tab_style'] );
        $id = $this->get_id();
        ?>
            <div <?php echo $this->get_render_attribute_string( 'tabs_area_attr' ); ?>>

                <ul <?php echo $this->get_render_attribute_string( 'tab_menu_attr' ); ?>>
                    <?php
                        $i = 0;
                        foreach ( $settings['tabs_list'] as $item ) {
                            $i++;

                            if ( isset($item['set_default']) && 'active' == $item['set_default'] ) {
                                $active_tab = $item['set_default'] .' elementor-repeater-item-'.$item['_id'];
                            }elseif( !isset($item['set_default']) && $i == 1 ){
                                $active_tab = 'active elementor-repeater-item-'.$item['_id'];
                            }else{
                                $active_tab ='elementor-repeater-item-'.$item['_id'];
                            }

                            //if( $i == 1 ){ $active_tab = 'active'; } else{ $active_tab = ''; }

                            $sutitle = $item['tab_subtitle'] ? '<span class="tab__item__subtitle">'.$item['tab_subtitle'].'</span>' : '';

                            $tabbuttontxt = $item['tab_title'] .$sutitle;
                            if( !empty( $item['tab_icon'] ) ){
                                $tabbuttontxt = '<div class="tab__cliper_btn_icon">'.be_addons_render_icons( $item['tab_icon'] ).'</div>'.$item['tab_title'].$sutitle;
                            }

                            echo sprintf( '<li class="%1$s" ><a class="tab__button %4$s" href="#tabitem-%2$s" data-toggle="tab">%3$s</a></li>',$active_tab, $id.$i, $tabbuttontxt, 'item-'.$item['_id']);
                        }
                    ?>
                </ul>
                <div class="tab__content__area tab-content">
                    <?php
                        $i = 0;
                        foreach ( $settings['tabs_list'] as $item ) {
                            $i++;                            

                            if ( isset($item['set_default']) && 'active' == $item['set_default'] ) {
                                $active_tab = $item['set_default'].' active';
                            }elseif( !isset($item['set_default']) && $i == 1 ){
                                $active_tab = 'active';
                            }else{
                                $active_tab = '';
                            }

                            if ( $item['content_source'] == 'custom' && !empty( $item['custom_content'] ) ) {
                                $tab_content = wp_kses_post( $item['custom_content'] );
                            } elseif ( $item['content_source'] == "elementor" && !empty( $item['template_id'] )) {
                                $tab_content = Plugin::instance()->frontend->get_builder_content_for_display( $item['template_id'] );
                            }else{
                                $tab_content = '';
                            }
                            echo sprintf('<div class="single__tab__item tab-pane %1$s %4$s" id="tabitem-%2$s"><div class="tab__inner__content">%3$s</div></div>', $active_tab, $id.$i, $tab_content,'elementor-repeater-item-'.$item['_id']);
                        }
                    ?>
                </div>
            </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Be_Addons_Tabs_Menu_Widget() );