<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Be_Addons_Positions_Element extends Widget_Base {

	public function get_name() {
		return 'PositionElement';
	}

	public function get_title() {
		return __( 'Be Position Element', 'beaddon' );
	}

	public function get_icon() {
		return 'eicon-drag-n-drop';
	}

	public function get_categories() {
		return array('be-addons');
	}

    public function get_keywords() {
        return[
            'postion element',
            'position',
            'element',
            'shape',
        ];
    }

	public static function get_animation_style(){
		return [
			'Zoom_In_Out animated'        => __('Zoom_In_Out', 'beaddon'),
			'Circle_Large animated'       => __('Circle_Large', 'beaddon'),
			'Fade_In_Out animated'        => __('Fade_In_Out', 'beaddon'),
			'littleCircle animated'       => __('littleCircle', 'beaddon'),
			'bigCircle animated'          => __('bigCircle', 'beaddon'),
			'Hoop animated'               => __('Hoop', 'beaddon'),
			'triAngle animated'           => __('triAngle', 'beaddon'),
			'littleSquare animated'       => __('littleSquare', 'beaddon'),
			'bigSquare animated'          => __('bigSquare', 'beaddon'),
			'fadeInRotate animated'       => __('fadeInRotate', 'beaddon'),
			'fadeInBack animated'         => __('fadeInBack', 'beaddon'),
			'blurFadeIn animated'         => __('blurFadeIn', 'beaddon'),
			'blurFadeInOut animated'      => __('blurFadeInOut', 'beaddon'),
			'ballBounce animated'         => __('ballBounce', 'beaddon'),
			'zoomBounce animated'         => __('zoomBounce', 'beaddon'),
			'FramesOne animated'          => __('FramesOne', 'beaddon'),
			'FramesTwo animated'          => __('FramesTwo', 'beaddon'),
			'FramesThree animated'        => __('FramesThree', 'beaddon'),
			'FramesFour animated'         => __('FramesFour', 'beaddon'),
			'FramesFive animated'         => __('FramesFive', 'beaddon'),
			'scaleUpOne animated'         => __('scaleUpOne', 'beaddon'),
			'scaleUpOne animated'         => __('scaleUpOne', 'beaddon'),
			'scaleUpTwo animated'         => __('scaleUpTwo', 'beaddon'),
			'scaleUpThree animated'       => __('scaleUpThree', 'beaddon'),
			'prettyFade animated'         => __('prettyFade', 'beaddon'),
			'fade_in animated'            => __('fade_in', 'beaddon'),
			'scaleRight animated'         => __('scaleRight', 'beaddon'),
			'scaleUpOne animated'         => __('scaleUpOne', 'beaddon'),
			'bigSpin animated'            => __('bigSpin', 'beaddon'),
			'rotated animated'            => __('rotated', 'beaddon'),
			'rotatedHalf animated'        => __('rotatedHalf', 'beaddon'),
			'rotatedHalfTwo animated'     => __('rotatedHalfTwo', 'beaddon'),
			'jump animated'               => __('jump', 'beaddon'),
			'imageBgAnim animated'        => __('imageBgAnim', 'beaddon'),
			'bgMove animated'             => __('bgMove', 'beaddon'),
			'gradientBG animated'         => __('gradientBG', 'beaddon'),
			'rippleOutOne animated'       => __('rippleOutOne', 'beaddon'),
			'rippleOuTwo animated'        => __('rippleOuTwo', 'beaddon'),
			'bounce animated'             => __('bounce','beaddon'),
			'flash animated'              => __('flash','beaddon'),
			'pulse animated'              => __('pulse','beaddon'),
			'rubberBand animated'         => __('rubberBand','beaddon'),
			'shake animated'              => __('shake','beaddon'),
			'headShake animated'          => __('headShake','beaddon'),
			'swing animated'              => __('swing','beaddon'),
			'tada animated'               => __('tada','beaddon'),
			'wobble animated'             => __('wobble','beaddon'),
			'jello animated'              => __('jello','beaddon'),
			'heartBeat animated'          => __('heartBeat','beaddon'),
			'bounceIn animated'           => __('bounceIn','beaddon'),
			'bounceInDown animated'       => __('bounceInDown','beaddon'),
			'bounceInLeft animated'       => __('bounceInLeft','beaddon'),
			'bounceInRight animated'      => __('bounceInRight','beaddon'),
			'bounceInUp animated'         => __('bounceInUp','beaddon'),
			'bounceOut animated'          => __('bounceOut','beaddon'),
			'bounceOutDown animated'      => __('bounceOutDown','beaddon'),
			'bounceOutLeft animated'      => __('bounceOutLeft','beaddon'),
			'bounceOutRight animated'     => __('bounceOutRight','beaddon'),
			'bounceOutUp animated'        => __('bounceOutUp','beaddon'),
			'fadeIn animated'             => __('fadeIn','beaddon'),
			'fadeInDown animated'         => __('fadeInDown','beaddon'),
			'fadeInDownBig animated'      => __('fadeInDownBig','beaddon'),
			'fadeInLeft animated'         => __('fadeInLeft','beaddon'),
			'fadeInLeftBig animated'      => __('fadeInLeftBig','beaddon'),
			'fadeInRight animated'        => __('fadeInRight','beaddon'),
			'fadeInRightBig animated'     => __('fadeInRightBig','beaddon'),
			'fadeInUp animated'           => __('fadeInUp','beaddon'),
			'fadeInUpBig animated'        => __('fadeInUpBig','beaddon'),
			'fadeOut animated'            => __('fadeOut','beaddon'),
			'fadeOutDown animated'        => __('fadeOutDown','beaddon'),
			'fadeOutDownBig animated'     => __('fadeOutDownBig','beaddon'),
			'fadeOutLeft animated'        => __('fadeOutLeft','beaddon'),
			'fadeOutLeftBig animated'     => __('fadeOutLeftBig','beaddon'),
			'fadeOutRight animated'       => __('fadeOutRight','beaddon'),
			'fadeOutRightBig animated'    => __('fadeOutRightBig','beaddon'),
			'fadeOutUp animated'          => __('fadeOutUp','beaddon'),
			'fadeOutUpBig animated'       => __('fadeOutUpBig','beaddon'),
			'flip animated'               => __('flip','beaddon'),
			'flipInX animated'            => __('flipInX','beaddon'),
			'flipInY animated'            => __('flipInY','beaddon'),
			'flipOutX animated'           => __('flipOutX','beaddon'),
			'flipOutY animated'           => __('flipOutY','beaddon'),
			'lightSpeedIn animated'       => __('lightSpeedIn','beaddon'),
			'lightSpeedOut animated'      => __('lightSpeedOut','beaddon'),
			'rotateIn animated'           => __('rotateIn','beaddon'),
			'rotateInDownLeft animated'   => __('rotateInDownLeft','beaddon'),
			'rotateInDownRight animated'  => __('rotateInDownRight','beaddon'),
			'rotateInUpLeft animated'     => __('rotateInUpLeft','beaddon'),
			'rotateInUpRight animated'    => __('rotateInUpRight','beaddon'),
			'rotateOut animated'          => __('rotateOut','beaddon'),
			'rotateOutDownLeft animated'  => __('rotateOutDownLeft','beaddon'),
			'rotateOutDownRight animated' => __('rotateOutDownRight','beaddon'),
			'rotateOutUpLeft animated'    => __('rotateOutUpLeft','beaddon'),
			'rotateOutUpRight animated'   => __('rotateOutUpRight','beaddon'),
			'hinge animated'              => __('hinge','beaddon'),
			'jackInTheBox animated'       => __('jackInTheBox','beaddon'),
			'rollIn animated'             => __('rollIn','beaddon'),
			'rollOut animated'            => __('rollOut','beaddon'),
			'zoomIn animated'             => __('zoomIn','beaddon'),
			'zoomInDown animated'         => __('zoomInDown','beaddon'),
			'zoomInLeft animated'         => __('zoomInLeft','beaddon'),
			'zoomInRight animated'        => __('zoomInRight','beaddon'),
			'zoomInUp animated'           => __('zoomInUp','beaddon'),
			'zoomOut animated'            => __('zoomOut','beaddon'),
			'zoomOutDown animated'        => __('zoomOutDown','beaddon'),
			'zoomOutLeft animated'        => __('zoomOutLeft','beaddon'),
			'zoomOutRight animated'       => __('zoomOutRight','beaddon'),
			'zoomOutUp animated'          => __('zoomOutUp','beaddon'),
			'slideInDown animated'        => __('slideInDown','beaddon'),
			'slideInLeft animated'        => __('slideInLeft','beaddon'),
			'slideInRight animated'       => __('slideInRight','beaddon'),
			'slideInUp animated'          => __('slideInUp','beaddon'),
			'slideOutDown animated'       => __('slideOutDown','beaddon'),
			'slideOutLeft animated'       => __('slideOutLeft','beaddon'),
			'slideOutRight animated'      => __('slideOutRight','beaddon'),
			'slideOutUp animated'         => __('slideOutUp','beaddon'),
		];
	}

	protected function register_controls() {

		/******************************
		 * 	CONTENT SECTION
		 ******************************/
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'beaddon' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

			// Icon Type
			$this->add_control(
				'postion_element_type',
				[
					'label'   => __( 'Element Type', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'postion_element_font_or_svg_icon',
					'options' => [
						'postion_element_font_or_svg_icon' => __( 'Font Icon / SVG', 'beaddon' ),
						'postion_element_image'            => __( 'Image Icon / Image', 'beaddon' ),
						'postion_element_text'             => __( 'Simple Text', 'beaddon' ),
						'postion_element_shape'            => __( 'Blank Shape', 'beaddon' ),
					],
				]
			);

			// Font Icon
			$this->add_control(
				'postion_element_font_or_svg_icon',
				[
					'label'       => __( 'Font Icons', 'beaddon' ),
					'type'        => Controls_Manager::ICONS,
					'label_block' => true,
					'default'     => [
						'value'   => 'fas fa-star',
						'library' => 'solid',
					],
					'condition' => [
						'postion_element_type' => 'postion_element_font_or_svg_icon',
					],
				]
			);

			// Image Icon
			$this->add_control(
				'postion_element_image',
				[
					'label'   => __( 'Image Icon / Image', 'beaddon' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'postion_element_type' => 'postion_element_image',
					],
				]
			);

			// Image size
			$this->add_group_control(
				Group_Control_Image_Size:: get_type(),
				[
					'name'      => 'postion_element_image_size',
					'default'   => 'thumbnail',
					'condition' => [
						'postion_element_type' => 'postion_element_image',
					],
				]
			);

			// Title
			$this->add_control(
				'title',
				[
					'label'       => __( 'Text', 'beaddon' ),
					'type'        => Controls_Manager::TEXT,
					'placeholder' => __( 'Title', 'beaddon' ),
					'condition'   => [
						'postion_element_type' => 'postion_element_text',
					],
				]
			);

			// Animation
			$this->add_control(
				'element_animation',
				[
					'label'   => __( 'Element Animation', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'no',
					'options' => [
						'yes' => __( 'Yes', 'beaddon' ),
						'no'  => __( 'No', 'beaddon' ),
					],
				]
			);

			// Custom Animate
			$this->add_control(
				'element_animation_type',
				[
					'label'     => __( 'Custom Animate Type', 'beaddon' ),
					'type'      => Controls_Manager::SELECT,
					'default'   => 'fadeIn',
					'options'   => self::get_animation_style(),
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

			// Speed
			$this->add_control(
				'element_animation_speed',
				[
					'label'   => __( 'Animation Speed', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'no',
					'options' => [
						'fast'   => __( 'Fast', 'beaddon' ),
						'faster' => __( 'Faster', 'beaddon' ),
						'slow'   => __( 'Slow', 'beaddon' ),
						'slower' => __( 'Slower', 'beaddon' ),
					],
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

			// Infinite
			$this->add_control(
				'element_animation_infinite',
				[
					'label'   => __( 'Infine Animation', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'no',
					'options' => [
						'infinite' => __( 'Yes', 'beaddon' ),
						'normal'   => __( 'No', 'beaddon' ),
					],
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

			// Mode
			$this->add_control(
				'element_animation_direction',
				[
					'label'   => __( 'Animation Direction', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'normal',
					'options' => [
						'normal'            => __( 'Normal', 'beaddon' ),
						'alternate'         => __( 'Alternate', 'beaddon' ),
						'reverse'           => __( 'Reverse', 'beaddon' ),
						'alternate-reverse' => __( 'Alternate Reverse', 'beaddon' ),
					],
					'condition' => [
						'element_animation' => 'yes',
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__wrap' => '-webkit-animation-direction: {{VALUE}};  animation-direction: {{VALUE}};',
					],
				]
			);

			// Mode
			$this->add_control(
				'element_animation_custom_speed',
				[
					'label' => __( 'Animation Custom Duration', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => 0.5,
							'max'  => 100,
							'step' => 0.5,
						],
					],
					'default' => [
						'size' => 1,
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__wrap' => '-webkit-animation-duration: {{SIZE}}s;  animation-duration: {{SIZE}}s;',
					],
					'condition' => [
						'element_animation' => 'yes',
					]
				]
			);

		$this->end_controls_section();

		/*********************************
		 * 		STYLE SECTION
		 *********************************/

		/*----------------------------
			ELEMENT STYLE
		-----------------------------*/
		$this->start_controls_section(
			'element_style_section',
			[
				'label' => __( 'Position Element', 'beaddon' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			/* $this->add_responsive_control(
				'_element_width',
				[
					'label'   => __( 'Width', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'auto',
					'options' => [
						''        => __( 'Default', 'beaddon' ),
						'inherit' => __( 'Full Width', 'beaddon' ) . ' (100%)',
						'auto'    => __( 'Inline', 'beaddon' ) . ' (auto)',
						'initial' => __( 'Custom', 'beaddon' ),
					],
					'selectors_dictionary' => [
						'inherit' => '100%',
					],
					'prefix_class' => 'elementor-widget%s__width-',
					'selectors'    => [
						'{{WRAPPER}}' => 'width: {{VALUE}}; max-width: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'_element_custom_width',
				[
					'label' => __( 'Custom Width', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'max'  => 100,
							'step' => 1,
						],
					],
					'condition' => [
						'_element_width' => 'initial',
					],
					'device_args' => [
						Controls_Stack::RESPONSIVE_TABLET => [
							'condition' => [
								'_element_width_tablet' => [ 'initial' ],
							],
						],
						Controls_Stack::RESPONSIVE_MOBILE => [
							'condition' => [
								'_element_width_mobile' => [ 'initial' ],
							],
						],
					],
					'size_units' => [ 'px', '%', 'vw' ],
					'selectors'  => [
						'{{WRAPPER}}' => 'width: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}}',
					],
				]
			);

			$this->add_responsive_control(
				'_element_vertical_align',
				[
					'label'   => __( 'Vertical Align', 'beaddon' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => __( 'Start', 'beaddon' ),
							'icon'  => 'eicon-v-align-top',
						],
						'center' => [
							'title' => __( 'Center', 'beaddon' ),
							'icon'  => 'eicon-v-align-middle',
						],
						'flex-end' => [
							'title' => __( 'End', 'beaddon' ),
							'icon'  => 'eicon-v-align-bottom',
						],
					],
					'condition' => [
						'_element_width!' => '',
						'_position'       => '',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'align-self: {{VALUE}}',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'_position_description',
				[
					'raw'             => '<strong>' . __( 'Please note!', 'beaddon' ) . '</strong> ' . __( 'Custom positioning is not considered best practice for responsive web design and should not be used too frequently.', 'beaddon' ),
					'type'            => Controls_Manager::RAW_HTML,
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
					'render_type'     => 'ui',
					'condition'       => [
						'_position!' => '',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'_position',
				[
					'label'   => __( 'Position', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						''         => __( 'Default', 'beaddon' ),
						'absolute' => __( 'Absolute', 'beaddon' ),
						'relative' => __( 'Relative', 'beaddon' ),
						'fixed'    => __( 'Fixed', 'beaddon' ),
					],
					'prefix_class'       => 'elementor-',
					'frontend_available' => true,
					'separator'          => 'before',
				]
			);

			$start = is_rtl() ? __( 'Right', 'beaddon' ) : __( 'Left', 'beaddon' );
			$end   = ! is_rtl() ? __( 'Right', 'beaddon' ) : __( 'Left', 'beaddon' );

			$this->add_control(
				'_offset_orientation_h',
				[
					'label'   => __( 'Horizontal Orientation', 'beaddon' ),
					'type'    => Controls_Manager::CHOOSE,
					'toggle'  => false,
					'default' => 'start',
					'options' => [
						'start' => [
							'title' => $start,
							'icon'  => 'eicon-h-align-left',
						],
						'end' => [
							'title' => $end,
							'icon'  => 'eicon-h-align-right',
						],
					],
					'classes'     => 'elementor-control-start-end',
					'render_type' => 'ui',
					'condition'   => [
						'_position!' => '',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'_offset_x',
				[
					'label' => __( 'Offset', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'default' => [
						'size' => '0',
					],
					'size_units' => [ 'px', '%', 'vw', 'vh' ],
					'selectors'  => [
						'body:not(.rtl) {{WRAPPER}}' => 'left: {{SIZE}}{{UNIT}}',
						'body.rtl {{WRAPPER}}'       => 'right: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_h!' => 'end',
						'_position!'             => '',
					],
				]
			);

			$this->add_responsive_control(
				'_offset_x_end',
				[
					'label' => __( 'Offset', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 0.1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'default' => [
						'size' => '0',
					],
					'size_units' => [ 'px', '%', 'vw', 'vh' ],
					'selectors'  => [
						'body:not(.rtl) {{WRAPPER}}' => 'right: {{SIZE}}{{UNIT}}',
						'body.rtl {{WRAPPER}}'       => 'left: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_h' => 'end',
						'_position!'            => '',
					],
				]
			);

			$this->add_control(
				'_offset_orientation_v',
				[
					'label'   => __( 'Vertical Orientation', 'beaddon' ),
					'type'    => Controls_Manager::CHOOSE,
					'toggle'  => false,
					'default' => 'start',
					'options' => [
						'start' => [
							'title' => __( 'Top', 'beaddon' ),
							'icon'  => 'eicon-v-align-top',
						],
						'end' => [
							'title' => __( 'Bottom', 'beaddon' ),
							'icon'  => 'eicon-v-align-bottom',
						],
					],
					'render_type' => 'ui',
					'condition'   => [
						'_position!' => '',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'_offset_y',
				[
					'label' => __( 'Offset', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'size_units' => [ 'px', '%', 'vh', 'vw' ],
					'default'    => [
						'size' => '0',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'top: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_v!' => 'end',
						'_position!'             => '',
					],
				]
			);

			$this->add_responsive_control(
				'_offset_y_end',
				[
					'label' => __( 'Offset', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min'  => -1000,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => -200,
							'max' => 200,
						],
						'vh' => [
							'min' => -200,
							'max' => 200,
						],
						'vw' => [
							'min' => -200,
							'max' => 200,
						],
					],
					'size_units' => [ 'px', '%', 'vh', 'vw' ],
					'default'    => [
						'size' => '0',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'bottom: {{SIZE}}{{UNIT}}',
					],
					'condition' => [
						'_offset_orientation_v' => 'end',
						'_position!'            => '',
					],
				]
			); */



			$this->add_responsive_control(
				'postion_element_width',
				[
					'label'      => __( 'Element Fixed Width', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px','vw','%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'vw' => [
							'min'  => -100,
							'max'  => 100,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'width: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_element_height',
				[
					'label'      => __( 'Element Fixed Height', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}}' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'warapper_width',
				[
					'label'      => __( 'Content Warapper Width', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vw' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 2000,
							'step' => 1,
						],
						'%' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'vw' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__item' => 'width: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'warapper_height',
				[
					'label'      => __( 'Content Warapper Height', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vw' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 2000,
							'step' => 1,
						],
						'%' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
						'vw' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .posiion__element__item' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'postion_element_image_size_width',
				[
					'label'      => __( 'Image Width', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'postion_element_type' => ['postion_element_image']
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_element_image_size_height',
				[
					'label'      => __( 'Image Height', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'postion_element_type' => ['postion_element_image']
					],
				]
			);

			$this->add_group_control(
				Group_Control_Css_Filter:: get_type(),
				[
					'name'      => 'position_element_image_filters',
					'label'     => __( 'Image Filter', 'beaddon' ),
					'selector'  => '{{WRAPPER}} img',
					'condition' => [
						'postion_element_type' => ['postion_element_image']
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'position_element_color',
				[
					'label'     => __( 'Color', 'beaddon' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .posiion__element__item' => 'color: {{VALUE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_group_control(
				Group_Control_Typography:: get_type(),
				[
					'name'      => 'position_element_typography',
					'selector'  => '{{WRAPPER}} .posiion__element__item',
					'condition' => [
						'postion_element_type' => ['postion_element_font_or_svg_icon','postion_element_text']
					],
				]
			);

			$this->add_group_control(
				Group_Control_Background:: get_type(),
				[
					'name'     => 'position_element_background',
					'label'    => __( 'Background', 'beaddon' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .posiion__element__item',
				]
			);

			$this->add_group_control(
				Group_Control_Border:: get_type(),
				[
					'name'      => 'position_element_border',
					'label'     => __( 'Border', 'beaddon' ),
					'selector'  => '{{WRAPPER}} .posiion__element__item',
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'position_element_radius',
				[
					'label'      => __( 'Border Radius', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .posiion__element__item, {{WRAPPER}} .posiion__element__item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Box_Shadow:: get_type(),
				[
					'name'     => 'position_element_shadow',
					'selector' => '{{WRAPPER}} .posiion__element__item',
				]
			);
			
			$this->add_responsive_control(
				'position_element_display',
				[
					'label'   => __( 'Display', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'inline-block',
					'options' => [
						'initial'      => __( 'Initial', 'beaddon' ),
						'block'        => __( 'Block', 'beaddon' ),
						'inline-block' => __( 'Inline Block', 'beaddon' ),
						'flex'         => __( 'Flex', 'beaddon' ),
						'inline-flex'  => __( 'Inline Flex', 'beaddon' ),
						'none'         => __( 'none', 'beaddon' ),
					],
					'selectors' => [
						'{{WRAPPER}}' => 'display: {{VALUE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'position_element_align',
				[
					'label'   => __( 'Alignment', 'beaddon' ),
					'type'    => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'beaddon' ),
							'icon'  => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'beaddon' ),
							'icon'  => 'fa fa-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'beaddon' ),
							'icon'  => 'fa fa-align-right',
						],
						'justify' => [
							'title' => __( 'Justify', 'beaddon' ),
							'icon'  => 'fa fa-align-justify',
						],
					],
					'selectors' => [
						'{{WRAPPER}}' => 'text-align: {{VALUE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'position_element_zindex',
				[
					'label'     => __( 'Z-Index', 'beaddon' ),
					'type'      => Controls_Manager::NUMBER,
					'min'       => -99,
					'max'       => 99,
					'step'      => 1,
					'selectors' => [
						'{{WRAPPER}}' => 'z-index: {{SIZE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_control(
				'position_element_opacity',
				[
					'label' => __( 'Opacity', 'beaddon' ),
					'type'  => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'max'  => 1,
							'min'  => 0.10,
							'step' => 0.01,
						],
					],
					'selectors' => [
						'{{WRAPPER}}' => 'opacity: {{SIZE}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_elemnent_margin',
				[
					'label'      => __( 'Margin', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .posiion__element__item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'postion_elemnent_padding',
				[
					'label'      => __( 'Padding', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .posiion__element__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		/*----------------------------
			ICON STYLE END
		-----------------------------*/		
	}
	
	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', 'posiion__element__wrap' );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_type'] );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_infinite'] );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_speed'] );
		$this->add_render_attribute( 'posiion__element__wrap_attr', 'class', $settings['element_animation_infinite'] );

		// Icon Condition
		if ( 'postion_element_font_or_svg_icon' == $settings['postion_element_type'] && !empty( $settings['postion_element_font_or_svg_icon'] ) ) {
			$element = '<div class="posiion__element__item">'.be_addons_render_icons( $settings['postion_element_font_or_svg_icon'] ).'</div>';
		}elseif( 'postion_element_image' == $settings['postion_element_type'] && !empty( $settings['postion_element_image'] ) ){
			$element_array = $settings['postion_element_image'];
			$element_link  = wp_get_attachment_image_url( $element_array['id'], 'thumbnail' );
			$image         = Group_Control_Image_Size::get_attachment_image_html( $settings, 'postion_element_image_size', 'postion_element_image');
			$element       = '<div class="posiion__element__item">'.$image.'</div>';
		}elseif ( 'postion_element_text' == $settings['postion_element_type'] && !empty( $settings['title'] ) ) {
			$element = '<div class="posiion__element__item">'.esc_html( $settings['title'] ).'</div>';
		}elseif ( 'postion_element_shape' == $settings['postion_element_type'] ) {
			$element = '<div class="posiion__element__item"></div>';
		}else{
			$element = '';
		}

		echo '<div '.$this->get_render_attribute_string('posiion__element__wrap_attr').'>
				'.( isset( $element ) ? $element : '' ).'
			</div>';

	}

	protected function content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Be_Addons_Positions_Element() );