<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Be_Addons_Image_Compare_Widgets extends Widget_Base {

	public function get_name() {
		return 'Be_Addons_Image_Compare_Widgets';
	}

	public function get_title() {
		return __( 'Be Image Compare', 'beaddon' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_categories() {
		return array('be-addons');
	}

    public function get_keywords() {
        return [ 'image', 'compare', 'image compare' ];
    }

	public function get_script_depends() {
		return[
			'event-move',
			'twentytwenty',
			'be-core',
		];
	}

	public function get_style_depends() {
		return[
			'twentytwenty',
		];
	}

	public static function content_layout_style(){
		return [
			'image__compare__style__1'   => 'Compare Style 1',
			'image__compare__style__2'  => 'Compare Style 2',
			'image__compare__style__custom' => 'Compare Custom Style',
		];
	}

	protected function register_controls() {

		/******************************
		 * 	CONTENT SECTION
		 ******************************/
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'beaddon' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'orientation',
				[
					'label'   => __( 'Orientation', 'beaddon' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'horizontal',
					'options' => [
						'vertical'   => __('vertical', 'beaddon'),
						'horizontal' => __('horizontal', 'beaddon'),
					],
					'separator' => 'before',
				]
			);
			$this->add_control(
				'before_image',
				[
					'label'   => __( 'Before Image', 'beaddon' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name' => 'before_image_size',
					'exclude' => [ 'custom' ],
					'default' => 'full',
				]
			);
			$this->add_control(
				'after_image',
				[
					'label'   => __( 'After Image', 'beaddon' ),
					'type'    => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
					'name' => 'after_image_size',
					'exclude' => [ 'custom' ],
					'default' => 'full',
				]
			);
			$this->add_control(
				'before_label',
				[
					'label'         => __( 'Before Label', 'beaddon' ),
					'type'          => Controls_Manager::TEXT,
					'show_external' => true,
					'default'       => 'Before',
					'placeholder'   => 'January 2017',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'after_label',
				[
					'label'         => __( 'After Label', 'beaddon' ),
					'type'          => Controls_Manager::TEXT,
					'show_external' => true,
					'default'       => 'After',
					'placeholder'   => 'January 2010',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'no_overlay',
				[
					'label'        => __( 'No Overlay', 'beaddon' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'beaddon' ),
					'label_off'    => __( 'Hide', 'beaddon' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'move_slider_on_hover',
				[
					'label'        => __( 'Move Slider On Hover', 'beaddon' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'beaddon' ),
					'label_off'    => __( 'Hide', 'beaddon' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'move_with_handle_only',
				[
					'label'        => __( 'Move With Handle Only', 'beaddon' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'beaddon' ),
					'label_off'    => __( 'Hide', 'beaddon' ),
					'return_value' => 'yes',
					'default'      => 'yes',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'click_to_move',
				[
					'label'        => __( 'Click To Move', 'beaddon' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'beaddon' ),
					'label_off'    => __( 'Hide', 'beaddon' ),
					'return_value' => 'yes',
					'default'      => 'no',
					'separator'    => 'before',
				]
			);
			$this->add_control(
				'default_offset_pct',
				[
					'label'      => __( 'Image Offset', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1,
							'step' => 0.01,
						],
					],
					'default' => [
						'unit' => 'px',
						'size' => 0.5,
					],
					'separator' => 'before',
				]
			);
		$this->end_controls_section();
		/*******************************
		 * 	CONTENT SECTION END
		 *******************************/

		/*----------------------------
			WRAP STYLE
		-----------------------------*/
		$this->start_controls_section(
			'wrap_style_section',
			[
				'label' => __( 'Wrap', 'beaddon' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->start_controls_tabs( 'wrap_tab_style' );
				$this->start_controls_tab(
					'wrap_normal_tab',
					[
						'label' => __( 'Normal', 'beaddon' ),
					]
				);
					$this->add_control(
						'wrap_color',
						[
							'label'  => __( 'Color', 'beaddon' ),
							'type'   => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
					$this->add_group_control(
						Group_Control_Typography:: get_type(),
						[
							'name'     => 'typography',
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper',
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'wrap_background',
							'label' => __( 'Background', 'beaddon' ),
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper',
						]
					);
					$this->add_responsive_control(
						'wrap_align',
						[
							'label'   => __( 'Alignment', 'beaddon' ),
							'type'    => Controls_Manager::CHOOSE,
							'options' => [
								'left' => [
									'title' => __( 'Left', 'beaddon' ),
									'icon'  => 'fa fa-align-left',
								],
								'center' => [
									'title' => __( 'Center', 'beaddon' ),
									'icon'  => 'fa fa-align-center',
								],
								'right' => [
									'title' => __( 'Right', 'beaddon' ),
									'icon'  => 'fa fa-align-right',
								],
								'justify' => [
									'title' => __( 'Justify', 'beaddon' ),
									'icon'  => 'fa fa-align-justify',
								],
							],
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'text-align: {{VALUE}};',
							],
							'separator' => 'before',
						]
					);
					$this->add_group_control(
						Group_Control_Border:: get_type(),
						[
							'name'     => 'wrap_border',
							'label'    => __( 'Border', 'beaddon' ),
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper',
							'separator' => 'before',
						]
					);
					$this->add_control(
						'wrap_radius',
						[
							'label'      => __( 'Border Radius', 'beaddon' ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors'  => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow:: get_type(),
						[
							'name'     => 'wrap_shadow',
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper',
						]
					);
					$this->add_control(
						'wrap_transition',
						[
							'label'      => __( 'Transition', 'beaddon' ),
							'type'       => Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min'  => 0.1,
									'max'  => 3,
									'step' => 0.1,
								],
							],
							'default' => [
								'unit' => 'px',
							],
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'transition: {{SIZE}}s;',
							],
							'separator' => 'before',
						]
					);
					$this->add_responsive_control(
						'wrap_position',
						[
							'label'   => __( 'Position', 'beaddon' ),
							'type'    => Controls_Manager::SELECT,			
							'default' => '',		
							'options' => [
								''  => __( 'Default', 'beaddon' ),
								'absolute' => __( 'Absulute', 'beaddon' ),
								'relative' => __( 'Relative', 'beaddon' ),
							],
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'position: {{VALUE}};',
							],
							'separator' => 'before',
						]
					);
					$this->add_responsive_control(
						'wrap_margin',
						[
							'label'      => __( 'Margin', 'beaddon' ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors'  => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator' => 'before',
						]
					);
					$this->add_responsive_control(
						'wrap_padding',
						[
							'label'      => __( 'Padding', 'beaddon' ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors'  => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_control(
						'wrap_height',
						[
							'label'      => __( 'Height', 'beaddon' ),
							'type'       => Controls_Manager::SLIDER,
							'size_units' => [ 'px', '%' ],
							'range'      => [
								'px' => [
									'min'  => 0,
									'max'  => 1000,
									'step' => 1,
								],
								'%' => [
									'min' => 0,
								],
							],
							'default' => [
								'unit' => 'px',
							],
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'height: {{SIZE}}{{UNIT}};',
							],
							'separator' => 'before',
						]
					);

					$this->add_responsive_control(
						'wrap_overflow',
						[
							'label'   => __( 'Overflow', 'beaddon' ),
							'type'    => Controls_Manager::SELECT,
							'options' => [
								'default'  => __( 'Default', 'beaddon' ),
								'hidden' => __( 'Hidden', 'beaddon' ),
								'visible' => __( 'Visible', 'beaddon' ),
							],
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper' => 'overflow: {{VALUE}};',
							],
							'separator' => 'before',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'wrap_hover_tab',
					[
						'label' => __( 'Hover', 'beaddon' ),
					]
				);
					$this->add_control(
						'hover_wrap_color',
						[
							'label'  => __( 'Color', 'beaddon' ),
							'type'   => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper:hover' => 'color: {{VALUE}}',
							],
							'separator' => 'before',
						]
					);
					$this->add_control(
						'hover_wrap_button_color',
						[
							'label'  => __( 'Button Color', 'beaddon' ),
							'type'   => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper:hover .wrap__button' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'hover_wrap_background',
							'label' => __( 'Background', 'beaddon' ),
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper:hover',
						]
					);
					$this->add_group_control(
						Group_Control_Border:: get_type(),
						[
							'name'     => 'hover_wrap_border',
							'label'    => __( 'Border', 'beaddon' ),
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper:hover',
							'separator' => 'before',
						]
					);
					$this->add_control(
						'hover_wrap_radius',
						[
							'label'      => __( 'Border Radius', 'beaddon' ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors'  => [
								'{{WRAPPER}} .twentytwenty-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow:: get_type(),
						[
							'name'     => 'hover_wrap_shadow',
							'selector' => '{{WRAPPER}} .twentytwenty-wrapper:hover',
						]
					);
					$this->add_control(
						'hover_wrap_transform',
						[
							'label'      => __( 'Transform Vartically', 'beaddon' ),
							'type'       => Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min'  => -100,
									'max'  => 100,
									'step' => 1,
								],
							],
							'default' => [
								'unit' => 'px',
							],
							'selectors' => [
								'{{WRAPPER}} .twentytwenty-wrapper:hover' => 'transform: translateY({{SIZE}}{{UNIT}});',
							],
							'separator' => 'before',
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		/*----------------------------
			WRAP STYLE END
		-----------------------------*/

		/*----------------------------
			BEFORE LABEL TITLE
		-----------------------------*/
		$this->start_controls_section(
			'label_button_style_section',
			[
				'label'     => __( 'Label Button', 'beaddon' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'no_overlay!' => 'yes',
				],
			]
		);
			// Typgraphy
			$this->add_group_control(
				Group_Control_Typography:: get_type(),
				[
					'name'     => 'label_button_typography',
					'selector' => '{{WRAPPER}} .twentytwenty-before-label:before,{{WRAPPER}} .twentytwenty-after-label:before',
				]
			);

			// Icon Color
			$this->add_control(
				'label_button_color',
				[
					'label'     => __( 'Color', 'beaddon' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-before-label:before' => 'color: {{VALUE}};',
						'{{WRAPPER}} .twentytwenty-after-label:before' => 'color: {{VALUE}};',
					],
				]
			);

			// Background
			$this->add_group_control(
				Group_Control_Background:: get_type(),
				[
					'name'     => 'label_button_background',
					'label'    => __( 'Background', 'beaddon' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .twentytwenty-before-label:before,{{WRAPPER}} .twentytwenty-after-label:before',
				]
			);

			// Border
			$this->add_group_control(
				Group_Control_Border:: get_type(),
				[
					'name'      => 'label_button_border',
					'label'     => __( 'Border', 'beaddon' ),
					'selector' => '{{WRAPPER}} .twentytwenty-before-label:before,{{WRAPPER}} .twentytwenty-after-label:before',
					'separator' => 'before',
				]
			);

			// Radius
			$this->add_responsive_control(
				'label_button_radius',
				[
					'label'      => __( 'Border Radius', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-before-label:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .twentytwenty-after-label:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			// Shadow
			$this->add_group_control(
				Group_Control_Box_Shadow:: get_type(),
				[
					'name'     => 'label_button_shadow',
					'selector' => '{{WRAPPER}} .twentytwenty-before-label:before,{{WRAPPER}} .twentytwenty-after-label:before',
				]
			);

			// Width
			$this->add_responsive_control(
				'label_button_width',
				[
					'label'      => __( 'Width', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-before-label:before' => 'width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .twentytwenty-after-label:before' => 'width: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			// Height
			$this->add_responsive_control(
				'label_button_height',
				[
					'label'      => __( 'Height', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-before-label:before' => 'height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .twentytwenty-after-label:before' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			// Margin
			$this->add_responsive_control(
				'label_button_margin',
				[
					'label'      => __( 'Before Button Margin', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-before-label:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			// Margin
			$this->add_responsive_control(
				'after_label_button_margin',
				[
					'label'      => __( 'After Button Margin', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-after-label:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			// Padding
			$this->add_responsive_control(
				'label_button_padding',
				[
					'label'      => __( 'Padding', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-before-label:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .twentytwenty-after-label:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		/*----------------------------
			BEFORE LABEL TITLE END
		-----------------------------*/

		/*----------------------------
			BEFORE LABEL TITLE
		-----------------------------*/
		$this->start_controls_section(
			'overlay_handaler_style_section',
			[
				'label'     => __( 'Overlay & Handaler', 'beaddon' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'no_overlay!' => 'yes',
				],
			]
		);		
			$this->add_control(
				'overlay_handaler_color',
				[
					'label'     => __( 'Bar Color', 'beaddon' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-handle:before' => 'background: {{VALUE}};',
						'{{WRAPPER}} .twentytwenty-handle:after' => 'background: {{VALUE}};',
					],
				]
			);		
			$this->add_control(
				'overlay_handaler_arrow_color',
				[
					'label'     => __( 'Arrow Color', 'beaddon' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-handle .twentytwenty-left-arrow' => 'border-right-color: {{VALUE}};',
						'{{WRAPPER}} .twentytwenty-handle .twentytwenty-right-arrow' => 'border-left-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background:: get_type(),
				[
					'name'     => 'overlay_handaler_background',
					'label'    => __( 'Background', 'beaddon' ),
					'types'    => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .twentytwenty-handle,{{WRAPPER}}',
				]
			);
			$this->add_group_control(
				Group_Control_Border:: get_type(),
				[
					'name'      => 'overlay_handaler_border',
					'label'     => __( 'Border', 'beaddon' ),
					'selector' => '{{WRAPPER}} .twentytwenty-handle',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'overlay_handaler_radius',
				[
					'label'      => __( 'Border Radius', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-handle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow:: get_type(),
				[
					'name'     => 'overlay_handaler_shadow',
					'selector' => '{{WRAPPER}} .twentytwenty-handle',
				]
			);
			$this->add_responsive_control(
				'overlay_handaler_width',
				[
					'label'      => __( 'Width', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-handle' => 'width: {{SIZE}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);

			// Height
			$this->add_responsive_control(
				'overlay_handaler_height',
				[
					'label'      => __( 'Height', 'beaddon' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range'      => [
						'px' => [
							'min'  => 0,
							'max'  => 1000,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
						],
					],
					'default' => [
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .twentytwenty-handle' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			// Margin
			$this->add_responsive_control(
				'overlay_handaler_margin',
				[
					'label'      => __( 'Margin', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-handle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'separator' => 'before',
				]
			);
			// Padding
			$this->add_responsive_control(
				'overlay_handaler_padding',
				[
					'label'      => __( 'Padding', 'beaddon' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .twentytwenty-handle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		/*----------------------------
			BEFORE LABEL TITLE END
		-----------------------------*/

	}
	
	protected function render() {

		$settings  = $this->get_settings_for_display();
		$random_id = $this->get_id();

		$options = array(
			'default_offset_pct'    => $settings['default_offset_pct']['size'] ? $settings['default_offset_pct']['size'] : 0.5,
			'orientation'           => $settings['orientation'] ? $settings['orientation'] : 'horizontal',
			'before_label'          => $settings['before_label'] ? $settings['before_label'] : 'before',
			'after_label'           => $settings['after_label'] ? $settings['after_label'] : 'after',
			'no_overlay'            => ( 'yes' === $settings['no_overlay'] ) ? true : false,
			'move_slider_on_hover'  => ( 'yes' === $settings['move_slider_on_hover'] ) ? true : false,
			'move_with_handle_only' => ( 'yes' === $settings['move_with_handle_only'] ) ? true : false,
			'click_to_move'         => ( 'yes' === $settings['click_to_move'] ) ? true : false,
		);
		$this->add_render_attribute( 'image_compare_wrap_attr', 'data-options', json_encode( $options ) );
		$this->add_render_attribute( 'image_compare_wrap_attr', 'class', 'be__addons__image__compare__wrap' );
		$this->add_render_attribute( 'image_compare_wrap_attr', 'class', 'twentytwenty-container' );
		$this->add_render_attribute( 'image_compare_wrap_attr', 'id', 'be__addons__image__compare__'.$random_id  );

		?>
			<div <?php echo $this->get_render_attribute_string( 'image_compare_wrap_attr' ); ?>>
				<div class="before__image"><?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'before_image_size', 'before_image' ); ?></div>
				<div class="after__image"><?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'after_image_size', 'after_image' ); ?></div>
			</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Be_Addons_Image_Compare_Widgets() );