<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Be_Addons_Counter extends Widget_Base
{

    public function get_name()
    {
        return 'be-circle-counter';
    }

    public function get_title()
    {
        return __('Be Round Conter', 'beaddon');
    }

    public function get_icon()
    {
        return 'eicon-counter';
    }

    public function get_categories()
    {
        return array('be-addons');
    }

    public function get_script_depends()
    {
        return [
            'owl-carousel',
            'be-core',
            'circle-progress',
            'viewport',
            'counter-main'
        ];
    }
    public function get_style_depends()
    {
        return [
            'bootstrap',
            'owl-carousel',
            'be-round-counter-style'
        ];
    }

    public function get_keywords()
    {
        return [
            'counter',
            'counter slider',
            'counter',
            'Be counter',
        ];
    }
    public function number_styles($prefix, $selector){
        $this->start_controls_section(
            $prefix . '_text_style_section',
            [
                'label' => __($prefix, 'beaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_' . $prefix,
                'selector' => '{{WRAPPER}} ' . $selector,
            ]
        );

        $this->add_control(
            $prefix . '_text_color',
            [
                'label'     => __($prefix . ' Color', 'beaddon'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $selector => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

    }
    public function text_styles($prefix, $selector){

        $this->start_controls_section(
            $prefix.'_text_style_section',
            [
                'label'     => __($prefix, 'beaddon'),
                'tab'       => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_'.$prefix,
                'selector' => '{{WRAPPER}} '.$selector,
            ]
        );

        $this->add_control(
            $prefix.'_text_color',
            [
                'label'     => __(  $prefix.' Color', 'beaddon'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} '.$selector => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            $prefix.'_align',
            [
                'label'     => __('Alignment', 'beaddon'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'    => [
                        'title' => __('Left', 'beaddon'),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center'  => [
                        'title' => __('Center', 'beaddon'),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'   => [
                        'title' => __('Right', 'beaddon'),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justify', 'beaddon'),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} '.$selector => 'text-align: {{VALUE}};',
                ],
                'default'   => '',
            ]
        );


        $this->end_controls_section();


    }
    protected function register_controls()
    {
        /*---------------------------
        CONTENT SECTION
        ----------------------------*/
        $this->start_controls_section(
            'section_counter',
            [
                'label' => __('Counter', 'beaddon'),
            ]
        );

        // $this->add_control(
        //     'starting_number',
        //     [
        //         'label'     => __('Starting Number', 'beaddon'),
        //         'type'      => Controls_Manager::NUMBER,
        //         'default'   => 0,
        //         'separator' => 'before',
        //     ]
        // );
        $this->add_control(
            'ending_number',
            [
                'label'   => __('Ending Number', 'beaddon'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 100,
            ]
        );

        $this->add_control(
            'title_text',
            [
                'label'       => __(' Title', 'beaddon'),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'placeholder' =>  __('Title', 'beaddon'),
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'description_text',
            [
                'label'       => __('Description', 'beaddon'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'placeholder' =>  __('Description', 'beaddon'),
                'separator'   => 'before',
            ]
        );
        
        $this->add_control(
            'circle_color',
            [
                'label'     => __( 'Fill Circle Color', 'beaddon'),
                'type'      => Controls_Manager::COLOR
            ]
        );


        $this->end_controls_section();


        $this->number_styles('ending_number', '.progressbar .circle');
        $this->text_styles('title', '.sk-title');
        $this->text_styles('description', '.skill-item-content p');
    }

    protected function render()
    {   
        $settings       = $this->get_settings_for_display();
        // $starting_number   = $settings['starting_number'];
        $ending_number   = $settings['ending_number'];
        $title_text      = $settings['title_text'];
        $description_text      = $settings['description_text'];
        $circle_color      = $settings['circle_color'];
        ?>
        <div class="instructor-details-section">
            <div class="container">
                <div class="instructor-skills-items">
                    <div class="skill-items-wrap">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="skill-item">
                                    <div class="progressbar" data-animate="false">
                                        <div class="circle" data-percent="<?php echo $ending_number; ?>" data-color="<?php echo $circle_color; ?>">
                                            <div></div>
                                        </div>
                                    </div>
                                    <div class="skill-item-content">
                                        <h6 class="sk-title"><?php sanitize_text_field( _e($title_text , 'beaddon') ); ?></h6>
                                        <p  class="sk-descriotion"><?php sanitize_text_field(_e($description_text, 'beaddon')); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Be_Addons_Counter());
