<?php
namespace Elementor;

use Elementor\Controls_Manager;
use Elementor\Element_Base;

defined( 'ABSPATH' ) || die();

class Be_Addons_Effects {

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self:: $instance;
    }

    public function init() {
        add_action( 'elementor/element/common/_section_style/after_section_end', [ __CLASS__, 'add_controls_section' ], 1 );
        add_action( 'elementor/frontend/after_enqueue_scripts', array ( $this, 'floating_effect_script' ), 10 );

        // front render
        add_action( 'elementor/frontend/widget/before_render', [ $this, 'before_element_render' ] );
    }

    public function floating_effect_script(){
        wp_enqueue_script( 'anime' );
        wp_enqueue_script( 'tilt' );
        wp_enqueue_script( 'vanilla-tilt' );
        wp_enqueue_script( 'base_effect_2' );
        wp_enqueue_script( 'be-core' );
    }

    public function before_element_render( Element_Base $element ){

        if ( ! $element->get_settings( 'be_addons_tilt_effect' ) ) {
            return;
        }

        $random_id = rand(4551,5245);

        $settings_obj = [

            'random_id'                => $random_id,
            'enable_tilt_effect'       => $element->get_settings( 'be_addons_tilt_effect' ),
            'tilt_reverse'             => $element->get_settings( 'tilt_reverse' ),
            'tilt_maxTilt'             => $element->get_settings( 'tilt_maxTilt' )['size'],
            'tilt_startX'              => $element->get_settings( 'tilt_startX' )['size'],
            'tilt_startY'              => $element->get_settings( 'tilt_startY' )['size'],
            'tilt_perspective'         => $element->get_settings( 'tilt_perspective' )['size'],
            'tilt_scale'               => $element->get_settings( 'tilt_scale' )['size'],
            'tilt_speed'               => $element->get_settings( 'tilt_speed' )['size'],
            'tilt_transition'          => $element->get_settings( 'tilt_transition' ),
            'tilt_disableAxis'         => $element->get_settings( 'tilt_disableAxis' ),
            'tilt_reset'               => $element->get_settings( 'tilt_reset' ),
            'tilt_glare'               => $element->get_settings( 'tilt_glare' ),
            'tilt_maxGlare'            => $element->get_settings( 'tilt_maxGlare' )['size'],
            'tilt_mouse_event_element' => $element->get_settings( 'tilt_mouse_event_element' ),
            'tilt_fullpage_listening'  => $element->get_settings( 'tilt_fullpage_listening' ),
            'tilt_gyroscope'           => $element->get_settings( 'tilt_gyroscope' ),
            'tilt_gyroscopeMinAngleX'  => $element->get_settings( 'tilt_gyroscopeMinAngleX' )['size'],
            'tilt_gyroscopeMaxAngleX'  => $element->get_settings( 'tilt_gyroscopeMaxAngleX' )['size'],
            'tilt_gyroscopeMinAngleY'  => $element->get_settings( 'tilt_gyroscopeMinAngleY' )['size'],
            'tilt_gyroscopeMaxAngleY'  => $element->get_settings( 'tilt_gyroscopeMaxAngleY' )['size'],
            'tilt_gyroscopeSamples'    => $element->get_settings( 'tilt_gyroscopeSamples' )['size'],
        ];
    

        $element->add_render_attribute( '_wrapper','data-tiltid', 'tilt__active__id__'.$random_id );
        
        $element->add_render_attribute( '_wrapper',[
            'data-tilt_opt' => json_encode( $settings_obj ),
        ]);
        
    }

    public static function add_controls_section( Element_Base $element ) {
        $element->start_controls_section(
            '_section_be_addons_effects',
            [
                'label' => __( 'Be  Effects', 'beaddon' ),
                'tab'   => Controls_Manager::TAB_ADVANCED,
            ]
        );

            self:: add_floating_effects( $element );
            self:: add_css_effects( $element );
            self:: add_tilt_effects( $element );

        $element->end_controls_section();
    }

    public static function add_floating_effects( Element_Base $element ) {
        $element->add_control(
			'be_floting_effect_heading',
			[
				'label' => __( 'Floating Effects', 'beaddon' ),
				'type' => Controls_Manager::HEADING,
			]
		);
        $element->add_control(
            'be_addons_floating_fx',
            [
                'label'              => __( 'Enable Floating Effects', 'beaddon' ),
                'type'               => Controls_Manager::SWITCHER,
                'return_value'       => 'yes',
                'frontend_available' => true,
				'separator' => 'before',
            ]
        );

        $element->add_control(
            'be_addons_floating_fx_translate_toggle',
            [
                'label'              => __( 'Translate', 'beaddon' ),
                'type'               => Controls_Manager::POPOVER_TOGGLE,
                'return_value'       => 'yes',
                'frontend_available' => true,
                'condition'          => [
                    'be_addons_floating_fx' => 'yes',
                ],
                'separator' => 'before',
            ]
        );
        $element->start_popover();
            $element->add_control(
                'be_addons_floating_fx_translate_x',
                [
                    'label'   => __( 'Translate X', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'sizes' => [
                            'from' => 0,
                            'to'   => 5,
                        ],
                        'unit' => 'px',
                    ],
                    'range' => [
                        'px' => [
                            'min' => -100,
                            'max' => 100,
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_translate_toggle' => 'yes',
                        'be_addons_floating_fx'                  => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_translate_y',
                [
                    'label'   => __( 'Translate Y', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'sizes' => [
                            'from' => 0,
                            'to'   => 5,
                        ],
                        'unit' => 'px',
                    ],
                    'range' => [
                        'px' => [
                            'min' => -100,
                            'max' => 100,
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_translate_toggle' => 'yes',
                        'be_addons_floating_fx'                  => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_translate_duration',
                [
                    'label'      => __( 'Duration', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 10000,
                            'step' => 100
                        ]
                    ],
                    'default' => [
                        'size' => 1000,
                    ],
                    'condition' => [
                        'be_addons_floating_fx_translate_toggle' => 'yes',
                        'be_addons_floating_fx'                  => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_translate_delay',
                [
                    'label'      => __( 'Delay', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5000,
                            'step' => 100
                        ]
                    ],
                    'condition' => [
                        'be_addons_floating_fx_translate_toggle' => 'yes',
                        'be_addons_floating_fx'                  => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );
        $element->end_popover();

        $element->add_control(
            'be_addons_floating_fx_rotate_toggle',
            [
                'label'              => __( 'Rotate', 'beaddon' ),
                'type'               => Controls_Manager::POPOVER_TOGGLE,
                'return_value'       => 'yes',
                'frontend_available' => true,
                'condition'          => [
                    'be_addons_floating_fx' => 'yes',
                ]
            ]
        );
        $element->start_popover();
            $element->add_control(
                'be_addons_floating_fx_rotate_x',
                [
                    'label'   => __( 'Rotate X', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'sizes' => [
                            'from' => 0,
                            'to'   => 45,
                        ],
                    ],
                    'range' => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                            'step' => 1,
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_rotate_toggle' => 'yes',
                        'be_addons_floating_fx'               => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_rotate_y',
                [
                    'label'   => __( 'Rotate Y', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'sizes' => [
                            'from' => 0,
                            'to'   => 45,
                        ],
                    ],
                    'range' => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                            'step' => 1,
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_rotate_toggle' => 'yes',
                        'be_addons_floating_fx'               => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_rotate_z',
                [
                    'label'   => __( 'Rotate Z', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
                    'default' => [
                        'sizes' => [
                            'from' => 0,
                            'to'   => 45,
                        ],
                    ],
                    'range' => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                            'step' => 1,
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_rotate_toggle' => 'yes',
                        'be_addons_floating_fx'               => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_rotate_duration',
                [
                    'label'      => __( 'Duration', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 10000,
                            'step' => 100
                        ]
                    ],
                    'default' => [
                        'size' => 1000,
                    ],
                    'condition' => [
                        'be_addons_floating_fx_rotate_toggle' => 'yes',
                        'be_addons_floating_fx'               => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_rotate_delay',
                [
                    'label'      => __( 'Delay', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5000,
                            'step' => 100
                        ]
                    ],
                    'condition' => [
                        'be_addons_floating_fx_rotate_toggle' => 'yes',
                        'be_addons_floating_fx'               => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );
        $element->end_popover();

        $element->add_control(
            'be_addons_floating_fx_scale_toggle',
            [
                'label'              => __( 'Scale', 'beaddon' ),
                'type'               => Controls_Manager::POPOVER_TOGGLE,
                'return_value'       => 'yes',
                'frontend_available' => true,
                'condition'          => [
                    'be_addons_floating_fx' => 'yes',
                ]
            ]
        );
        $element->start_popover();
            $element->add_control(
                'be_addons_floating_fx_scale_x',
                [
                    'label'   => __( 'Scale X', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'sizes' => [
                            'from' => 1,
                            'to'   => 1.2,
                        ],
                        'unit' => 'px',
                    ],
                    'range' => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5,
                            'step' => .1
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_scale_toggle' => 'yes',
                        'be_addons_floating_fx'              => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_scale_y',
                [
                    'label'   => __( 'Scale Y', 'beaddon' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'sizes' => [
                            'from' => 1,
                            'to'   => 1.2,
                        ],
                        'unit' => 'px',
                    ],
                    'range' => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5,
                            'step' => .1
                        ]
                    ],
                    'labels' => [
                        __( 'From', 'beaddon' ),
                        __( 'To', 'beaddon' ),
                    ],
                    'scales'    => 1,
                    'handles'   => 'range',
                    'condition' => [
                        'be_addons_floating_fx_scale_toggle' => 'yes',
                        'be_addons_floating_fx'              => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_scale_duration',
                [
                    'label'      => __( 'Duration', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 10000,
                            'step' => 100
                        ]
                    ],
                    'default' => [
                        'size' => 1000,
                    ],
                    'condition' => [
                        'be_addons_floating_fx_scale_toggle' => 'yes',
                        'be_addons_floating_fx'              => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );

            $element->add_control(
                'be_addons_floating_fx_scale_delay',
                [
                    'label'      => __( 'Delay', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5000,
                            'step' => 100
                        ]
                    ],
                    'condition' => [
                        'be_addons_floating_fx_scale_toggle' => 'yes',
                        'be_addons_floating_fx'              => 'yes',
                    ],
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );
        $element->end_popover();

        $element->add_control(
            'be_addons_hr',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );
    }

    public static function add_css_effects( Element_Base $element ) {

        $element->add_control(
			'be_floting_css_effect_heading',
			[
				'label' => __( 'CSS Transform', 'beaddon' ),
				'type' => Controls_Manager::HEADING,
			]
		);

        $element->add_control(
            'be_addons_transform_fx',
            [
                'label'        => __( 'Enable CSS Transform', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
				'separator' => 'before',
            ]
        );

        $element->add_control(
            'be_addons_transform_fx_translate_toggle',
            [
                'label'        => __( 'Translate', 'beaddon' ),
                'type'         => Controls_Manager::POPOVER_TOGGLE,
                'return_value' => 'yes',
                'condition'    => [
                    'be_addons_transform_fx' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->start_popover();
            $element->add_responsive_control(
                'be_addons_transform_fx_translate_x',
                [
                    'label'      => __( 'Translate X', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_translate_toggle' => 'yes',
                        'be_addons_transform_fx'                  => 'yes',
                    ],
                ]
            );

            $element->add_responsive_control(
                'be_addons_transform_fx_translate_y',
                [
                    'label'      => __( 'Translate Y', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_translate_toggle' => 'yes',
                        'be_addons_transform_fx'                  => 'yes',
                    ],
                    'selectors' => [
                        '(desktop){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px);',
                        '(tablet){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px);',
                        '(mobile){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px);',
                    ]
                ]
            );
        $element->end_popover();

        $element->add_control(
            'be_addons_transform_fx_rotate_toggle',
            [
                'label'     => __( 'Rotate', 'beaddon' ),
                'type'      => Controls_Manager::POPOVER_TOGGLE,
                'condition' => [
                    'be_addons_transform_fx' => 'yes',
                ],
            ]
        );
        $element->start_popover();
            $element->add_responsive_control(
                'be_addons_transform_fx_rotate_x',
                [
                    'label'      => __( 'Rotate X', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_rotate_toggle' => 'yes',
                        'be_addons_transform_fx'               => 'yes',
                    ],
                ]
            );

            $element->add_responsive_control(
                'be_addons_transform_fx_rotate_y',
                [
                    'label'      => __( 'Rotate Y', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_rotate_toggle' => 'yes',
                        'be_addons_transform_fx'               => 'yes',
                    ],
                ]
            );

            $element->add_responsive_control(
                'be_addons_transform_fx_rotate_z',
                [
                    'label'      => __( 'Rotate Z', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_rotate_toggle' => 'yes',
                        'be_addons_transform_fx'               => 'yes',
                    ],
                    'selectors' => [
                        '(desktop){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg);',
                        '(tablet){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg);',
                        '(mobile){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg);'
                    ]
                ]
            );
        $element->end_popover();

        $element->add_control(
            'be_addons_transform_fx_scale_toggle',
            [
                'label'        => __( 'Scale', 'beaddon' ),
                'type'         => Controls_Manager::POPOVER_TOGGLE,
                'return_value' => 'yes',
                'condition'    => [
                    'be_addons_transform_fx' => 'yes',
                ],
            ]
        );
        $element->start_popover();
            $element->add_responsive_control(
                'be_addons_transform_fx_scale_x',
                [
                    'label'      => __( 'Scale X', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default'    => [
                        'size' => 1
                    ],
                    'range' => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5,
                            'step' => .1
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_scale_toggle' => 'yes',
                        'be_addons_transform_fx'              => 'yes',
                    ],
                ]
            );

            $element->add_responsive_control(
                'be_addons_transform_fx_scale_y',
                [
                    'label'      => __( 'Scale Y', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'default'    => [
                        'size' => 1
                    ],
                    'range' => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 5,
                            'step' => .1
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_scale_toggle' => 'yes',
                        'be_addons_transform_fx'              => 'yes',
                    ],
                    'selectors' => [
                        '(desktop){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y.SIZE || 1}});'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y.SIZE || 1}});'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y.SIZE || 1}});',
                        '(tablet){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_tablet.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_tablet.SIZE || 1}});'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_tablet.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_tablet.SIZE || 1}});'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_tablet.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_tablet.SIZE || 1}});',
                        '(mobile){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_mobile.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_mobile.SIZE || 1}});'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_mobile.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_mobile.SIZE || 1}});'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_mobile.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_mobile.SIZE || 1}});'
                    ]
                ]
            );
        $element->end_popover();

        $element->add_control(
            'be_addons_transform_fx_skew_toggle',
            [
                'label'        => __( 'Skew', 'beaddon' ),
                'type'         => Controls_Manager::POPOVER_TOGGLE,
                'return_value' => 'yes',
                'condition'    => [
                    'be_addons_transform_fx' => 'yes',
                ],
            ]
        );
        $element->start_popover();
            $element->add_responsive_control(
                'be_addons_transform_fx_skew_x',
                [
                    'label'      => __( 'Skew X', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['deg'],
                    'range'      => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_skew_toggle' => 'yes',
                        'be_addons_transform_fx'             => 'yes',
                    ],
                ]
            );

            $element->add_responsive_control(
                'be_addons_transform_fx_skew_y',
                [
                    'label'      => __( 'Skew Y', 'beaddon' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => ['deg'],
                    'range'      => [
                        'px' => [
                            'min' => -180,
                            'max' => 180,
                        ]
                    ],
                    'condition' => [
                        'be_addons_transform_fx_skew_toggle' => 'yes',
                        'be_addons_transform_fx'             => 'yes',
                    ],
                    'selectors' => [
                        '(desktop){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y.SIZE || 0}}deg);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y.SIZE || 0}}deg);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x.SIZE || 0}}px, {{be_addons_transform_fx_translate_y.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y.SIZE || 0}}deg);',
                        '(tablet){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_tablet.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_tablet.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x_tablet.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y_tablet.SIZE || 0}}deg);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_tablet.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_tablet.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x_tablet.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y_tablet.SIZE || 0}}deg);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_tablet.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_tablet.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_tablet.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_tablet.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_tablet.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_tablet.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_tablet.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x_tablet.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y_tablet.SIZE || 0}}deg);',
                        '(mobile){{WRAPPER}}' => 
                            '-ms-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_mobile.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_mobile.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x_mobile.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y_mobile.SIZE || 0}}deg);'
                            . '-webkit-transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_mobile.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_mobile.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x_mobile.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y_mobile.SIZE || 0}}deg);'
                            . 'transform:'
                                . 'translate({{be_addons_transform_fx_translate_x_mobile.SIZE || 0}}px, {{be_addons_transform_fx_translate_y_mobile.SIZE || 0}}px) '
                                . 'rotateX({{be_addons_transform_fx_rotate_x_mobile.SIZE || 0}}deg) rotateY({{be_addons_transform_fx_rotate_y_mobile.SIZE || 0}}deg) rotateZ({{be_addons_transform_fx_rotate_z_mobile.SIZE || 0}}deg) '
                                . 'scaleX({{be_addons_transform_fx_scale_x_mobile.SIZE || 1}}) scaleY({{be_addons_transform_fx_scale_y_mobile.SIZE || 1}}) '
                                . 'skew({{be_addons_transform_fx_skew_x_mobile.SIZE || 0}}deg, {{be_addons_transform_fx_skew_y_mobile.SIZE || 0}}deg);'
                    ]
                ]
            );
        $element->end_popover();
        $element->add_control(
            'be_addons_transform_hr',
            [
                'type' => Controls_Manager::DIVIDER,
            ]
        );
    }

    public static function add_tilt_effects( Element_Base $element ) {

        $element->add_control(
			'be_floting_tilt_effect_heading',
			[
				'label' => __( 'Tilt Effects', 'beaddon' ),
				'type' => Controls_Manager::HEADING,
			]
		);

        $element->add_control(
            'be_addons_tilt_effect',
            [
                'label'        => __( 'Enable Tilt Effect', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
				'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_reverse',
            [
                'label'        => __( 'Reverse Tilt', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_maxTilt',
            [
                'label'      => __( 'Max Tilt', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_startX',
            [
                'label'      => __( 'Tilt Start Axis X', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_startY',
            [
                'label'      => __( 'Tilt Start Axis Y', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_perspective',
            [
                'label'      => __( 'Perspective', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -3000,
                        'max' => 3000,
                        'step' => 100,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1000,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );
        $element->add_control(
            'tilt_scale',
            [
                'label'      => __( 'Scale', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 5,
                        'step' => .1,
                    ]
                ],
                'default' => [
                    'size' => 1,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_speed',
            [
                'label'      => __( 'Speed', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 300,
                        'max' => 5000,
                        'step' => 100,
                    ]
                ],
                'default' => [
                    'size' => 1000,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_transition',
            [
                'label'        => __( 'Transition', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'    => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
			'tilt_disableAxis',
			[
				'label' => __( 'Disable Axis', 'beaddon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
                    'x'    => __( 'Axis X', 'beaddon' ),
					'y'    => __( 'Axis Y', 'beaddon' ),
					'null' => __( 'None', 'beaddon' ),
				],
                'default' => 'null',
                'condition'    => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
			]
		);

        $element->add_control(
            'tilt_reset',
            [
                'label'        => __( 'Tilt Reset', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'    => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_glare',
            [
                'label'        => __( 'Glare', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'condition'    => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_maxGlare',
            [
                'label'      => __( 'Max Glare', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.1,
                    ]
                ],
                'default' => [
                    'size' => 0.5,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
			'tilt_mouse_event_element',
			[
				'label'       => __( 'Custom Section Class For Moveing', 'beaddon' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( '.elementor-element', 'beaddon' ),
				'desc'        => __( 'Put your section Class or ID for enable effect in whole area. example: .elementor-element', 'beaddon' ),
				'label_block' => true,
				'condition'   => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
			]
		);

        $element->add_control(
            'tilt_fullpage_listening',
            [
                'label'        => __( 'Full Page Listening', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'condition'    => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_gyroscope',
            [
                'label'        => __( 'Gyroscope', 'beaddon' ),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'    => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_gyroscopeMinAngleX',
            [
                'label'      => __( 'Gyroscope Min Angle X', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'size' => -45,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_gyroscopeMaxAngleX',
            [
                'label'      => __( 'Gyroscope Max Angle X', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'size' => 45,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_gyroscopeMinAngleY',
            [
                'label'      => __( 'Gyroscope Min Angle Y', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'size' => -45,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_gyroscopeMaxAngleY',
            [
                'label'      => __( 'Gyroscope Max Angle Y', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'size' => 45,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        $element->add_control(
            'tilt_gyroscopeSamples',
            [
                'label'      => __( 'How many gyroscope moves?', 'beaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ]
                ],
                'default' => [
                    'size' => 10,
                ],
                'condition' => [
                    'be_addons_tilt_effect' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

    }

}

Be_Addons_Effects:: instance()->init();