<?php
namespace Elementor;

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}


class Be_Addons_Adv_Accordion extends Widget_Base
{
    public function get_name()
    {
        return 'Be_Addons_Adv_Accordion';
    }

    public function get_title()
    {
        return esc_html__('Be Accordion', 'beaddon');
    }

    public function get_icon()
    {
        return 'eicon-accordion';
    }

    public function get_categories()
    {
        return ['be-addons'];
    }

    public function get_script_depends() {
        return[
            'be-core',
        ];
    }

    public function get_keywords() {
        return[
            'accordion',
            'toggle'
        ];
    }
    
    /*
     * Elementor Templates List
     * return array
     */
    public function be_addons_elementor_template() {
        $templates = Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
        $types     = array();
        if ( empty( $templates ) ) {
            $template_lists = [ '0' => __( 'Do not Saved Templates.', 'beaddon' ) ];
        } else {
            $template_lists = [ '0' => __( 'Select Template', 'beaddon' ) ];
            foreach ( $templates as $template ) {
                $template_lists[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
        return $template_lists;
    }

    protected function register_controls()
    {
        /*--------------------------------
            Advance Accordion Settings
        ---------------------------------*/
        $this->start_controls_section(
            'be_addons_accordion_settings_section',
            [
                'label' => esc_html__('Accordicon Settings', 'beaddon'),
            ]
        );
            $this->add_control(
                'be_addons_accordion_type',
                [
                    'label'       => esc_html__('Accordion Type', 'beaddon'),
                    'type'        => Controls_Manager::SELECT,
                    'default'     => 'accordion',
                    'label_block' => false,
                    'options'     => [
                        'accordion' => esc_html__('Accordion', 'beaddon'),
                        'toggle'    => esc_html__('Toggle', 'beaddon'),
                    ],
                ]
            );
            $this->add_control(
                'be_addons_accordion_show_icon',
                [
                    'label'        => esc_html__('Enable Toggle Icon', 'beaddon'),
                    'type'         => Controls_Manager::SWITCHER,
                    'default'      => 'yes',
                    'return_value' => 'yes',
                    'separator'    => 'before',
                ]
            );
            
            $this->add_control(
                'be_addons_adv_accordion_toggle_icon',
                [
                    'label'       => esc_html__('Toggle Icon', 'beaddon'),
                    'type' => Controls_Manager::ICONS,
                    'label_block' => true,
                    'default' => [
                        'value' => 'fa fa-angle-right',
                        'library' => 'solid',
                    ],
                    'condition' => [
                        'be_addons_accordion_show_icon' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'be_addons_accordion_toggle_speed',
                [
                    'label'       => esc_html__('Toggle Speed (ms)', 'beaddon'),
                    'type'        => Controls_Manager::NUMBER,
                    'label_block' => false,
                    'default'     => 300,
                    'separator'    => 'before',
                ]
            );
        $this->end_controls_section();

        /*--------------------------------------
            Advance Accordion Content Settings
        ----------------------------------------*/
        $this->start_controls_section(
            'be_addons_accordion_content_section',
            [
                'label' => esc_html__('Accordion Content', 'beaddon'),
            ]
        );

            $repeater = new Repeater();

            $repeater->add_control(
                'be_addons_adv_accordion_tab_default_active',
                [
                    'label'        => esc_html__('Active as Default', 'beaddon'),
                    'type'         => Controls_Manager::SWITCHER,
                    'default'      => 'no',
                    'return_value' => 'yes',
                ]
            );

            $repeater->add_control(
                'be_addons_accordion_show_tab_icon',
                [
                    'label'        => esc_html__('Enable Tab Icon', 'beaddon'),
                    'type'         => Controls_Manager::SWITCHER,
                    'default'      => 'yes',
                    'return_value' => 'yes',
                    'separator'    => 'before',
                ]
            );
            $repeater->add_control(
                'be_addons_accordion_tab_title_icon',
                [
                    'label'       => esc_html__('Icon', 'beaddon'),
                    'type'        => Controls_Manager::ICONS,
                    'label_block' => true,
                    'default' => [
                        'value' => 'fa fa-plus',
                        'library' => 'solid',
                    ],
                    'condition'   => [
                        'be_addons_accordion_show_tab_icon' => 'yes',
                    ],
                ]
            );
            $repeater->add_control(
                'be_addons_adv_accordion_tab_title',
                [
                    'label'   => esc_html__('Tab Title', 'beaddon'),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Tab Title', 'beaddon'),
                    'dynamic' => ['active' => true],
                    'separator'    => 'before',
                ]
            );
            $repeater->add_control(
                'be_addons_accordion_text_type',
                [
                    'label'   => __('Content Type', 'beaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'content'  => __('Content', 'beaddon'),
                        'template' => __('Saved Templates', 'beaddon'),
                    ],
                    'default' => 'content',
                    'separator'    => 'before',
                ]
            );
            $repeater->add_control(
                'be_addons_primary_templates',
                [
                    'label'     => __('Choose Template', 'beaddon'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => $this->be_addons_elementor_template(),
                    'condition' => [
                        'be_addons_accordion_text_type' => 'template',
                    ],
                ]
            );
            $repeater->add_control(
                'be_addons_adv_accordion_tab_content',
                [
                    'label'     => esc_html__('Tab Content', 'beaddon'),
                    'type'      => Controls_Manager::WYSIWYG,
                    'default'   => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit. Optio, neque qui velit. Magni dolorum quidem ipsam eligendi, totam, facilis laudantium cum accusamus ullam voluptatibus commodi numquam, error, est. Ea, consequatur.', 'beaddon'),
                    'dynamic'   => ['active' => true],
                    'condition' => [
                        'be_addons_accordion_text_type' => 'content',
                    ],
                ]
            );

            $this->add_control(
                'be_addons_adv_accordion_tab',
                [
                    'type'      => Controls_Manager::REPEATER,
                    'seperator' => 'before',
                    'default'   => [
                        ['be_addons_adv_accordion_tab_title' => esc_html__('Accordion Tab Title 1', 'beaddon')],
                        ['be_addons_adv_accordion_tab_title' => esc_html__('Accordion Tab Title 2', 'beaddon')],
                        ['be_addons_adv_accordion_tab_title' => esc_html__('Accordion Tab Title 3', 'beaddon')],
                    ],
                    'fields'      => $repeater->get_controls(),
                    'title_field' => '{{be_addons_adv_accordion_tab_title}}',
                ]
            );
        $this->end_controls_section();

        /**
         * -------------------------------------------
         * Tab Style Advance Accordion Generel Style
         * -------------------------------------------
         */
        $this->start_controls_section(
            'be_addons_adv_accordion_style_section',
            [
                'label' => esc_html__('Accordion Area Style', 'beaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'be_addons_adv_accordion_margin',
                [
                    'label'      => esc_html__('Margin', 'beaddon'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__adv__accordion' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator'    => 'before',
                ]
            );        
            
            $this->add_responsive_control(
                'be_addons_adv_accordion_padding',
                [
                    'label'      => esc_html__('Padding', 'beaddon'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__adv__accordion' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'be_addons_adv_accordion_border',
                    'label'    => esc_html__('Border', 'beaddon'),
                    'selector' => '{{WRAPPER}} .be__addons__adv__accordion',
                    'separator'    => 'before',
                ]
            );
            $this->add_responsive_control(
                'be_addons_adv_accordion_border_radius',
                [
                    'label'      => esc_html__('Border Radius', 'beaddon'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__adv__accordion' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow:: get_type(),
                [
                    'name'     => 'be_addons_adv_accordion_box_shadow',
                    'selector' => '{{WRAPPER}} .be__addons__adv__accordion',
                ]
            );
        $this->end_controls_section();


        /**
         * -------------------------------------------
         * TAB ACCORDION ITEM STYLE
         * -------------------------------------------
         */
        $this->start_controls_section(
            'be_addons_adv_accordion_item_style_section',
            [
                'label' => esc_html__('Single Item Style', 'beaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs('be_addons_adv_accordion_item_tabs');
                # Normal State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_item_normal',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_item_background',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__accordion__list',
                            'separator'=> 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_item_border',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__accordion__list',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_item_border_radius',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__accordion__list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'be_addons_adv_item_box_shadow',
                            'selector' => '{{WRAPPER}} .be__addons__accordion__list',
                        ]
                    );

                    $this->add_responsive_control(
                        'be_addons_adv_item_margin',
                        [
                            'label'      => esc_html__('Margin', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__accordion__list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'be_addons_adv_item_padding',
                        [
                            'label'      => esc_html__('Padding', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__accordion__list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();

                #Active State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_item_active',
                    [
                        'label' => esc_html__('Active', 'beaddon'),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_item_active_background',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__accordion__list.active-default',
                            'separator'=> 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_item_active_border',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__accordion__list.active-default',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_item_active_border_radius',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__accordion__list.active-default' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'be_addons_adv_item_active_box_shadow',
                            'selector' => '{{WRAPPER}} .be__addons__accordion__list.active-default',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();


        /**
         * -------------------------------------------
         * Tab Style Advance Accordion Content Style
         * -------------------------------------------
         */
        $this->start_controls_section(
            'be_addons_adv_accordions_tab_style_section',
            [
                'label' => esc_html__('Header Style', 'beaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'iocn_hidding',
                [
                    'label'     => __( 'Icon', 'beaddon' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'after',
                ]
            );

            $this->add_responsive_control(
                'be_addons_adv_accordion_tab_icon_size',
                [
                    'label'   => __('Icon Size', 'beaddon'),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 16,
                        'unit' => 'px',
                    ],
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 100,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .be__addons__accordion__icon' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .be__addons__accordion__title__icon svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'be_addons_adv_accordion_tab_icon_gap',
                [
                    'label'   => __('Icon Gap', 'beaddon'),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 10,
                        'unit' => 'px',
                    ],
                    'size_units' => ['px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0,
                            'max'  => 100,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .be__addons__accordion__icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'title_hidding',
                [
                    'label'     => __( 'Title Wrap', 'beaddon' ),
                    'type'      => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'title_hr',
                    [
                        'type' => Controls_Manager::DIVIDER,
                    ]
                );

            $this->start_controls_tabs('be_addons_adv_accordion_header_tabs');
                # Normal State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_header_normal',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    
                    ]
                );

                    $this->add_control(
                        'be_addons_adv_accordion_tab_icon_color',
                        [
                            'label'     => esc_html__('Icon Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__icon' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'be_addons_adv_accordion_tab_text_color',
                        [
                            'label'     => esc_html__('Text Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_title_typography',
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_color',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header',
                        ]
                    );


                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_border',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_border_radius',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_margin',
                        [
                            'label'      => esc_html__('Margin', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_padding',
                        [
                            'label'      => esc_html__('Padding', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                # Hover State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_header_hover',
                    [
                        'label' => esc_html__('Hover', 'beaddon'),
                    ]
                );

                    $this->add_control(
                        'be_addons_adv_accordion_tab_icon_color_hover',
                        [
                            'label'     => esc_html__('Icon Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header:hover .fa' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'be_addons_adv_accordion_toggle_icon_show' => 'yes',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'be_addons_adv_accordion_hover_tab_icon_color',
                        [
                            'label'     => esc_html__('Hover Icon Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header:hover .be__addons__accordion__icon' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $this->add_control(
                        'be_addons_adv_accordion_tab_text_color_hover',
                        [
                            'label'     => esc_html__('Text Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header:hover' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_color_hover',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_border_hover',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header:hover',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_border_radius_hover',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();

                #Active State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_header_active',
                    [
                        'label' => esc_html__('Active', 'beaddon'),
                    ]
                );

                    $this->add_control(
                        'be_addons_adv_accordion_tab_icon_color_active',
                        [
                            'label'     => esc_html__('Icon Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .fa' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'be_addons_adv_accordion_toggle_icon_show' => 'yes',
                            ],
                            'separator'    => 'before',
                        ]
                    );

                    $this->add_control(
                        'be_addons_adv_accordion_active_tab_icon_color',
                        [
                            'label'     => esc_html__('Active Icon Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .be__addons__accordion__icon' => 'color: {{VALUE}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );

                    $this->add_control(
                        'be_addons_adv_accordion_tab_text_color_active',
                        [
                            'label'     => esc_html__('Text Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active' => 'color: {{VALUE}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_color_active',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_border_active',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_border_radius_active',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * Advance Accordion Caret Settings
         */
        $this->start_controls_section(
            'be_addons_adv_accordion_caret_section',
            [
                'label' => esc_html__('Toggle Caret Style', 'beaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'be_addons_accordion_show_icon' => 'yes',
                ],
            ]
        );
            $this->start_controls_tabs('be_addons_adv_accordion_caret_tabs');
                # Normal State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_caret_normal',
                    [
                        'label' => esc_html__( 'Normal', 'beaddon' ),
                    
                    ]
                );
                    $this->add_control(
                        'be_addons_adv_tabs_tab_toggle_color',
                        [
                            'label'     => esc_html__('Caret Color', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'color: {{VALUE}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_icon_size',
                        [
                            'label'   => __('Icon Size', 'beaddon'),
                            'type'    => Controls_Manager::SLIDER,
                            'default' => [
                                'size' => 16,
                                'unit' => 'px',
                            ],
                            'size_units' => ['px'],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 100,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header svg' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_toggle_background',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon',
                            'separator'=> 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_width',
                        [
                            'label'   => __('Width', 'beaddon'),
                            'type'    => Controls_Manager::SLIDER,
                            'default' => [
                                'unit' => 'px',
                            ],
                            'size_units' => ['px'],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 100,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'separator'=> 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_height',
                        [
                            'label'   => __('Height', 'beaddon'),
                            'type'    => Controls_Manager::SLIDER,
                            'default' => [
                                'unit' => 'px',
                            ],
                            'size_units' => ['px'],
                            'range'      => [
                                'px' => [
                                    'min'  => 0,
                                    'max'  => 100,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_toggle_border',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_border_radius',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_toggle_box_shadow',
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon',
                        ]
                    );

                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_margin',
                        [
                            'label'      => esc_html__('Margin', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_padding',
                        [
                            'label'      => esc_html__('Padding', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header .cliper_toggle_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();

                #Active State Tab
                $this->start_controls_tab(
                    'be_addons_adv_accordion_caret_active',
                    [
                        'label' => esc_html__('Active', 'beaddon'),
                    ]
                );
                    $this->add_control(
                        'be_addons_adv_tabs_tab_toggle_active_color',
                        [
                            'label'     => esc_html__('Caret Color (Active)', 'beaddon'),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .cliper_toggle_icon' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list:hover .be__addons__accordion__header .cliper_toggle_icon'  => 'color: {{VALUE}};',
                            ],
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_toggle_active_background',
                            'label'    => __( 'Background', 'beaddon' ),
                            'types'    => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .cliper_toggle_icon',
                            'separator'=> 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_toggle_active_border',
                            'label'    => esc_html__('Border', 'beaddon'),
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .cliper_toggle_icon',
                            'separator'    => 'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'be_addons_adv_accordion_tab_toggle_active_border_radius',
                        [
                            'label'      => esc_html__('Border Radius', 'beaddon'),
                            'type'       => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', 'em', '%'],
                            'selectors'  => [
                                '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .cliper_toggle_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow:: get_type(),
                        [
                            'name'     => 'be_addons_adv_accordion_tab_toggle_active_box_shadow',
                            'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__header.active .cliper_toggle_icon',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        /*-------------------------------------------
            Tab Style Advance Accordion Content Style
        * ------------------------------------------*/
        $this->start_controls_section(
            'be_addons_adv_accordion_tab_content_style_section',
            [
                'label' => esc_html__('Content Style', 'beaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'adv_accordion_content_text_color',
                [
                    'label'     => esc_html__('Text Color', 'beaddon'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography:: get_type(),
                [
                    'name'     => 'be_addons_adv_accordion_content_typography',
                    'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content',
                ]
            );

            $this->add_group_control(
                Group_Control_Background:: get_type(),
                [
                    'name'     => 'adv_accordion_content_bg_color',
                    'label'    => __( 'Background', 'beaddon' ),
                    'types'    => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content',
                ]
            );

            $this->add_responsive_control(
                'be_addons_adv_accordion_content_margin',
                [
                    'label'      => esc_html__('Margin', 'beaddon'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator'    => 'before',
                ]
            );
            $this->add_responsive_control(
                'be_addons_adv_accordion_content_padding',
                [
                    'label'      => esc_html__('Padding', 'beaddon'),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors'  => [
                        '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border:: get_type(),
                [
                    'name'     => 'be_addons_adv_accordion_content_border',
                    'label'    => esc_html__('Border', 'beaddon'),
                    'selector' => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow:: get_type(),
                [
                    'name'      => 'be_addons_adv_accordion_content_shadow',
                    'selector'  => '{{WRAPPER}} .be__addons__adv__accordion .be__addons__accordion__list .be__addons__accordion__content',
                    'separator' => 'before',
                ]
            );
        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $id_int = substr($this->get_id_int(), 0, 3);

        $this->add_render_attribute('be__addons__adv__accordion', 'class', 'be__addons__adv__accordion');
        $this->add_render_attribute('be__addons__adv__accordion', 'id', 'be__addons__adv__accordion-' . esc_attr($this->get_id()));
        ?>
	<div
		<?php echo $this->get_render_attribute_string('be__addons__adv__accordion'); ?>
		<?php echo 'data-accordion-id="' . esc_attr($this->get_id()) . '"'; ?>
		<?php echo !empty($settings['be_addons_accordion_type']) ? 'data-accordion-type="' . esc_attr($settings['be_addons_accordion_type']) . '"' : 'accordion'; ?>
		<?php echo !empty($settings['be_addons_accordion_toggle_speed']) ? 'data-toogle-speed="' . esc_attr($settings['be_addons_accordion_toggle_speed']) . '"' : '300'; ?>
	>
		<?php
            foreach ($settings['be_addons_adv_accordion_tab'] as $index => $tab):

            $tab_count               = $index + 1;
            $tab_title_setting_key   = $this->get_repeater_setting_key('be_addons_adv_accordion_tab_title', 'be_addons_adv_accordion_tab', $index);
            $tab_content_setting_key = $this->get_repeater_setting_key('be_addons_adv_accordion_tab_content', 'be_addons_adv_accordion_tab', $index);

            $tab_title_class         = ['elementor-tab-title', 'be__addons__accordion__header'];
            $tab_content_class       = ['be__addons__accordion__content', 'clearfix'];
            $tab_parent_class = '';

            if ($tab['be_addons_adv_accordion_tab_default_active'] == 'yes') {
                $tab_title_class[]   = 'active-default';
                $tab_content_class[] = 'active-default';
                $tab_parent_class = 'active-default';
            }

            $this->add_render_attribute($tab_title_setting_key, [
                'id'            => 'elementor-tab-title-' . $id_int . $tab_count,
                'class'         => $tab_title_class,
                'tabindex'      => $id_int . $tab_count,
                'data-tab'      => $tab_count,
                //'role'          => 'tab',
                'aria-controls' => 'elementor-tab-content-' . $id_int . $tab_count,
            ]);

            $this->add_render_attribute($tab_content_setting_key, [
                'id'              => 'elementor-tab-content-' . $id_int . $tab_count,
                'class'           => $tab_content_class,
                'data-tab'        => $tab_count,
                //'role'            => 'tabpanel',
                'aria-labelledby' => 'elementor-tab-title-' . $id_int . $tab_count,
            ]);
            ?>
			<div class="be__addons__accordion__list <?php echo esc_attr($tab_parent_class) ?>">

				<div <?php echo $this->get_render_attribute_string($tab_title_setting_key); ?>>
					<span class="be__addons__accordion__title__icon">
                        <?php if ($tab['be_addons_accordion_show_tab_icon'] === 'yes'): ?>
                            <?php echo be_addons_render_icons( $tab['be_addons_accordion_tab_title_icon'], 'be__addons__accordion__icon' ); ?>
                        <?php endif;?>
                        <?php echo $tab['be_addons_adv_accordion_tab_title']; ?>
                    </span>
                    <?php if ($settings['be_addons_accordion_show_icon'] === 'yes'): ?>
                        <?php echo be_addons_render_icons( $settings['be_addons_adv_accordion_toggle_icon'], 'cliper_toggle_icon' ); ?>
                    <?php endif;?>
                </div>

                <div <?php echo $this->get_render_attribute_string($tab_content_setting_key); ?>>
                    <?php
                        if ('content' == $tab['be_addons_accordion_text_type']): ?>
                            <p><?php echo do_shortcode($tab['be_addons_adv_accordion_tab_content']); ?></p>
                        <?php
                        elseif ('template' == $tab['be_addons_accordion_text_type']):                    
                            if (!empty($tab['be_addons_primary_templates'])) {

                                $be_addons_template_id = $tab['be_addons_primary_templates'];
                                $be_addons_frontend    = new Frontend;
                                echo $be_addons_frontend->get_builder_content($be_addons_template_id, true);
                            }
                        endif;
                    ?>
                </div>
		    </div>
		<?php endforeach;?>
	</div>
	<?php
}

    protected function content_template()
    {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Be_Addons_Adv_Accordion() );