<?php

/**
 * Plugin Name: Beaddon For Elementor
 * Description: Beaddon For Elementor is a full plugin for colleciton of elementor widgets.
 * Plugin URI: https://themeim.com/wordpress-themes/
 * Author: ThemeIM
 * Author URI: https://themeim.com/
 * Version: 1.0.0
 * License: GPL2
 * Text Domain: beaddon
 * Domain Path: /languages/
 */

namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * PUGINS MAIN PATH CONSTANT
 */
define( 'BE_ADDONS_VERSION', '1.1.1' );
define( 'BE_ADDONS_ROOT', dirname(__FILE__) );

define( 'BE_ADDONS_URL', plugins_url( '/', __FILE__ ) );
define( 'BE_ADDONS_ROOT_JS', plugins_url( '/assets/js/', __FILE__ ) );
define( 'BE_ADDONS_ROOT_CSS', plugins_url( '/assets/css/', __FILE__ ) );
define( 'BE_ADDONS_ROOT_ICON', plugins_url( '/assets/icons/', __FILE__ ) );
define( 'BE_ADDONS_ROOT_IMG', plugins_url( '/assets/img/', __FILE__ ) );

define( 'BE_ADDONS_DIR_URL', plugin_dir_url( __FILE__ ));
define( 'BE_ADDONS_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'BE_ADDONS_BASE', plugin_basename( BE_ADDONS_ROOT ) );

final class Be_Addons_Elementor_Extension {

	const VERSION                   = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION       = '5.7';

	private static $_instance = null;
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );
	}
	public function init() {

		load_plugin_textdomain( 'beaddon' );

		/*---------------------------------
			Check if Elementor installed and activated
		-----------------------------------*/
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		/*---------------------------------
			Check for required Elementor version
		----------------------------------*/
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		/*----------------------------------
			Check for required PHP version
		-----------------------------------*/
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		/*----------------------------------
			ADD NEW ELEMENTOR CATEGORIES
		------------------------------------*/
		add_action( 'elementor/init', [ $this, 'add_elementor_category' ] );

		/*----------------------------------
			ADD PLUGIN WIDGETS ACTIONS
		-----------------------------------*/
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );

		/*----------------------------------
			ELEMENTOR REGISTER CONTROL
		-----------------------------------*/
		add_action( 'elementor/controls/controls_registered', [ $this, 'init_controls' ] );

		/*----------------------------------
			EDITOR STYLE
		----------------------------------*/
		add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'be_addons_editor_styles' ] );

		/*----------------------------------
			ENQUEUE DEFAULT SCRIPT
		-----------------------------------*/
		add_action( 'wp_enqueue_scripts', array ( $this, 'be_addons_default_scripts' ) );

		/*----------------------------------
			EDITOR ENQUEUE STYLE & SCRIPTS
		-----------------------------------*/
		/*add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'register_widget_scripts' ] );
		add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'enqueue_widget_styles' ] );*/

		/*---------------------------------
			REGISTER FRONTEND SCRIPTS
		----------------------------------*/
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'be_addons_register_frontend_scripts' ] );
		add_action( 'elementor/frontend/after_register_styles', [ $this, 'be_addons_register_frontend_styles' ]);

		/*--------------------------------
			ENQUEUE FRONTEND SCRIPTS
		---------------------------------*/
		add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'be_addons_enqueue_frontend_scripts' ] );
		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'be_addons_enqueue_frontend_style' ] );

		if (file_exists(dirname(__FILE__) . '/post/texonomy.php' )) {
			require_once(dirname(__FILE__) . '/post/texonomy.php' );
		}
		if (file_exists(dirname(__FILE__) . '/inc/helper_functions.php' )) {
			require_once(dirname(__FILE__) . '/inc/helper_functions.php' );
		}
		if (file_exists(dirname(__FILE__) . '/inc/login_register_forms.php' )) {
			require_once(dirname(__FILE__) . '/inc/login_register_forms.php' );
		}

		if (file_exists(dirname(__FILE__) . '/inc/icons.php' )) {
			require_once(dirname(__FILE__) . '/inc/icons.php' );
		}

		if (file_exists(dirname(__FILE__) . '/Base/SignIn.php' )) {
			require_once(dirname(__FILE__) . '/Base/SignIn.php' );
		}

		if (file_exists(dirname(__FILE__) . '/Base/SignUp.php' )) {
			require_once(dirname(__FILE__) . '/Base/SignUp.php' );
		}

	}

	/*******************************
	 * 	ADD ASSETS
	 *******************************/

	public function be_addons_editor_styles(){
		wp_enqueue_style( 'be-editor', BE_ADDONS_ROOT_CSS . 'be-editor.css' );
	}

	public function be_addons_default_scripts(){
		wp_enqueue_style( 'be-widgets', BE_ADDONS_ROOT_CSS . 'widgets.css' );
		if ( class_exists('Give') ) {
			wp_enqueue_style( 'overwrite', BE_ADDONS_ROOT_CSS . 'overwrite.css', array('give-styles'), BE_ADDONS_VERSION, 'all' );
		}
	}

	/**
	 * Enqueue Widget Scripts
	 *
	 * Enqueue custom Scripts required to run Skima Core.
	 *
	 * @since 1.7.0
	 * @since 1.7.1 The method moved to this class.
	 *
	 * @access public
	 */
	public function be_addons_enqueue_frontend_scripts(){
        wp_enqueue_script( 'appear', BE_ADDONS_ROOT_JS . 'appear.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_enqueue_script( 'waypoints', BE_ADDONS_ROOT_JS . 'waypoints.min.js', array('jquery'), BE_ADDONS_VERSION, true );
	}

	/**
	 * Register Widget Scripts
	 *
	 * Register custom scripts required to run Skima Core.
	 *
	 * @since 1.6.0
	 * @since 1.7.1 The method moved to this class.
	 *
	 * @access public
	 */
	public function be_addons_register_frontend_scripts() {

        wp_register_script( 'owl-carousel', BE_ADDONS_ROOT_JS . 'owl.carousel.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'slick', BE_ADDONS_ROOT_JS . 'slick.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'swiper', BE_ADDONS_ROOT_JS . 'swiper.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'modal-video', BE_ADDONS_ROOT_JS . 'modal-video.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'svg-progress', BE_ADDONS_ROOT_JS . 'svg-progress-min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'TimeCircle', BE_ADDONS_ROOT_JS . 'TimeCircles.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'roadmap', BE_ADDONS_ROOT_JS . 'roadmap.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'timeline', BE_ADDONS_ROOT_JS . 'timeline.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'tooltipster', BE_ADDONS_ROOT_JS . 'tooltipster.bundle.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'animatedheadline', BE_ADDONS_ROOT_JS . 'jquery.animatedheadline.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'easyBar', BE_ADDONS_ROOT_JS . 'easyBar.js', array('jquery','waypoints'), BE_ADDONS_VERSION, true );
		
        wp_register_script( 'prism', BE_ADDONS_ROOT_JS . 'prism.js', null, BE_ADDONS_VERSION, true );
        wp_register_script( 'flip', BE_ADDONS_ROOT_JS . 'jquery.flip.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'sticky_video', BE_ADDONS_ROOT_JS . 'sticky_video.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'event-move', BE_ADDONS_ROOT_JS . 'jquery.event.move.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'twentytwenty', BE_ADDONS_ROOT_JS . 'jquery.twentytwenty.js', array('jquery','event-move'), BE_ADDONS_VERSION, true );
		wp_register_script( 'mapbox-map', '//api.mapbox.com/mapbox-gl-js/v2.0.0/mapbox-gl.js', null, BE_ADDONS_VERSION, true );
		wp_register_script( 'be-map', BE_ADDONS_ROOT_JS . 'be-map.js', array('mapbox-map'), BE_ADDONS_VERSION, true );

        /*--------------------------
			SINGLE SCRIPTS
        ---------------------------*/
        wp_register_script( 'isotope', BE_ADDONS_ROOT_JS . 'isotope.pkgd.min.js', array('jquery','imagesloaded'), BE_ADDONS_VERSION, true );
        wp_register_script( 'masonry', array('jquery', 'imagesloaded') );
        wp_register_script( 'ajaxchimp', BE_ADDONS_ROOT_JS . 'ajaxchimp.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'anime', BE_ADDONS_ROOT_JS . 'anime.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'tilt', BE_ADDONS_ROOT_JS . 'tilt.jquery.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'vanilla-tilt', BE_ADDONS_ROOT_JS . 'vanilla-tilt.js', array(), BE_ADDONS_VERSION, true );
        wp_register_script( 'be-effect', BE_ADDONS_ROOT_JS . 'be-effect.min.js', array('jquery'), BE_ADDONS_VERSION, true );

		wp_register_script('lottie-player', 'https://unpkg.com/@lottiefiles/lottie-player@0.4.0/dist/lottie-player.js',['be-core'],BE_ADDONS_VERSION,true);
        wp_register_script('lottie-interactivity', 'https://unpkg.com/@lottiefiles/lottie-interactivity@latest/dist/lottie-interactivity.min.js',['be-core'],BE_ADDONS_VERSION, true);


        //wp_register_script( 'base_effect', BE_ADDONS_ROOT_JS . 'be_addons_base_effect.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'base_effect_2', BE_ADDONS_ROOT_JS . 'be_addons_base_effect_2.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'viewport', BE_ADDONS_ROOT_JS . 'viewport.jquery.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'circle-progress', BE_ADDONS_ROOT_JS . 'circle-progress.min.js', array('jquery'), BE_ADDONS_VERSION, true );
        wp_register_script( 'counter-main', BE_ADDONS_ROOT_JS . 'counter-main.js', array('jquery','circle-progress'), BE_ADDONS_VERSION, true );
      

        wp_register_script( 'be-core', BE_ADDONS_ROOT_JS . 'active.js', array('jquery'), BE_ADDONS_VERSION, true );
	}

	/**
	 * Enqueue Widget Styles
	 *
	 * Enqueue custom styles required to run Skima Core.
	 *
	 * @since 1.7.0
	 * @since 1.7.1 The method moved to this class.
	 *
	 * @access public
	 */
	public function be_addons_enqueue_frontend_style() {
		wp_dequeue_style('e-animations');
		wp_deregister_style('e-animations');
        wp_enqueue_style( 'be-animate', BE_ADDONS_ROOT_CSS . 'animate.css', array('e-animations') );
	}

	/**
	 * Register Widget Styles
	 *
	 * Register custom styles required to run Skima Core.
	 *
	 * @since 1.7.0
	 * @since 1.7.1 The method moved to this class.
	 *
	 * @access public
	 */
	public function be_addons_register_frontend_styles(){
		wp_register_style( 'owl-carousel', BE_ADDONS_ROOT_CSS .'owl.carousel.css' );
        wp_register_style( 'slick', BE_ADDONS_ROOT_CSS .'slick.min.css' );
        wp_register_style( 'swiper', BE_ADDONS_ROOT_CSS .'swiper.min.css' );
        wp_register_style( 'modal-video', BE_ADDONS_ROOT_CSS .'modal-video.min.css' );
        wp_register_style( 'TimeCircle', BE_ADDONS_ROOT_CSS .'TimeCircles.css' );
        wp_register_style( 'roadmap', BE_ADDONS_ROOT_CSS .'roadmap.min.css' );
        wp_register_style( 'timeline', BE_ADDONS_ROOT_CSS .'timeline.min.css' );
        wp_register_style( 'tooltipster', BE_ADDONS_ROOT_CSS .'tooltipster.bundle.min.css' );
        wp_register_style( 'animatedheadline', BE_ADDONS_ROOT_CSS .'jquery.animatedheadline.css' );
        wp_register_style( 'easyBar', BE_ADDONS_ROOT_CSS .'easyBar.css' );
        wp_register_style( 'prism', BE_ADDONS_ROOT_CSS .'prism.css' );
        wp_register_style( 'flip', BE_ADDONS_ROOT_CSS .'flipbox.css' );
        wp_register_style( 'sticky_video', BE_ADDONS_ROOT_CSS .'sticky_video.css' );
        wp_register_style( 'twentytwenty', BE_ADDONS_ROOT_CSS .'twentytwenty.css' );
		wp_register_style( 'mapbox-map', '//api.mapbox.com/mapbox-gl-js/v2.0.0/mapbox-gl.css' );
        wp_register_style( 'be-grid', BE_ADDONS_ROOT_CSS .'be-grid.css' );
        wp_register_style( 'be-round-counter-style', BE_ADDONS_ROOT_CSS .'be-round-counter.css' );
	}

	/***************************
	 * 	VERSION CHECK
	 * *************************/
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'beaddon' ),
			'<strong>' . esc_html__( 'Elementor Be Addons', 'beaddon' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'beaddon' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/**************************
	 * 	MISSING NOTICE
	 ***************************/
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'beaddon' ),
			'<strong>' . esc_html__( 'Elementor Be Addons', 'beaddon' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'beaddon' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/****************************
	 * 	PHP VERSION NOTICE
	 ****************************/
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'beaddon' ),
			'<strong>' . esc_html__( 'Elementor Be Addons', 'beaddon' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'beaddon' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	/****************************
	 * 	INIT WIDGETS
	 ****************************/
	public function init_widgets() {
		$this->be_addons_widgets();
		$this->be_addons_widgets_register();
	}

	public function be_addons_widgets(){
		/*---------------------------
			Include Widget files
		-----------------------------*/
		if (array_key_exists( 'accordion', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/adv_accordion.php' );
		}
		if (array_key_exists( 'animate_headline', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/animate_headline.php' );
		}
		if (array_key_exists( 'area_title', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/area_title.php' );
		}

		if (array_key_exists( 'box', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/box.php' );
		}
		if (array_key_exists( 'business_hours', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/business_hours.php' ); /* Also It Will Be Used For Mega Listing With Icon*/
		}

		if (array_key_exists( 'cf7', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/cf7.php' );
		}
		if (array_key_exists( 'copyright_text', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/copyright_text.php' );
		}
		if (array_key_exists( 'countdown_circle', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/countdown_circle.php' );
		}
		if (array_key_exists( 'counter', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/counter.php' );
		}
		if (array_key_exists( 'counter_circle', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/counter_circle.php' );
		}

		if (array_key_exists( 'download_button', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/download_button.php' );
		}
		if (array_key_exists( 'dual_button', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/dual_button.php' );
		}
		if (array_key_exists( 'dual_text', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/dual_text.php' );
		}

		if (array_key_exists( 'edd', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/edd.php' );
		}
		if (array_key_exists( 'edd_login', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/edd_login.php' );
		}
		if (array_key_exists( 'edd_products', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/edd_products.php' );
		}
		if (array_key_exists( 'edd_register', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/edd_register.php' );
		}
		if (array_key_exists( 'edd_search_form', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/edd_search_form.php' );
		}
		if (array_key_exists( 'edd_thumbs_categories', be_addons_widget_control()) ){
			require_once( __DIR__ . '/widgets/edd_thumbs_categories.php' );
		}

		if (array_key_exists( 'give_campains', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/give_campains.php' );
		}

		if (array_key_exists( 'icon_listing', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/icon_listing.php' );
		}
		if (array_key_exists('be-circle-counter', be_addons_widget_control())) {
			require_once __DIR__ . '/widgets/be_counter.php';
		}
		if (array_key_exists( 'image_carousel', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/image_carousel.php' );
		}
		if (array_key_exists( 'image_carousel_alt', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/image_carousel_alt.php' );
		}
		if (array_key_exists( 'info_box', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/info_box.php' );
		}
		if (array_key_exists( 'infotext_box', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/infotext_box.php' );
		}
		if (array_key_exists( 'instagram', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/instagram.php' );
		}

		if (array_key_exists( 'multitype_gallery', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/multitype_gallery.php' );
		}

		if (array_key_exists( 'navigation_menu', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/navigation_menu.php' );
		}

		if (array_key_exists( 'progressbar', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/progressbar.php' );
		}

		if (array_key_exists( 'portfolio', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/portfolio.php' );
		}
		if (array_key_exists( 'portfolio_carousel', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/portfolio_carousel.php' );
		}
		if (array_key_exists( 'position_element', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/position_element.php' );
		}
		if (array_key_exists( 'post_carousel', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/post_carousel.php' );
		}
		if (array_key_exists( 'post_group', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/post_group.php' );
		}
		if (array_key_exists( 'post_group_2', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/post_group_2.php' );
		}

		if (array_key_exists( 'price_table', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/price_table.php' );
		}
		if (array_key_exists( 'price_tabs', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/price_tabs.php' );
		}
		if (array_key_exists( 'progress_roadmap', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/progress_roadmap.php' );
		}

		if (array_key_exists( 'scroll_button', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/scroll_button.php' );
		}
		if (array_key_exists( 'shortcode', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/shortcode.php' );
		}
		if (array_key_exists( 'socials', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/socials.php' );
		}
		if (array_key_exists( 'subscriber_form', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/subscriber_form.php' );
		}

		if (array_key_exists( 'tabs', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/tabs.php' );
		}
		if (array_key_exists( 'teams', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/teams.php' );
		}
		if (array_key_exists( 'testimonials', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/testimonials.php' );
		}
		if (array_key_exists( 'timeline', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/timeline.php' );
		}
		if (array_key_exists( 'timeline_roadmap', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/timeline_roadmap.php' );
		}
		if (array_key_exists( 'timeline_step', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/timeline_step.php' );
		}

		if (array_key_exists( 'video', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/video.php' );
		}
		if (array_key_exists( 'video_popup_button', be_addons_widget_control()) ){
		    require_once( __DIR__ . '/widgets/video_popup_button.php' );
		}

		if ( array_key_exists( 'welcome_slides', be_addons_widget_control() ) ){
		    require_once( __DIR__ . '/widgets/welcome_slides.php' );
		}
		if ( array_key_exists( 'woocommerce_products', be_addons_widget_control() ) ){
		    require_once( __DIR__ . '/widgets/woocommerce_products.php' );
		}

		if (array_key_exists( 'base_effect', be_addons_widget_control() ) ){
	    	require_once( __DIR__ . '/widgets/base_effect.php' );
		}

		if (array_key_exists( 'base_effect_2', be_addons_widget_control() ) ){
	    	require_once( __DIR__ . '/widgets/base_effect_2.php' );
		}

		if (array_key_exists( 'lottie_animation', be_addons_widget_control() ) ){
	    	require_once( __DIR__ . '/widgets/lottie_animation.php' );
		}

		if (array_key_exists( 'image_compare', be_addons_widget_control() ) ){
	    	require_once( __DIR__ . '/widgets/image_compare.php' );
		}
		
		require_once( __DIR__ . '/widgets/user/user_signin.php' );
		require_once( __DIR__ . '/widgets/user/user_signup.php' );
		require_once( __DIR__ . '/widgets/user/forgot_password.php' );

		require_once( __DIR__ . '/widgets/any_slides.php' );

	}
	public function be_addons_widgets_register(){

		/**
		 * NOTE: If you use ( use \Elementor\Plugin as Plugin; ) you need to set namespace before instansiate in widget register.
		 * Like Plugin::instance()->widgets_manager->register_widget_type( new Widget_Class() );
		 * and If you use ( namespace Elementor ) No need instansiate in widget register.
		 * Like Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Widget_Class() );
		 */
	}

	/******************************
	 * 	INIT CONTROLS
	 ******************************/
	public function init_controls() {
		/*---------------------------
			Include Control files
		---------------------------*/
		require_once( __DIR__ . '/controls/control.php' );

		/*---------------------------
			Register control
		---------------------------*/
		//Plugin::$instance->controls_manager->register_control( 'control-type-', new \Be_Addons_Control() );
	}

	/*******************************
	 * 	ADD CUSTOM CATEGORY
	 *******************************/
	public function add_elementor_category()
	{
		Plugin::instance()->elements_manager->add_category( 'be-addons', array(
			'title' => __( 'Be Addons', 'beaddon' ),
			'icon'  => 'fa fa-plug',
		), 1 );
	}


	/******************************
	 * 	ALL INCLUDES
	******************************/
	public function includes() {

	}
}
Be_Addons_Elementor_Extension::instance();
