<?php

/* -----------------------------------
    CUSTOM LOGIN FORM
-------------------------------------*/
function wc_user_login_callback() {
    if ( isset( $_POST['formType'] ) && wp_verify_nonce( $_POST['formType'], 'userLogin' ) ) {

        global $errors_login;
        $uName     = $_POST['log'];
        $uPassword = $_POST['pwd'];
        $redirect  = $_POST['redirect'];

        if ( $uName == '' && $uPassword != '' ) {
            $errors_login = '<strong>Error! </strong> Username is required.';
        } elseif ( $uName != '' && $uPassword == '' ) {
            $errors_login = '<strong>Error! </strong> Password is required.';
        } elseif ( $uName == '' && $uPassword == '' ) {
            $errors_login = '<strong>Error! </strong> Username & Password are required.';
        } elseif ( $uName != '' && $uPassword != '' ) {
            $creds                  = array();
            $creds['user_login']    = $uName;
            $creds['user_password'] = $uPassword;
            $creds['remember']      = false;
            $user                   = wp_signon( $creds, false );
            if ( is_wp_error( $user ) ) {
                $errors_login = $user->get_error_message();
            } else {
                wp_redirect( site_url() );
                exit;
            }
        }
    }
}
add_action( 'wp', 'wc_user_login_callback' );

function wc_login_form_callback() {
    ob_start(); ?>

    <?php  if ( !is_user_logged_in() ) : ?>

        <?php global $errors_login; ?>

        <?php if ( !empty( $errors_login ) ) : ?>
            <div class="alert alert-danger">
                <?php echo $errors_login; ?>
            </div>
        <?php endif; ?>

        <form method="post" class="wc-login-form">
            <div class="login_form">
                <div class="log_user">
                    <label for="user_name"><?php echo esc_html__( 'Username', 'becore' ); ?></label>
                    <input name="log" type="text" id="user_name">
                </div>
                <div class="log_pass">
                    <label for="user_password"><?php echo esc_html__( 'Password', 'becore' ); ?></label>
                    <input name="pwd" id="user_password" type="password">
                </div>
                <?php
                    ob_start();
                    do_action( 'login_form' );
                    echo ob_get_clean();
                ?>
                <?php wp_nonce_field( 'userLogin', 'formType' );?>
            </div>
            <button type="submit"><?php echo esc_html__( 'Sign In', 'becore' ); ?></button>
        </form>

    <?php else : ?>
        <p class="error-logged"><?php echo esc_html__( 'You are already logged in', 'becore' ); ?></p>
    <?php endif; ?>

    <?php

    $login_form = ob_get_clean();
    return $login_form;
}
add_shortcode( 'wc_login_form', 'wc_login_form_callback' );


/* -----------------------------------
    CUSTOM REGISTER FORM
-------------------------------------*/

function wc_user_register_callback() {
    if ( isset( $_POST['formType'] ) && wp_verify_nonce( $_POST['formType'], 'userRegister' ) ) {

        global $registrationError, $registrationSuccess;

        $u_name  = trim( $_POST['user_name'] );
        $u_email = trim( $_POST['user_email'] );
        $u_pwd   = trim( $_POST['user_password'] );
        $u_cpwd  = trim( $_POST['user_cpassword'] );

        if ( $u_name == '' ) {
            $registrationError .= '<strong>Error! </strong> Enter User name.,';
        }

        if ( username_exists( $u_name ) ) {
            $registrationError .= '<strong>Error! </strong> Username In Use!.,';
        }

        if ( $u_email == '' ) {
            $registrationError .= '<strong>Error! </strong> Enter Email.,';
        }

        if ( $u_pwd == '' || $u_cpwd == '' ) {
            $registrationError .= '<strong>Error! </strong> Enter Password.,';
        }

        if ( strlen( $u_pwd ) < 7 ) {
            $registrationError .= '<strong>Error! </strong> Use minimum 7 character in password.,';
        }

        if ( $u_pwd != $u_cpwd ) {
            $registrationError .= '<strong>Error! </strong> Password are not matching.,';
        }

        if ( $u_email != '' && !is_email( $u_email ) ) {
            $registrationError .= '<strong>Error! </strong> Invalid e-mail address.,';
        }

        if ( email_exists( $u_email ) != false ) {
            $registrationError .= '<strong>Error! </strong> This Email is already registered.,';
        }

        $registrationError = trim( $registrationError, ',' );
        $registrationError = str_replace( ",", "<br/>", $registrationError );

        if ( empty( $registrationError ) ) {

            $user_login = $u_name;
            $user_email = $u_email;

            $userdata = array(
                'user_login' => $user_login,
                'user_pass'  => $u_pwd,
                'user_email' => $user_email,
            );

            $errors = wp_insert_user( $userdata );

            if ( is_wp_error( $errors ) ) {
                $registrationError = $errors->get_error_message();
            } else {
                $registrationSuccess = '<strong>Success! </strong> Application submitted. Please wait for user approval.';

                wp_set_current_user( $errors, $u_name );
                wp_set_auth_cookie( $errors );
                do_action( 'wp_login', $u_name );

                wp_redirect( site_url() );
                exit;
            }
        }
    }
}

add_action('wp', 'wc_user_register_callback');


function wc_register_form_callback() {
    ob_start();
    if (!is_user_logged_in()) {
        global $registrationError, $registrationSuccess;
        if (!empty($registrationError)) {
            ?>
            <div class="alert alert-danger">
                <?php echo $registrationError; ?>
            </div>
        <?php } ?>

        <?php if (!empty($registrationSuccess)) { ?>
            <br/>
            <div class="alert alert-success">
                <?php echo $registrationSuccess; ?>
            </div>
        <?php } ?>


        <form method="post" class="wc-register-form">
            <div class="register_form">
                <div class="log_user">
                    <label for="user_name">User name</label>
                    <?php $user_name = isset($_POST['user_name']) ? $_POST['user_name'] : ''; ?>
                    <input type="text" name="user_name" id="user_name" value="<?php echo $user_name; ?>" />
                </div>

                <div class="log_user">
                    <label for="user_email">Email address</label>
                    <?php $user_email = isset($_POST['user_email']) ? $_POST['user_email'] : ''; ?>
                    <input type="email" name="user_email" id="user_email" value="<?php echo $user_email; ?>" />
                </div>

                <div class="log_pass">
                    <label for="user_password">Password</label>
                    <input type="password" name="user_password" id="user_password" />
                </div>

                <div class="log_pass">
                    <label for="user_cpassword">Password again</label>
                    <input type="password" name="user_cpassword" id="user_cpassword" />
                </div>

                <div class="log_pass">
                    <?php
                    ob_start();
                    do_action('register_form');
                    echo ob_get_clean();
                    ?>
                </div>

                <div class="log_user">
                    <?php wp_nonce_field('userRegister', 'formType'); ?>
                    <button type="submit" class="register_user">Register</button>
                </div>
            </div>
        </form>
        <?php
    } else {
        echo '<p class="error-logged">You are already logged in.</p>';
    }
    $register_form = ob_get_clean();
    return $register_form;
}
add_shortcode('wc_register_form', 'wc_register_form_callback');


/* -----------------------------------
    CUSTOM CHANGE PASSWORD FORM
-------------------------------------*/
function wc_user_change_pwd_callback() {

    if ( isset( $_POST['formType'] ) && wp_verify_nonce( $_POST['formType'], 'changePassword' ) ) {
        global $changePasswordError, $changePasswordSuccess;

        $user = wp_get_current_user();

        $changePasswordError   = '';
        $changePasswordSuccess = '';
        $u_opwd                = trim( $_POST['user_opassword'] );
        $u_pwd                 = trim( $_POST['user_password'] );
        $u_cpwd                = trim( $_POST['user_cpassword'] );

        if ( $u_opwd == '' || $u_pwd == '' || $u_cpwd == '' ) {
            $changePasswordError .= '<strong>ERROR: </strong> Enter Password.,';
        }

        if ( !wp_check_password( $u_opwd, $user->data->user_pass, $user->ID ) ) {
            $changePasswordError .= '<strong>ERROR: </strong> Old Password wrong.,';
        }

        if ( $u_pwd != $u_cpwd ) {
            $changePasswordError .= '<strong>ERROR: </strong> Password are not matching.,';
        }

        if ( strlen( $u_pwd ) < 7 ) {
            $changePasswordError .= '<strong>ERROR: </strong> Use minimum 7 character in password.,';
        }

        $changePasswordError = trim( $changePasswordError, ',' );
        $changePasswordError = str_replace( ",", "<br/>", $changePasswordError );

        if ( empty( $changePasswordError ) ) {
            wp_set_password( $u_pwd, $user->ID );

            wp_set_current_user( $user->ID, $user->user_login );
            wp_set_auth_cookie( $user->ID );
            do_action( 'wp_login', $user->user_login );
            $changePasswordSuccess = 'Password is successfully updated.';
        }
    }
}

add_action( 'wp', 'wc_user_change_pwd_callback' );


function wc_change_pwd_form_callback() {
    ob_start();
    if (is_user_logged_in()) {

        global $changePasswordError, $changePasswordSuccess;

        if (!empty($changePasswordError)) {
            ?>
            <div class="alert alert-danger">
                <?php echo $changePasswordError; ?>
            </div>
        <?php } ?>

        <?php if (!empty($changePasswordSuccess)) { ?>
            <br/>
            <div class="alert alert-success">
                <?php echo $changePasswordSuccess; ?>
            </div>
        <?php } ?>

        <form method="post" class="wc-change-pwd-form">
            <div class="change_pwd_form">

                <div class="log_pass">
                    <label for="user_oldpassword">Old Password</label>
                    <input type="password" name="user_opassword" id="user_oldpassword" />
                </div>

                <div class="log_pass">
                    <label for="user_password">New Password</label>
                    <input type="password" name="user_password" id="user_password" />
                </div>

                <div class="log_pass">
                    <label for="user_cpassword">Confirm Password</label>
                    <input type="password" name="user_cpassword" id="user_cpassword" />
                </div>

                <div class="log_pass">
                    <?php
                    ob_start();
                    do_action('password_reset');
                    echo ob_get_clean();
                    ?>
                </div>

                <div class="log_user">
                    <?php wp_nonce_field('changePassword', 'formType'); ?>
                    <button type="submit" class="register_user">Submit</button>
                </div>

            </div>
        </form>
        <?php
    }
    $change_pwd_form = ob_get_clean();
    return $change_pwd_form;
}
add_shortcode('wc_change_pwd_form', 'wc_change_pwd_form_callback');


/* -----------------------------------
    CUSTOM FORGOT PASSWORD FORM
-------------------------------------*/

function wc_user_forgot_pwd_callback() {
    
    if ( isset( $_POST['formType'] ) && wp_verify_nonce( $_POST['formType'], 'userGetPassword' ) ) {
        global $getPasswordError, $getPasswordSuccess;

        $email = trim( $_POST['user_login'] );

        if ( empty( $email ) ) {
            $getPasswordError = '<strong>Error! </strong>Enter a e-mail address.';
        } else if ( !is_email( $email ) ) {
            $getPasswordError = '<strong>Error! </strong>Invalid e-mail address.';
        } else if ( !email_exists( $email ) ) {
            $getPasswordError = '<strong>Error! </strong>There is no user registered with that email address.';
        } else {

            // lets generate our new password
            $random_password = wp_generate_password( 12, false );

            // Get user data by field and data, other field are ID, slug, slug and login
            $user = get_user_by( 'email', $email );

            $update_user = wp_update_user( array(
                'ID'        => $user->ID,
                'user_pass' => $random_password,
            )
            );

            // if  update user return true then lets send user an email containing the new password
            if ( $update_user ) {
                $to      = $email;
                $subject = 'Your new password';
                $sender  = get_bloginfo( 'name' );

                $message = 'Your new password is: ' . $random_password;

                /* $headers[] = 'MIME-Version: 1.0' . "\r\n";
                $headers[] = 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
                $headers[] = "X-Mailer: PHP \r\n";
                $headers[] = 'From: ' . $sender . ' < ' . $email . '>' . "\r\n"; */
                $headers = array( 'Content-Type: text/html; charset=UTF-8' );

                $mail = wp_mail( $to, $subject, $message, $headers );
                if ( $mail ) {
                    $getPasswordSuccess = '<strong>Success! </strong>Check your email address for you new password.';
                }
            } else {
                $getPasswordError = '<strong>Error! </strong>Oops something went wrong.';
            }
        }
    }
}
// add_action( 'wp', 'wc_user_forgot_pwd_callback' );


function wc_forgot_pwd_form_callback() {
    ob_start();
    if (!is_user_logged_in()) {
        global $getPasswordError, $getPasswordSuccess;

        if (!empty($getPasswordError)) {  ?>
            <div class="alert alert-danger">
                <?php echo $getPasswordError; ?>
            </div>
        <?php } ?>

        <?php if (!empty($getPasswordSuccess)) { ?>
            <br/>
            <div class="alert alert-success">
                <?php echo $getPasswordSuccess; ?>
            </div>
        <?php } ?>
        <form method="post" class="wc-forgot-pwd-form">
            <div class="forgot_pwd_form">
                <div class="log_user">
                    <label for="user_login">Username or E-mail:</label>
                    <?php $user_login = isset($_POST['user_login']) ? $_POST['user_login'] : ''; ?>
                    <input type="text" name="user_login" id="user_login" value="<?php echo $user_login; ?>" />
                </div>
                <div class="log_user">
                    <?php
                    ob_start();
                    do_action('lostpassword_form');
                    echo ob_get_clean();
                    ?>
                    <?php wp_nonce_field('userGetPassword', 'formType'); ?>
                    <button type="submit" class="get_new_password">Get New Password</button>
                </div>
            </div>
        </form>
        <?php
    }

    $forgot_pwd_form = ob_get_clean();
    return $forgot_pwd_form;
}
// add_shortcode('wc_forgot_pwd_form', 'wc_forgot_pwd_form_callback');


function be_addons_custom_forget_pass_callback(){
    if ( isset( $_POST['formType'] ) && wp_verify_nonce( $_POST['formType'], 'userGetPassword' ) ) {

        global $getPasswordError, $getPasswordSuccess;

        $email = trim( $_POST['user_login'] );

        if ( empty( $email ) ) {
            $getPasswordError = '<strong>Error! </strong>Enter a e-mail address.';
        } else if ( !is_email( $email ) && !username_exists( $email ) ) {
            $getPasswordError = '<strong>Error! </strong>Invalid e-mail address or username.';            
        } else if ( !email_exists( $email ) && is_email( $email ) ) {
            $getPasswordError = '<strong>Error! </strong>There is no user registered with that email address.';
        } else {

            // lets generate our new password
            $random_password = wp_generate_password( 12, false );

            if( username_exists( $email ) ){
                $user = get_user_by( 'login', $email );
                // $user  = get_user_by( 'id', $user->ID );
                $email = $user->user_email;
            }

            // Get user data by field and data, other field are ID, slug, slug and login
            $user = get_user_by( 'email', $email );

            $update_user = wp_update_user( array(
                'ID'        => $user->ID,
                'user_pass' => $random_password,
            ) );

            // if  update user return true then lets send user an email containing the new password
            if ( $update_user ) {
                $to      = $email;
                $subject = 'Your new password';
                $sender  = get_bloginfo( 'name' );
                $message = 'Your new password is: ' . $random_password;
                $headers = array( 'Content-Type: text/html; charset=UTF-8' );

                $mail = wp_mail( $to, $subject, $message, $headers );
                if ( $mail ) {
                    $getPasswordSuccess = '<strong>Success! </strong>Check your email address for you new password.';
                }
            } else {
                $getPasswordError = '<strong>Error! </strong>Oops something went wrong.';
            }
        }
    }
}
add_action( 'wp', 'be_addons_custom_forget_pass_callback' );