<?php
/*-------------------------------
	CUSTOM IMAGE SIZE
--------------------------------*/
add_image_size( 'be_addons_grid_big_thumb', 570, 330 );
add_image_size( 'be_addons_grid_small_thumb', 270, 180 );

/*------------------------------
	CUSTOM FONTS CONTROLS
-------------------------------*/
class Be_Addons_Custom_Functions{

    public function __construct() {
		add_action( 'elementor/controls/controls_registered', [ $this, 'add_custom_font' ] );  
	}
	
	public function add_custom_font( $controls_registry ){

	    $new_fonts = array(        
	        "Gilroy" => "googlefonts"
	    );

	    // For Elementor 1.7.10 and newer
	    $fonts = $controls_registry->get_control( 'font' )->get_settings( 'options' );
	    $fonts = array_merge($fonts,$new_fonts);

	    // Register here the custom font families
	    $controls_registry->get_control( 'font' )->set_settings( 'options', $fonts );  
	}
}
new Be_Addons_Custom_Functions();

/*-----------------------------
    EDD REVIEW FUNCTIONALITY
-------------------------------*/
if ( class_exists( 'EDD_Reviews' ) ) {
    /*-----------------------------------------
        Remove default edd review from content
    ------------------------------------------*/
    function be_addons_remove_review() {
        $edd_reviews = edd_reviews();
        remove_filter( 'the_content', array( $edd_reviews, 'load_frontend' ) );
    }
    add_action( 'template_redirect', 'be_addons_remove_review' );
}

/*--------------------------------------------------
    EDD DOWNLOAD DROPDOWN CATEGORY
--------------------------------------------------*/
function be_addons_get_terms_dropdown($taxonomies, $args){
    $myterms = get_terms( $taxonomies, $args );
    $output  = "<div class='download__search__cats '><select name='download_cats'>";
    $output .= "<option value='all'>" . esc_html__("All Categories", 'beaddon') . "</option>";
    foreach ($myterms as $term) {
        $term_name = $term->name;
        $slug      = $term->slug;
        $output   .= "<option value='" . $slug . "'>" . $term_name . "</option>";
    }
    $output .= "</select></div>";
    return $output;
}

/*------------------------------
    WOOCOMMERCE FUNCTIONALITY
-------------------------------*/
if ( class_exists( 'WooCommerce' ) ) {
    
    add_action( 'after_setup_theme', 'be_addons_woocommerce_setup' );
    function be_addons_woocommerce_setup() {

        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );
        add_theme_support( 'woocommerce', array(
            'thumbnail_image_width' => 500,
        ));
    }

    /*---------------------------------------
        ADD EXTRA METABOX TAB TO WOOCOMMERCE
    ----------------------------------------*/
    if( !function_exists('be_addons_add_wc_extra_metabox_tab')){
        function be_addons_add_wc_extra_metabox_tab($tabs){
            $be_addons_tab = array(
                'label'    => __( 'Product Badge', 'beaddon' ),
                'target'   => 'be_addons_product_data',
                'class'    => '',
                'priority' => 80,
            );
            $tabs[] = $be_addons_tab;
            return $tabs;
        }
        add_filter( 'woocommerce_product_data_tabs', 'be_addons_add_wc_extra_metabox_tab' );
    }

    // add metabox to general tab
    if( !function_exists('be_addons_add_metabox_to_general_tab')){
        function be_addons_add_metabox_to_general_tab(){
            echo '<div id="be_addons_product_data" class="panel woocommerce_options_panel hidden">';
                woocommerce_wp_text_input( array(
                    'id'          => '_saleflash_text',
                    'label'       => __( 'Custom Product Badge Text', 'beaddon' ),
                    'placeholder' => __( 'New', 'beaddon' ),
                    'description' => __( 'Enter your prefered SaleFlash text. Ex: New / Free etc', 'beaddon' ),
                ) );
            echo '</div>';
        }
        add_action( 'woocommerce_product_data_panels', 'be_addons_add_metabox_to_general_tab' );
    }
    // Update data
    if( !function_exists('be_addons_save_metabox_of_general_tab') ){
        function be_addons_save_metabox_of_general_tab( $post_id ){
            $saleflash_text = wp_kses_post( stripslashes( $_POST['_saleflash_text'] ) );
            update_post_meta( $post_id, '_saleflash_text', $saleflash_text);
        }
        add_action( 'woocommerce_process_product_meta', 'be_addons_save_metabox_of_general_tab');
    }

    /*--------------------------------
        CUSTOM PRODUCT BADGE
    --------------------------------*/
    function be_addons_custom_product_badge( $show = 'yes' ){
        global $product;
        $custom_saleflash_text = get_post_meta( get_the_ID(), '_saleflash_text', true );
        if( $show == 'yes' ){
            if( !empty( $custom_saleflash_text ) && $product->is_in_stock() ){
                if( $product->is_featured() ){
                    echo '<span class="ht-product-label ht-product-label-left hot">' . esc_html( $custom_saleflash_text ) . '</span>';
                }else{
                    echo '<span class="ht-product-label ht-product-label-left">' . esc_html( $custom_saleflash_text ) . '</span>';
                }
            }
        }
    }

    /*--------------------------------
         SALE FLASH
    ---------------------------------*/
    function be_addons_sale_flash( $offertype = 'default' ){
        global $product;
        if( $product->is_on_sale() && $product->is_in_stock() ){
            if( $offertype !='default' && $product->get_regular_price() > 0 ){
                $_off_percent  = ( 1 - round( $product->get_price() / $product->get_regular_price(), 2 ))*100;
                $_off_price    = round($product->get_regular_price() - $product->get_price(), 0);
                $_price_symbol = get_woocommerce_currency_symbol();
                $symbol_pos    = get_option('woocommerce_currency_pos', 'left');
                $price_display = '';
                switch( $symbol_pos ){
                    case 'left':
                        $price_display = '-'.$_price_symbol.$_off_price;
                    break;
                    case 'right':
                        $price_display = '-'.$_off_price.$_price_symbol;
                    break;
                    case 'left_space':
                        $price_display = '-'.$_price_symbol.' '.$_off_price;
                    break;
                    default: /* right_space */
                        $price_display = '-'.$_off_price.' '.$_price_symbol;
                    break;
                }
                if( $offertype == 'number' ){
                    echo '<span class="ht-product-label ht-product-label-right">'.$price_display.'</span>';
                }elseif( $offertype == 'percent'){
                    echo '<span class="ht-product-label ht-product-label-right">'.$_off_percent.'%</span>';
                }else{ echo ' '; }

            }else{
                echo '<span class="ht-product-label ht-product-label-right">'.esc_html__( 'Sale!', 'beaddon' ).'</span>';
            }
        }else{
            $out_of_stock      = get_post_meta( get_the_ID(), '_stock_status', true );
            $out_of_stock_text = apply_filters( 'be_addons_shop_out_of_stock_text', __( 'Out of stock', 'beaddon' ) );
            if ( 'outofstock' === $out_of_stock ) {
                echo '<span class="ht-stockout ht-product-label ht-product-label-right">'.esc_html( $out_of_stock_text ).'</span>';
            }
        }
    }

    /*------------------------------------
        WOOCOMMERCE DEFAULT RESULT COUNT
    --------------------------------------*/
    function be_addons_product_result_count( $total, $perpage, $paged ){
        wc_set_loop_prop( 'total', $total );
        wc_set_loop_prop( 'per_page', $perpage );
        wc_set_loop_prop( 'current_page', $paged );
        $geargs = array(
            'total'    => wc_get_loop_prop( 'total' ),
            'per_page' => wc_get_loop_prop( 'per_page' ),
            'current'  => wc_get_loop_prop( 'current_page' ),
        );
        wc_get_template( 'loop/result-count.php', $geargs );
    }

    /*-------------------------------------
        WOOCOMMERCE DEFAULT PRODUCT SHORTING
    ---------------------------------------*/
    function be_addons_product_shorting( $getorderby ){
        ?>
        <div class="be-custom-sorting">
            <form class="woocommerce-ordering" method="get">
                <select name="orderby" class="orderby">
                    <?php
                        $catalog_orderby = apply_filters( 'woocommerce_catalog_orderby', array(
                            'menu_order' => __( 'Default sorting', 'beaddon' ),
                            'popularity' => __( 'Sort by popularity', 'beaddon' ),
                            'rating'     => __( 'Sort by average rating', 'beaddon' ),
                            'date'       => __( 'Sort by latest', 'beaddon' ),
                            'price'      => __( 'Sort by price: low to high', 'beaddon' ),
                            'price-desc' => __( 'Sort by price: high to low', 'beaddon' ),
                        ) );
                        foreach ( $catalog_orderby as $id => $name ){
                            echo '<option value="' . esc_attr( $id ) . '" ' . selected( $getorderby, $id, false ) . '>' . esc_attr( $name ) . '</option>';
                        }
                    ?>
                </select>
                <?php
                    // Keep query string vars intact
                    foreach ( $_GET as $key => $val ) {
                        if ( 'orderby' === $key || 'submit' === $key )
                            continue;
                        if ( is_array( $val ) ) {
                            foreach( $val as $innerVal ) {
                                echo '<input type="hidden" name="' . esc_attr( $key ) . '[]" value="' . esc_attr( $innerVal ) . '" />';
                            }
                        } else {
                            echo '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $val ) . '" />';
                        }
                    }
                ?>
            </form>
        </div>
        <?php
    }

    /*------------------------------
        CUSTOM PAGE PAGINATION
    -------------------------------*/
    function be_addons_custom_pagination( $totalpage ){
        echo '<div class="be-row woocommerce"><div class="be-col-xs-12"><nav class="woocommerce-pagination">';
            echo paginate_links( apply_filters(
                    'woocommerce_pagination_args', array(
                        'base'      => esc_url( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ), 
                        'format'    => '', 
                        'current'   => max( 1, get_query_var( 'paged' ) ), 
                        'total'     => $totalpage, 
                        'prev_text' => '&larr;', 
                        'next_text' => '&rarr;', 
                        'type'      => 'list', 
                        'end_size'  => 3, 
                        'mid_size'  => 3 
                    )
                )       
            );
        echo '</div></div></div>';
    }

    /*------------------------------
        CHANGE PRODUCT PER PAGE
    --------------------------------*/

    /*-----------------------------------------
        ADD TO CART BUTTON
    -----------------------------------------*/
    function be_addons_woocommerce_addcart(){
        echo '<div class="be__addons__add__to__cart">';
            woocommerce_template_loop_add_to_cart();
        echo '</div>';
    }

    /* --------------------------------------
        WOOCOMMERCE REVIEW COUNT
    ----------------------------------------*/
    function be_addons_woocommerce_review_count( $settings ){
        global $product;

        if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' ) {
            return;
        }

        if( 'yes' != $settings['show_rating'] ){
            return;
        }

        $rating_count   = $product->get_rating_count();
        $review_count   = $product->get_review_count();
        $average        = $product->get_average_rating();
        $avarage_rating = sprintf(__( 'Rated %s out of 5', 'beaddon' ), $average );
        $rating_html    = wc_get_rating_html( $average, $rating_count );

        if ( comments_open() && $rating_count >= 0  ) :
            

                if( 'multiple_star' == $settings['rating_type'] ) :
                    
                    echo '<div class="product__item__review">';
                        if ( $average ){
                            echo '<div class="total__star__rating"><span class="rated__stars" style="width:'.( ( $average / 5 ) * 100 ) . '%"></span></div>';
                        }else{
                            echo '<div class="total__star__rating"></div>';
                        }
                        echo '<span class="total__review__count">('. esc_html( $review_count ) .')</span>';
                    echo '</div>';

                elseif( 'single_star' == $settings['rating_type'] ) :
                    $single_review_star_icon = $average ? '<span class="single__star__icon__rated"></span>' : '<span class="single__star__icon"></span>';
                    $single_total_review     = '<span class="total__review__count">('. esc_html( $review_count ) .')</span>';
                    echo '<div class="product__item__review"> '. $single_review_star_icon . $single_total_review .'</div>';
                endif;
        endif;
    }
}

/*------------------------------------------
    PRODUCT QUICKVIEW BUTTON
-------------------------------------------*/
/**
* [yith_quick_view product_id="30" type="button" label="Quick View"]
* Usages: Compare button shortcode [yith_compare_button] From "YITH WooCommerce Quick View" plugins.
* Plugins URL: https://wordpress.org/plugins/yith-woocommerce-quickview/
* File Path: https://docs.yithemes.com/yith-woocommerce-quick-view/premium-version-settings/shortcode/
* The Function "be_addons_woocommerce_compare_button" Depends on YITH WooCommerce Compare plugins. If YITH WooCommerce Compare is installed and actived, then it will work.
*/
function be_addons_quick_view_button( $product_id = 0, $label = '', $return = false ) {
    if( !class_exists('YITH_WCQV_Frontend') ){
        return;
    }
    global $product;

    if( ! $product_id ){
        $product instanceof WC_Product && $product_id = yit_get_prop( $product, 'id', true );
    }
    $show_quick_view_button = apply_filters( 'yith_wcqv_show_quick_view_button', true, $product_id );
    if( !$show_quick_view_button ) return;

    $button = '';
    if( $product_id ) {
        // get label
        $label  = $label ? $label : esc_html__( 'Quick View', 'beaddon' );
        $button = '<div class="be__addons__quickview__button"><a title="'.esc_attr__( 'Quick View', 'beaddon' ).'" href="#" class="button yith-wcqv-button" data-product_id="' . $product_id . '"><i class="ti ti-zoom-in"></i>' . $label . '</a></div>';
        $button = apply_filters('yith_add_quick_view_button_html', $button, $label, $product);
    }
    if( $return ) {
        return $button;
    }
    echo $button;
}
remove_action( 'woocommerce_after_shop_loop_item', 'yith_add_quick_view_button', 15 );
remove_action( 'yith_wcwl_table_after_product_name', 'yith_add_quick_view_button', 15 );
/*------------------------------------------
    PRODUCT WISHLIST BUTTON
-------------------------------------------*/
/**
* Usages: "be_addons_add_to_wishlist_button()" function is used  to modify the wishlist button from "YITH WooCommerce Wishlist" plugins.
* Plugins URL: https://wordpress.org/plugins/yith-woocommerce-wishlist/
* File Path: yith-woocommerce-wishlist/templates/add-to-wishlist.php
* The below Function depends on YITH WooCommerce Wishlist plugins. If YITH WooCommerce Wishlist is installed and actived, then it will work.
*/

function be_addons_add_to_wishlist_button( $normalicon = '<i class="fa fa-heart-o"></i>', $addedicon = '<i class="fa fa-heart"></i>', $tooltip = 'no' ) {
    global $product, $yith_wcwl;

    if ( ! class_exists( 'YITH_WCWL' ) || empty(get_option( 'yith_wcwl_wishlist_page_id' ))) return;

    $url          = YITH_WCWL()->get_wishlist_url();
    $product_type = $product->get_type();
    $exists       = $yith_wcwl->is_product_in_wishlist( $product->get_id() );
    $classes      = 'class="add_to_wishlist"';
    $add          = get_option( 'yith_wcwl_add_to_wishlist_text' );
    $browse       = get_option( 'yith_wcwl_browse_wishlist_text' );
    $added        = get_option( 'yith_wcwl_product_added_text' );

    $output = '';
    $output  .= '<div class="'.( $tooltip == 'yes' ? '' : 'tooltip_no' ).' wishlist button-default yith-wcwl-add-to-wishlist add-to-wishlist-' . esc_attr( $product->get_id() ) . '">';
        $output .= '<div class="yith-wcwl-add-button';
            $output .= $exists ? ' hide" style="display:none;"' : ' show"';
            $output .= '><a href="' . esc_url( htmlspecialchars( YITH_WCWL()->get_wishlist_url() ) ) . '" data-product-id="' . esc_attr( $product->get_id() ) . '" data-product-type="' . esc_attr( $product_type ) . '" ' . $classes . ' >'.$normalicon.'<span class="be__addons__product__action__tooltip">'.esc_html( $add ).'</span></a>';
            $output .= '<i class="fa fa-spinner fa-pulse ajax-loading" style="visibility:hidden"></i>';
        $output .= '</div>';

        $output .= '<div class="yith-wcwl-wishlistaddedbrowse show" style="display:block;"><a class="" href="' . esc_url( $url ) . '">'.$addedicon.'<span class="be__addons__product__action__tooltip">'.esc_html( $browse ).'</span></a></div>';
        $output .= '<div class="yith-wcwl-wishlistexistsbrowse ' . ( $exists ? 'show' : 'hide' ) . '" style="display:' . ( $exists ? 'block' : 'none' ) . '"><a href="' . esc_url( $url ) . '" class="">'.$addedicon.'<span class="be__addons__product__action__tooltip">'.esc_html( $added ).'</span></a></div>';
    $output .= '</div>';
    echo $output;
}



/*------------------------------------------
    PRODUCT COMPARE BUTTON
-------------------------------------------*/
/**
* Usages: Compare button shortcode [yith_compare_button] From "YITH WooCommerce Compare" plugins.
* Plugins URL: https://wordpress.org/plugins/yith-woocommerce-compare/
* File Path: yith-woocommerce-compare/includes/class.yith-woocompare-frontend.php
* The Function "be_addons_woocommerce_compare_button" Depends on YITH WooCommerce Compare plugins. If YITH WooCommerce Compare is installed and actived, then it will work.
*/
function be_addons_woocommerce_compare_button( $buttonstyle = 1, $compare_icon = '<i class="ti ti-reload"></i>' ){

    if( !class_exists( 'YITH_Woocompare' ) ) {
        return;
    }
    global $product;

    $product_id = $product->get_id();
    $comp_link  = site_url() . '?action=yith-woocompare-add-product';
    $comp_link  = add_query_arg('id', $product_id, $comp_link);

    if( $buttonstyle == 1 ){
        echo do_shortcode('[yith_compare_button]');
    }else{
        echo '<a href="'. esc_url( $comp_link ) .'" class="be__addons__compare__button woocommerce product compare-button compare" data-product_id="'. esc_attr( $product_id ) .'" rel="nofollow" title="'.esc_attr__( 'Compare', 'beaddon' ).'">'.$compare_icon.esc_html__( 'Compare', 'beaddon' ).'</a>';
    }
}


/*----------------------------
	CONTACT FORM 7 RETURN ARRAY
-------------------------------*/
function be_addons_get_contact_forms_seven_list(){

	$forms_list = array();
	$forms_args = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
	$forms      = get_posts( $forms_args );

    if( $forms ){
        foreach ( $forms as $form ){
            $forms_list[$form->ID] = $form->post_title;
        }
    }else{
        $forms_list[ esc_html__( 'No contact form found', 'beaddon' ) ] = 0;
    }
    return $forms_list;
}

/*---------------------------
	WP FORMS RETURN ARRAY
-----------------------------*/
function be_addons_get_wpforms_forms_list(){

	$forms_list = array();
	$forms_args = array( 'posts_per_page' => -1, 'post_type'=> 'wpforms' );
	$forms      = get_posts( $forms_args );
    if( $forms ){
        foreach ( $forms as $form ){
            $forms_list[$form->ID] = $form->post_title;
        }
    }else{
        $forms_list[ __( 'Form not found', 'beaddon' ) ] = 0;
    }
    return $forms_list;
}

/*---------------------------
	WE FORM RETURN ARRAY
-----------------------------*/
function be_addons_get_we_forms_list() {

    $forms = [];
    if ( class_exists( 'WeForms' ) ) {
        $_forms = get_posts( [
			'post_type'      => 'wpuf_contact_form',
			'post_status'    => 'publish',
			'posts_per_page' => -1,
			'orderby'        => 'title',
			'order'          => 'ASC',
        ] );

        if ( ! empty( $_forms ) ) {
            $forms = wp_list_pluck( $_forms, 'post_title', 'ID' );
        }
    }
    return $forms;
}

/*---------------------------
	NINJA FORM RETURN ARRAY
-----------------------------*/
function be_addons_get_ninja_forms_list() {

    $form_list = array();
    if ( class_exists( 'Ninja_Forms' ) ) {
        $ninja_forms  = Ninja_Forms()->form()->get_forms();
        if ( ! empty( $ninja_forms ) && ! is_wp_error( $ninja_forms ) ) {
            $form_list = ['0' => esc_html__( 'Select Form', 'beaddon' )];
            foreach ( $ninja_forms as $form ) {   
                $form_list[ $form->get_id() ] = $form->get_setting( 'title' );
            }
        }
    } else {
        $form_list = ['0' => esc_html__( 'Form Not Found.', 'beaddon' ) ];
    }
    return $form_list;
}

/*---------------------------
	CALDERA FORM RETURN ARRAY
-----------------------------*/
function be_addons_get_caldera_forms_list() {

    if ( class_exists( 'Caldera_Forms' ) ) {
		$caldera_forms = Caldera_Forms_Forms::get_forms( true, true );
		$form_list     = ['0' => esc_html__( 'Select Form', 'beaddon' )];
		$form          = array();
        if ( ! empty( $caldera_forms ) && ! is_wp_error( $caldera_forms ) ) {
            foreach ( $caldera_forms as $form ) {
                if ( isset($form['ID']) and isset($form['name'])) {
                    $form_list[$form['ID']] = $form['name'];
                }   
            }
        }
    }else{
        $form_list = ['0' => esc_html__( 'Form Not Found!', 'beaddon' ) ];
    }
    return $form_list;
}

/*---------------------------
	GRAVITY FORM RETURN ARRAY
----------------------------*/
function be_addons_get_gravity_forms_list() {
    if ( class_exists( 'GFForms' ) ) {
		$gravity_forms = \RGFormsModel::get_forms( null, 'title' );
		$form_list     = ['0' => esc_html__( 'Select Form', 'beaddon' )];
        if ( ! empty( $gravity_forms ) && ! is_wp_error( $gravity_forms ) ) {
            foreach ( $gravity_forms as $form ) {   
                $form_list[ $form->id ] = $form->title;
            }
        }
    }else{
        $form_list = ['0' => esc_html__( 'Form Not Found!', 'beaddon' ) ];
    }
    return $form_list;
}

/*----------------------------
    FLUENT FORM LIST ARRAY
------------------------------*/
function be_addons_fluent_form_list(){
    if( function_exists( 'wpFluent' ) ){

        $fluent_forms = wpFluent()->table('fluentform_forms')->select(['id', 'title'])->orderBy('id', 'DESC')->get();
        $form_list    = ['0' => esc_html__( 'Select Form', 'beaddon' )];

        if ($fluent_forms) {
            $form_list[0] = esc_html__('Select a Fluent Form', 'beaddon');
            foreach ($fluent_forms as $form) {
                $form_list[$form->id] = $form->title .' ('.$form->id.')';
            }
        } else {
            $form_list[0] = esc_html__('Create a Form First', 'beaddon');
        }
    }else{
        $form_list = ['0' => esc_html__( 'Form Not Found!', 'beaddon' ) ];
    }
    return $form_list;
}

/*----------------------------
    SPACETHEME WIDGETS CONTROL
-----------------------------*/
function be_addons_widget_control(){
    return [
        'accordion'          => esc_html__( 'Accordion', 'beaddon' ),
        'area_title'         => esc_html__( 'Area Title', 'beaddon' ),
        'box'                => esc_html__( 'Box', 'beaddon' ),
        'cf7'                => esc_html__( 'Contact Form 7', 'beaddon' ),
        'copyright_text'     => esc_html__( 'Copyright Text', 'beaddon' ),
        'counter'            => esc_html__( 'Counter', 'beaddon' ),
        'dual_button'        => esc_html__( 'Dual Button', 'beaddon' ),
        'icon_listing'       => esc_html__( 'Mega Icon Listing', 'beaddon' ),
        'image_carousel'     => esc_html__( 'Image Carousel', 'beaddon' ),
        'info_box'           => esc_html__( 'Info Box', 'beaddon' ),
        'post_carousel'      => esc_html__( 'Post Carousel', 'beaddon' ),
        'position_element'   => esc_html__( 'Position Element', 'beaddon' ),
        'portfolio'          => esc_html__( 'Portfolio', 'beaddon' ),
        'price_table'        => esc_html__( 'Price Table', 'beaddon' ),
        'socials'            => esc_html__( 'Socials', 'beaddon' ),
        'subscriber_form'    => esc_html__( 'Subscriber Form', 'beaddon' ),
        'tabs'               => esc_html__( 'Tabs', 'beaddon' ),
        'teams'              => esc_html__( 'Teams', 'beaddon' ),
        'testimonials'       => esc_html__( 'Testimonial', 'beaddon' ),
        'video_popup_button' => esc_html__( 'Video Popup Button', 'beaddon' ),
        'base_effect_2'      => esc_html__( 'Base Effect 2', 'beaddon' ),
        'image_compare'      => esc_html__( 'Image Compare', 'beaddon' ),
        'be-circle-counter'  => esc_html__( 'Round Counter ', 'beaddon' ),
    ];
}

function be_addons_mime_types( $mimes ) {
    $mimes['json'] = 'application/json';
    $mimes['svg']  = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'be_addons_mime_types');


if( !function_exists( 'be_addons_render_icons' ) ){
        
    /**
     * be_addons_render_icons
     *
     * @param  array $content
     * @param  string $class
     * @return mixed
     */
    function be_addons_render_icons( $content = array(), $class = '' ){

        if ( !is_array( $content ) ) {
            return false;
        }
    
        if ( is_array( $content['value'] ) ) {
            $svg_icon = $content['value']['url'];
        }else{
            $font_icon = $content['value'];
        }
    
        if( !is_array( $content['value'] ) && $font_icon ){
            if($class){
                return '<i class="'.$class.' '.esc_attr( $font_icon ).'"></i>';
            }else{
                return '<i class="'.esc_attr( $font_icon ).'"></i>';
            }
        }
    
        if ( $content['library'] == 'svg' ) {
            try{
                $url_basename = basename( $svg_icon ); 
                $svg_ext      = explode( '.',$url_basename )[1];
    
                $svg_file     = wp_remote_get( $svg_icon );
                $svg_file     = wp_remote_retrieve_body($svg_file );
                $find_string  = '<svg';
                $position     = strpos( $svg_file, $find_string );
                $svg_file_new = substr( $svg_file, $position );
                return $svg_file_new;
            }catch(\Exception $e) {
                return false;
            }
        }
    }
}


function be_addons_image_masking_shapes( $path = 'svgs' ) {

    $widgets_modules = [];
    $dir_path        = BE_ADDONS_DIR_PATH . "assets/img/" . $path;
    $url_path        = BE_ADDONS_DIR_URL . "assets/img/" . $path;
    $dir             = new \DirectoryIterator( $dir_path );

    foreach ( $dir as $fileinfo ) {

        if ( !$fileinfo->isDot() ) {
            $file_name = explode( '.', $fileinfo->getFilename() );
            $widgets_modules[$url_path . '/' . $fileinfo->getFilename()] = [
                'title'      => $file_name[0],
                'width'      => '33%',
                'imagelarge' => $url_path . '/' . $fileinfo->getFilename(),
                'imagesmall' => $url_path . '/' . $fileinfo->getFilename(),
            ];
        }
        
    }

    return $widgets_modules;
}


if ( !function_exists( 'be_addons_kses' ) ) {

    function be_addons_kses( $raw ) {
        $allowed_tags = array(
            'a'                             => array(
                'class'  => array(),
                'href'   => array(),
                'rel'    => array(),
                'title'  => array(),
                'target' => array(),
            ),
            'option'                        => array(
                'value' => array(),
            ),
            'abbr'                          => array(
                'title' => array(),
            ),
            'b'                             => array(),
            'blockquote'                    => array(
                'cite' => array(),
            ),
            'cite'                          => array(
                'title' => array(),
            ),
            'code'                          => array(),
            'del'                           => array(
                'datetime' => array(),
                'title'    => array(),
            ),
            'dd'                            => array(),
            'div'                           => array(
                'class' => array(),
                'title' => array(),
                'style' => array(),
            ),
            'dl'                            => array(),
            'dt'                            => array(),
            'em'                            => array(),
            'h1'                            => array(),
            'h2'                            => array(),
            'h3'                            => array(),
            'h4'                            => array(),
            'h5'                            => array(),
            'h6'                            => array(),
            'i'                             => array(
                'class' => array(),
            ),
            'img'                           => array(
                'alt'    => array(),
                'class'  => array(),
                'height' => array(),
                'src'    => array(),
                'width'  => array(),
            ),
            'li'                            => array(
                'class' => array(),
            ),
            'ol'                            => array(
                'class' => array(),
            ),
            'p'                             => array(
                'class' => array(),
            ),
            'q'                             => array(
                'cite'  => array(),
                'title' => array(),
            ),
            'span'                          => array(
                'class' => array(),
                'title' => array(),
                'style' => array(),
            ),
            'iframe'                        => array(
                'width'       => array(),
                'height'      => array(),
                'scrolling'   => array(),
                'frameborder' => array(),
                'allow'       => array(),
                'src'         => array(),
            ),
            'strike'                        => array(),
            'br'                            => array(),
            'small'                         => array(),
            'strong'                        => array(),
            'data-wow-duration'             => array(),
            'data-wow-delay'                => array(),
            'data-wallpaper-options'        => array(),
            'data-stellar-background-ratio' => array(),
            'ul'                            => array(
                'class' => array(),
            ),
        );
        if ( function_exists( 'wp_kses' ) ) { // WP is here
            $allowed = wp_kses( $raw, $allowed_tags );
        } else {
            $allowed = $raw;
        }
        return $allowed;
    }
}


function beaddon_custom_animation($animations){
    $additional_animations = [
        'Beaddon'            => [
            'befadeIn'      => 'BE_Fade In',
            'befadeInDown'  => 'BE_Fade In Down',
            'befadeInLeft'  => 'BE_Fade In Left',
            'befadeInRight' => 'BE_Fade In Right',
            'befadeInUp'    => 'BE_Fade In Up',
        ],
    ];

    return array_merge( $animations, $additional_animations );
}
//add_filter( 'elementor/controls/animations/additional_animations', 'beaddon_custom_animation' );
