<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Be_Addons_Radio_Image_Control extends \Elementor\Base_Data_Control{

	public function get_type() {
		return 'radioimage';
	}

	public function enqueue() {

		// Register
		wp_register_style( 'radio_ims', plugins_url( '/css/radio_ims.css', __FILE__ ) );
		wp_register_script( 'radio_ims', plugins_url( '/js/radio_ims.js', __FILE__ ), [], false, true );

		// Enqueue
		wp_enqueue_style( 'radio_ims' );
		wp_enqueue_script( 'radio_ims' );

	}

	public function content_template() {
		$control_uid = $this->get_control_uid( '{{name}}' );
	?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper be-addons-radio-img">
				<div class="elementor-image-choices">
					<# _.each( data.options, function( options, value ) { #>
					<div class="image-choose-label-block"
					style="width:{{ options.width }}">
						<input id="<?php echo esc_attr( $control_uid ); ?>{{ options.title }}" type="radio" name="elementor-choose-{{ data.name }}-{{ data._cid }}" value="{{ value }}">
						<label class="elementor-image-choices-label" for="<?php echo esc_attr( $control_uid ); ?>{{ options.title }}" title="{{ options.title }}">
							<img class="imagesmall" src="{{ options.imagesmall }}" alt="{{ options.title }}" />
							<img class="imagelarge" src="{{ options.imagelarge }}" alt="{{ options.title }}" />
							<span class="elementor-screen-only">{{{ options.title }}}</span>
						</label>
					</div>
					<# } ); #>
				</div>
			</div>
		</div>

		<# if ( data.description ) { #>
			<div class="elementor-control-field-description">{{{ data.description }}}</div>
		<# } #>
	<?php
	}

	protected function get_default_settings() {
		return [
			'label_block' => true,
			'options'     => [],
		];
	}
}

Plugin::$instance->controls_manager->register_control( 'radioimage', new Be_Addons_Radio_Image_Control() );
