(function ($) {
    "use strict";

    $(document).ready(function () {

        // Circle Progress Bar
        function animateElements() {
            $('.progressbar').each(function () {
                var elementPos = $(this).offset().top;
                var topOfWindow = $(window).scrollTop();
                var percent = $(this).find('.circle').attr('data-percent');
                var color = $(this).find('.circle').attr('data-color');
                var percentage = parseInt(percent, 10) / parseInt(100, 10);
                var animate = $(this).data('animate');
                if (elementPos < topOfWindow + $(window).height() - 30 && !animate) {
                    $(this).data('animate', true);
                    $(this).find('.circle').circleProgress({
                        startAngle: -Math.PI / 2,
                        value: percent / 100,
                        size: 100,
                        thickness: 8,
                        emptyFill: "rgba(223, 223, 223, 0.32)",
                        fill: {
                            color: color,
							thickness: 16
                        }
                    }).on('circle-animation-progress', function (event, progress, stepValue) {
                        $(this).find('div').text((stepValue * 100).toFixed(0) + "%");
                    }).stop();
                }
            });
        }

        // Show animated elements
        animateElements();
        $(window).scroll(animateElements);

    });

})(jQuery);