;(function ($) {

    /*==============================
        FLOTING EFFECTS
    ================================*/
    function debounce(func, wait, immediate) {
        var timeout;
        return function() {
            var context = this, args = arguments;
            var later = function() {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    $(window).on('elementor/frontend/init', function () {

        var ExtensionHandler = elementorModules.frontend.handlers.Base.extend({

            onInit: function () {
                elementorModules.frontend.handlers.Base.prototype.onInit.apply(this, arguments);
                this.widgetContainer = this.$element.find('.elementor-widget-container')[0];
                this.initFloatingEffects();
            },

            getDefaultSettings: function () {
                return {
                    targets: this.widgetContainer,
                    loop: true,
                    direction: 'alternate',
                    easing: 'easeInOutSine',
                };
            },

            onElementChange: function (changedProp) {
                if (changedProp.indexOf('be_addons_floating') !== -1) {
                    this.runOnElementChange();
                }
            },

            runOnElementChange: debounce(function () {
                this.animation && this.animation.restart();
                this.initFloatingEffects();
            }, 200),

            getConfig: function (key) {
                return this.getElementSettings('be_addons_floating_fx_' + key);
            },


            initFloatingEffects: function () {
                var config = this.getDefaultSettings();

                //console.log(config);

                if (this.getConfig('translate_toggle')) {
                    if (this.getConfig('translate_x.size') || this.getConfig('translate_x.sizes.to')) {
                        config.translateX = {
                            value: [this.getConfig('translate_x.sizes.from') || 0, this.getConfig('translate_x.size') || this.getConfig('translate_x.sizes.to')],
                            duration: this.getConfig('translate_duration.size'),
                            delay: this.getConfig('translate_delay.size') || 0
                        }
                    }
                    if (this.getConfig('translate_y.size') || this.getConfig('translate_y.sizes.to')) {
                        config.translateY = {
                            value: [this.getConfig('translate_y.sizes.from') || 0, this.getConfig('translate_y.size') || this.getConfig('translate_y.sizes.to')],
                            duration: this.getConfig('translate_duration.size'),
                            delay: this.getConfig('translate_delay.size') || 0
                        }
                    }
                }

                if (this.getConfig('rotate_toggle')) {
                    if (this.getConfig('rotate_x.size') || this.getConfig('rotate_x.sizes.to')) {
                        config.rotateX = {
                            value: [this.getConfig('rotate_x.sizes.from') || 0, this.getConfig('rotate_x.size') || this.getConfig('rotate_x.sizes.to')],
                            duration: this.getConfig('rotate_duration.size'),
                            delay: this.getConfig('rotate_delay.size') || 0
                        }
                    }
                    if (this.getConfig('rotate_y.size') || this.getConfig('rotate_y.sizes.to')) {
                        config.rotateY = {
                            value: [this.getConfig('rotate_y.sizes.from') || 0, this.getConfig('rotate_y.size') || this.getConfig('rotate_y.sizes.to')],
                            duration: this.getConfig('rotate_duration.size'),
                            delay: this.getConfig('rotate_delay.size') || 0
                        }
                    }
                    if (this.getConfig('rotate_z.size') || this.getConfig('rotate_z.sizes.to')) {
                        config.rotateZ = {
                            value: [this.getConfig('rotate_z.sizes.from') || 0, this.getConfig('rotate_z.size') || this.getConfig('rotate_z.sizes.to')],
                            duration: this.getConfig('rotate_duration.size'),
                            delay: this.getConfig('rotate_delay.size') || 0
                        }
                    }
                }

                if (this.getConfig('scale_toggle')) {
                    if (this.getConfig('scale_x.size') || this.getConfig('scale_x.sizes.to')) {
                        config.scaleX = {
                            value: [this.getConfig('scale_x.sizes.from') || 0, this.getConfig('scale_x.size') || this.getConfig('scale_x.sizes.to')],
                            duration: this.getConfig('scale_duration.size'),
                            delay: this.getConfig('scale_delay.size') || 0
                        }
                    }
                    if (this.getConfig('scale_y.size') || this.getConfig('scale_y.sizes.to')) {
                        config.scaleY = {
                            value: [this.getConfig('scale_y.sizes.from') || 0, this.getConfig('scale_y.size') || this.getConfig('scale_y.sizes.to')],
                            duration: this.getConfig('scale_duration.size'),
                            delay: this.getConfig('scale_delay.size') || 0
                        }
                    }
                }

                if (this.getConfig('translate_toggle') || this.getConfig('rotate_toggle') || this.getConfig('scale_toggle')) {
                    this.widgetContainer.style.setProperty('will-change', 'transform');
                    this.animation = anime(config);
                }
            }
        });

        elementorFrontend.hooks.addAction('frontend/element_ready/widget', function ($scope) {
            new ExtensionHandler({
                $element: $scope
            });
        });
    });


    /* =====================================
        ENABLE TILT EFFECT
    ========================================*/
    var Be_Addon_Global_Widget = function( $scope, $ ){
        
        var $target  = $scope,
            instance = null,
            editMode = Boolean( elementorFrontend.isEditMode() );
            instance = new Be_Addon_Widget_Plugin( $target );
            instance.init(instance);

    }

    Be_Addon_Widget_Plugin = function( $target ){

        var self      = this,
            sectionId = $target.data('id'),
            settings  = true,
            editMode  = Boolean( elementorFrontend.isEditMode() ),
            $window   = $( window ),
            $body     = $( 'body' ),
            platform  = navigator.platform;

        
        /**
        * Init
        */
        self.init = function(){
            if($target.data('tilt_opt') !='undefined' && $target.data('tilt_opt')){
                self.run_tilt_service( $target );
            }            
            return false;
        };


        self.run_tilt_service = function( $target ){
            
            let settings                 = $target.data('tilt_opt');
            var random_id       = settings['random_id'] ?  settings['random_id'] : 1234;
            var enable_tilt_effect       = settings['enable_tilt_effect']  == 'yes' ? true : false;
            var tilt_reverse             = settings['tilt_reverse']  == 'yes' ? true : false;
            var tilt_maxTilt             = settings['tilt_maxTilt'] ? parseInt( settings['tilt_maxTilt'] ) : 20;
            var tilt_startX              = settings['tilt_startX'] ? parseInt( settings['tilt_startX'] ) : 0;
            var tilt_startY              = settings['tilt_startY'] ? parseInt( settings['tilt_startY'] ) : 0;
            var tilt_perspective         = settings['tilt_perspective'] ? parseInt( settings['tilt_perspective'] ) : 1000;
            var tilt_scale               = settings['tilt_scale'] ? settings['tilt_scale'] : 1.5;
            var tilt_speed               = settings['tilt_speed'] ? parseInt( settings['tilt_speed'] ) : 300;
            var tilt_transition          = settings['tilt_transition']  == 'yes' ? true : false;
            var tilt_disableAxis         = (settings['tilt_disableAxis']  == 'y' || settings['tilt_disableAxis']  == 'x' ) ? String(settings['tilt_disableAxis']) : null;
            var tilt_reset               = settings['tilt_reset']  == 'yes' ? true : false;
            var tilt_glare               = settings['tilt_glare']  == 'yes' ? true : false;
            var tilt_maxGlare            = settings['tilt_maxGlare'] ? settings['tilt_maxGlare'] : 0.5;
            var tilt_mouse_event_element = settings['tilt_mouse_event_element'] ? settings['tilt_mouse_event_element']  : null;
            var tilt_fullpage_listening  = settings['tilt_fullpage_listening']  == 'yes' ? true : false;
            var tilt_gyroscope           = settings['tilt_gyroscope']  == 'yes' ? true : false;
            var tilt_gyroscopeMinAngleX  = settings['tilt_gyroscopeMinAngleX'] ? parseInt( settings['tilt_gyroscopeMinAngleX'] ) : -45;
            var tilt_gyroscopeMaxAngleX  = settings['tilt_gyroscopeMaxAngleX'] ? parseInt( settings['tilt_gyroscopeMaxAngleX'] ) : 45;
            var tilt_gyroscopeMinAngleY  = settings['tilt_gyroscopeMinAngleY'] ? parseInt( settings['tilt_gyroscopeMinAngleY'] ) : -45;
            var tilt_gyroscopeMaxAngleY  = settings['tilt_gyroscopeMaxAngleY'] ? parseInt( settings['tilt_gyroscopeMaxAngleY'] ) : 45;
            var tilt_gyroscopeSamples    = settings['tilt_gyroscopeSamples'] ? parseInt( settings['tilt_gyroscopeSamples'] ) : 10;

            //var activation_class = $target.find('.elementor-widget-container').eq(0);
            var activation_class = $target.data('tiltid');
            var activation_class = document.querySelector('[data-tiltid="'+activation_class+'"]');

            var tilt_options = {
                maxTilt    : tilt_maxTilt,
                perspective: tilt_perspective,
                easing     : "cubic-bezier(.03,.98,.52,.99)",
                scale      : tilt_scale,
                speed      : tilt_speed,
                transition : tilt_transition,
                disableAxis: tilt_disableAxis,
                reset      : tilt_reset,
                glare      : tilt_glare,
                maxGlare   : tilt_maxGlare
            };

            var vanila_tilt_options = {
                reverse    : tilt_reverse, // reverse the tilt direction
                max        : tilt_maxTilt, // max tilt rotation (degrees)
                startX     : tilt_startX, // the starting tilt on the X axis, in degrees.
                startY     : tilt_startY, // the starting tilt on the Y axis, in degrees.
                perspective: tilt_perspective, // Transform perspective, the lower the more extreme the tilt gets.
                scale      : tilt_scale, // 2 = 200%, 1.5 = 150%, etc..
                speed      : tilt_speed, // Speed of the enter/exit transition
                transition : tilt_transition, // Set a transition on enter/exit.
                axis       : tilt_disableAxis, // What axis should be disabled. Can be X or Y.
                reset      : tilt_reset, // If the tilt effect has to be reset on exit.
                easing     : "cubic-bezier(.03,.98,.52,.99)",// Easing on enter/exit.
                glare      : tilt_glare, // if it should have a "glare" effect
                "max-glare": tilt_maxGlare,  // the maximum "glare" opacity (1 = 100%, 0.5 = 50%)

                "glare-prerender"    : false, // Must False Always Otherwise Need To Create Another Class For Glare.
                "mouse-event-element": tilt_mouse_event_element, // css-selector or link to HTML-element what will be listen mouse events
                "full-page-listening":  tilt_fullpage_listening,

                gyroscope         : tilt_gyroscope,
                gyroscopeMinAngleX: tilt_gyroscopeMinAngleX,
                gyroscopeMaxAngleX: tilt_gyroscopeMaxAngleX,
                gyroscopeMinAngleY: tilt_gyroscopeMinAngleY,
                gyroscopeMaxAngleY: tilt_gyroscopeMaxAngleY,
                gyroscopeSamples  : tilt_gyroscopeSamples      // How many gyroscope moves to decide the starting position.
            }

            if( enable_tilt_effect ){
                /* const tilt = $target.tilt(tilt_options); */
                VanillaTilt.init(activation_class, vanila_tilt_options);
            }
           
        };

    }

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', Be_Addon_Global_Widget );
    });
})(jQuery);