<?php

/***********************************
 * Signup Form Widget
 ************************************/
class Be_Addons_SignUp {
    public function __construct() {

        add_action( 'init', [$this, 'form_submit'] );
        add_action( 'init', [$this, '_startSession'], 1 );
    }

    function _startSession() {
        if ( !session_id() ) {
            session_start();
        }
    }

    function form_validate( $data ) {

        unset( $_SESSION["be_addons_reg_msg"] );

        //name
        if ( isset( $data['name'] ) && $data['name'] == '' ) {
            $_SESSION["be_addons_reg_msg"]['name'] = esc_html__( 'Name cannot be empty', 'beaddon' );
        }

        // username
        if ( isset( $data['username'] ) && $data['username'] == '' ) {
            $_SESSION["be_addons_reg_msg"]['username'] = esc_html__( 'Username cannot be empty', 'beaddon' );
        }

        if ( isset( $data['username'] ) ) {
            if ( username_exists( $data['username'] ) ) {
                $_SESSION["be_addons_reg_msg"]['username'] = esc_html__( 'UserName already exist', 'beaddon' );
            }
        }

        // email
        if ( isset( $data['email'] ) && $data['email'] == '' ) {
            $_SESSION["be_addons_reg_msg"]['email'] = esc_html__( 'Email cannot be empty', 'beaddon' );
        } else {

            if ( !is_email( $data['email'] ) ) {
                $_SESSION["be_addons_reg_msg"]['valid_email'] = esc_html__( 'Email is not valid', 'beaddon' );
            }

            if ( email_exists( $data['email'] ) ) {
                $_SESSION["be_addons_reg_msg"]['exist_email'] = esc_html__( 'Email is already exist', 'beaddon' );
            }
        }

        //password
        if ( isset( $data['password'] ) && isset( $data['cpassword'] ) ) {
            if ( trim( $data['password'] ) != trim( $data['cpassword'] ) ) {
                $_SESSION["be_addons_reg_msg"]['password'] = esc_html__( 'Password not macth', 'beaddon' );
            }
        }

        if ( isset( $_SESSION["be_addons_reg_msg"] ) ) {
            return true;
        }
        return false;
    }

    public function form_submit() {

        $retrieved_nonce = isset( $_REQUEST['_wpnonce'] ) ? $_REQUEST['_wpnonce'] : '';
        if ( !wp_verify_nonce( $retrieved_nonce, 'be_addons_registration_action' ) ) {
            return;
        }

        if ( !session_id() ) {
            session_start();
        }

        $error = $this->form_validate( $_REQUEST );
        if ( $error == false ) {
            $this->user_registration_form_completion( $_REQUEST );
        }

        $request = $_SERVER["HTTP_REFERER"];
        if ( isset( $_REQUEST['be_redirect'] ) ) {
            $request = $_REQUEST['be_redirect'];
        }
        wp_redirect( $request );exit;
    }

    function user_registration_form_completion( $data ) {

        $userdata = array(
            'first_name' => sanitize_text_field( $data['name'] ),
            'last_name'  => '',
            'user_login' => sanitize_text_field( trim( $data['username'] ) ),
            'user_email' => trim( sanitize_email( $data['email'] ) ),
            'user_pass'  => trim( sanitize_text_field( $data['password'] ) ),
        );

        $user = wp_insert_user( apply_filters( 'be_addons_new_user_args', $userdata ) );

        if ( is_wp_error( $user ) ) {
            $_SESSION["be_addons_reg_msg"]['submit_msg'] = $user->get_error_message();
        } else {

            $creds = array(
                'user_login'    => sanitize_text_field( $data['username'] ),
                'user_password' => sanitize_text_field( $data['password'] ),
                'remember'      => true,
            );

            $user = wp_signon( $creds, false );

            if ( is_wp_error( $user ) ) {
                wp_set_current_user( $user->data->ID, $data['username'] );
                wp_set_auth_cookie( $user->data->ID, true, false );
            }

            do_action( 'be_addons_user_created_successfully', $user );
            $_SESSION["be_addons_reg_msg_success"] = esc_html__( 'Registration Success', 'beaddon' );
        }
    }

}

new Be_Addons_SignUp();