<?php

/***********************************
 * SignIn Form Widget
 ************************************/
class Be_Addons_SignIn {

    public $errors  = [];
    public $success = null;

    public function __construct() {

        add_action( 'init', [$this, 'form_submit'] );
        add_action( 'init', [$this, '_startSession'], 1 );
    }

    function _startSession() {
        if ( !session_id() ) {
            session_start();
        }
    }

    function form_validate( $data ) {

        if ( isset( $_SESSION["be_addons_login_msg"] ) ) {
            unset( $_SESSION["be_addons_login_msg"] );
        }

        if ( isset( $data['password'] ) && $data['password'] == '' ) {
            $this->errors                                   = esc_html__( 'Password should not empty', 'beaddon' );
            $_SESSION["be_addons_login_msg"]['valid_email'] = esc_html__( 'Password should not empty', 'beaddon' );
        }

        if ( isset( $_SESSION["be_addons_login_msg"] ) ) {
            return true;
        }

        return false;

    }
    public function login( $data ) {

        $creds = array(
            'user_login'    => sanitize_text_field( $data['username'] ),
            'user_password' => sanitize_text_field( $data['password'] ),
            'remember'      => true,
        );

        if ( is_email( $data['username'] ) ) {
            $creds['user_email'] = $data['username'];
        }

        $creds['remember'] = sanitize_text_field( isset( $_POST['rememberme'] ) ? true : false );
        $user              = wp_signon( $creds, false );
        $userID            = $user->ID;

        wp_set_current_user( $userID, $data['username'] );
        wp_set_auth_cookie( $userID, true, false );

        if ( is_wp_error( $user ) ) {
            $_SESSION["be_addons_login_msg"]['valid_email'] = $user->get_error_message();
        } else {
            $this->success                           = esc_html__( 'Login Success', 'beaddon' );
            $_SESSION["be_addons_login_success_msg"] = esc_html__( 'Login Success', 'beaddon' );

        }
    }

    public function form_submit() {

        $retrieved_nonce = isset( $_REQUEST['_wpnonce'] ) ? $_REQUEST['_wpnonce'] : '';
        if ( !wp_verify_nonce( $retrieved_nonce, 'be_addons_login_action' ) ) {
            return;
        }

        if ( !session_id() ) {
            session_start();

        }

        $error = $this->form_validate( $_REQUEST );

        if ( $error == false ) {
            $this->login( $_REQUEST );
        }

        $request = $_SERVER["HTTP_REFERER"];

        if ( isset( $_REQUEST['be_redirect'] ) ) {
            $request = $_REQUEST['be_redirect'];
        }

        wp_redirect( $request );exit;
    }

}

new Be_Addons_SignIn();