<?php

/***********************************
 * SignIn Form Widget
 ************************************/
class Be_Addons_Get_ {

    public $errors  = [];
    public $success = null;

    public function __construct() {

        add_action( 'init', [$this, 'form_submit'] );
        add_action( 'init', [$this, '_startSession'], 1 );
    }

    function _startSession() {
        if ( !session_id() ) {
            session_start();
        }
    }

    public function form_submit() {

        if ( isset( $_POST['formType'] ) && wp_verify_nonce( $_POST['formType'], 'userGetPassword' ) ) {

            if ( !session_id() ) {
                session_start();
            }

            global $getPasswordError, $getPasswordSuccess;
    
            $email = trim( $_POST['user_login'] );
    
            if ( empty( $email ) ) {
                $getPasswordError = '<strong>Error! </strong>Enter a e-mail address.';
            } else if ( !is_email( $email ) ) {
                $getPasswordError = '<strong>Error! </strong>Invalid e-mail address.';
            } else if ( !email_exists( $email ) ) {
                $getPasswordError = '<strong>Error! </strong>There is no user registered with that email address.';
            } else {
    
                // lets generate our new password
                $random_password = wp_generate_password( 12, false );
    
                // Get user data by field and data, other field are ID, slug, slug and login
                $user = get_user_by( 'email', $email );
    
                $update_user = wp_update_user( array(
                    'ID'        => $user->ID,
                    'user_pass' => $random_password,
                ) );
    
                // if  update user return true then lets send user an email containing the new password
                if ( $update_user ) {
                    $to      = $email;
                    $subject = 'Your new password';
                    $sender  = get_bloginfo( 'name' );
                    $message = 'Your new password is: ' . $random_password;
                    $headers = array( 'Content-Type: text/html; charset=UTF-8' );
    
                    $mail = wp_mail( $to, $subject, $message, $headers );
                    if ( $mail ) {
                        $getPasswordSuccess = '<strong>Success! </strong>Check your email address for you new password.';
                    }
                } else {
                    $getPasswordError = '<strong>Error! </strong>Oops something went wrong.';
                }
            }

            $request = $_SERVER["HTTP_REFERER"];

            if ( isset( $_REQUEST['be_redirect'] ) ) {
                $request = $_REQUEST['be_redirect'];
            }
    
            wp_redirect( $request );
            
            exit;

        }

    }

}

new Be_Addons_Get_();